/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ServerClient;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.impl.Translator;
import org.apache.accumulo.core.client.impl.Translators;
import org.apache.accumulo.core.client.impl.thrift.ClientService;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.data.thrift.MapFileInfo;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.NamingThreadFactory;
import org.apache.accumulo.core.util.StopWatch;
import org.apache.accumulo.fate.util.LoggingRunnable;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.util.FileUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.htrace.wrappers.TraceRunnable;
import org.apache.thrift.TServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkImporter {
    private static final Logger log = LoggerFactory.getLogger(BulkImporter.class);
    private StopWatch<Timers> timer;
    private final ClientContext context;
    private String tableId;
    private long tid;
    private boolean setTime;
    static final byte[] byte0 = new byte[]{0};

    public static List<String> bulkLoad(ClientContext context, long tid, String tableId, List<String> files, String errorDir, boolean setTime) throws IOException, AccumuloException, AccumuloSecurityException, ThriftTableOperationException {
        AssignmentStats stats = new BulkImporter(context, tid, tableId, setTime).importFiles(files, new Path(errorDir));
        ArrayList<String> result = new ArrayList<String>();
        for (Path p : stats.completeFailures.keySet()) {
            result.add(p.toString());
        }
        return result;
    }

    public BulkImporter(ClientContext context, long tid, String tableId, boolean setTime) {
        this.context = context;
        this.tid = tid;
        this.tableId = tableId;
        this.setTime = setTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssignmentStats importFiles(List<String> files, Path failureDir) throws IOException, AccumuloException, AccumuloSecurityException, ThriftTableOperationException {
        int numThreads = this.context.getConfiguration().getCount(Property.TSERV_BULK_PROCESS_THREADS);
        int numAssignThreads = this.context.getConfiguration().getCount(Property.TSERV_BULK_ASSIGNMENT_THREADS);
        this.timer = new StopWatch(Timers.class);
        this.timer.start((Enum)Timers.TOTAL);
        Configuration conf = CachedConfiguration.getInstance();
        VolumeManagerImpl.get(this.context.getConfiguration());
        final VolumeManager fs = VolumeManagerImpl.get(this.context.getConfiguration());
        HashSet<Path> paths = new HashSet<Path>();
        for (String file : files) {
            paths.add(new Path(file));
        }
        AssignmentStats assignmentStats = new AssignmentStats(paths.size());
        final SortedMap<Path, List<KeyExtent>> completeFailures = Collections.synchronizedSortedMap(new TreeMap());
        ClientService.Client client = null;
        final TabletLocator locator = TabletLocator.getLocator((ClientContext)this.context, (String)this.tableId);
        try {
            final SortedMap<Path, List<TabletLocator.TabletLocation>> assignments = Collections.synchronizedSortedMap(new TreeMap());
            this.timer.start((Enum)Timers.EXAMINE_MAP_FILES);
            ExecutorService threadPool = Executors.newFixedThreadPool(numThreads, (ThreadFactory)new NamingThreadFactory("findOverlapping"));
            for (Path path : paths) {
                final Path mapFile = path;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        List<Object> tabletsToAssignMapFileTo = Collections.emptyList();
                        try {
                            tabletsToAssignMapFileTo = BulkImporter.findOverlappingTablets(BulkImporter.this.context, fs, locator, mapFile);
                        }
                        catch (Exception ex) {
                            log.warn("Unable to find tablets that overlap file " + mapFile.toString(), (Throwable)ex);
                        }
                        log.debug("Map file " + mapFile + " found to overlap " + tabletsToAssignMapFileTo.size() + " tablets");
                        if (tabletsToAssignMapFileTo.size() == 0) {
                            List empty = Collections.emptyList();
                            completeFailures.put(mapFile, empty);
                        } else {
                            assignments.put(mapFile, tabletsToAssignMapFileTo);
                        }
                    }
                };
                threadPool.submit((Runnable)new TraceRunnable((Runnable)new LoggingRunnable(log, runnable)));
            }
            threadPool.shutdown();
            while (!threadPool.isTerminated()) {
                try {
                    threadPool.awaitTermination(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.timer.stop((Enum)Timers.EXAMINE_MAP_FILES);
            assignmentStats.attemptingAssignments(assignments);
            Map<Path, List<KeyExtent>> assignmentFailures = this.assignMapFiles(this.context, conf, fs, this.tableId, assignments, paths, numAssignThreads, numThreads);
            assignmentStats.assignmentsFailed(assignmentFailures);
            TreeMap failureCount = new TreeMap();
            for (Map.Entry entry : assignmentFailures.entrySet()) {
                failureCount.put(entry.getKey(), 1);
            }
            long sleepTime = 2000L;
            while (assignmentFailures.size() > 0) {
                sleepTime = Math.min(sleepTime * 2L, 60000L);
                locator.invalidateCache();
                this.timer.start((Enum)Timers.SLEEP);
                UtilWaitThread.sleepUninterruptibly((long)sleepTime, (TimeUnit)TimeUnit.MILLISECONDS);
                this.timer.stop((Enum)Timers.SLEEP);
                log.debug("Trying to assign " + assignmentFailures.size() + " map files that previously failed on some key extents");
                assignments.clear();
                for (Map.Entry<Path, List<KeyExtent>> entry : assignmentFailures.entrySet()) {
                    Iterator<KeyExtent> keListIter = entry.getValue().iterator();
                    ArrayList<TabletLocator.TabletLocation> tabletsToAssignMapFileTo = new ArrayList<TabletLocator.TabletLocation>();
                    while (keListIter.hasNext()) {
                        KeyExtent ke = keListIter.next();
                        this.timer.start((Enum)Timers.QUERY_METADATA);
                        try {
                            tabletsToAssignMapFileTo.addAll(BulkImporter.findOverlappingTablets(this.context, fs, locator, entry.getKey(), ke));
                            keListIter.remove();
                        }
                        catch (Exception ex) {
                            log.warn("Exception finding overlapping tablets, will retry tablet " + ke, (Throwable)ex);
                        }
                        this.timer.stop((Enum)Timers.QUERY_METADATA);
                    }
                    if (tabletsToAssignMapFileTo.size() <= 0) continue;
                    assignments.put(entry.getKey(), tabletsToAssignMapFileTo);
                }
                assignmentStats.attemptingAssignments(assignments);
                Map<Path, List<KeyExtent>> assignmentFailures2 = this.assignMapFiles(this.context, conf, fs, this.tableId, assignments, paths, numAssignThreads, numThreads);
                assignmentStats.assignmentsFailed(assignmentFailures2);
                for (Map.Entry<Path, List<KeyExtent>> entry : assignmentFailures2.entrySet()) {
                    assignmentFailures.get(entry.getKey()).addAll((Collection<KeyExtent>)entry.getValue());
                    Integer fc = (Integer)failureCount.get(entry.getKey());
                    if (fc == null) {
                        fc = 0;
                    }
                    failureCount.put(entry.getKey(), fc + 1);
                }
                Iterator<Map.Entry<Path, List<KeyExtent>>> iterator = assignmentFailures.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Path, List<KeyExtent>> entry;
                    entry = iterator.next();
                    if (entry.getValue().size() != 0) continue;
                    iterator.remove();
                }
                Set failureIter = failureCount.entrySet();
                for (Map.Entry entry3 : failureIter) {
                    int retries = this.context.getConfiguration().getCount(Property.TSERV_BULK_RETRY);
                    if ((Integer)entry3.getValue() <= retries || assignmentFailures.get(entry3.getKey()) == null) continue;
                    log.error("Map file " + entry3.getKey() + " failed more than " + retries + " times, giving up.");
                    completeFailures.put((Path)entry3.getKey(), assignmentFailures.get(entry3.getKey()));
                    assignmentFailures.remove(entry3.getKey());
                }
            }
            assignmentStats.assignmentsAbandoned(completeFailures);
            Set<Path> failedFailures = this.processFailures(completeFailures);
            assignmentStats.unrecoveredMapFiles(failedFailures);
            this.timer.stop((Enum)Timers.TOTAL);
            this.printReport(paths);
            AssignmentStats assignmentStats2 = assignmentStats;
            return assignmentStats2;
        }
        finally {
            if (client != null) {
                ServerClient.close(client);
            }
        }
    }

    private void printReport(Set<Path> paths) {
        long totalTime = 0L;
        for (Timers t : Timers.values()) {
            if (t == Timers.TOTAL) continue;
            totalTime += this.timer.get((Enum)t);
        }
        ArrayList<String> files = new ArrayList<String>();
        for (Path path : paths) {
            files.add(path.getName());
        }
        Collections.sort(files);
        log.debug("BULK IMPORT TIMING STATISTICS");
        log.debug("Files: " + files);
        log.debug(String.format("Examine map files    : %,10.2f secs %6.2f%s", this.timer.getSecs((Enum)Timers.EXAMINE_MAP_FILES), 100.0 * (double)this.timer.get((Enum)Timers.EXAMINE_MAP_FILES) / (double)this.timer.get((Enum)Timers.TOTAL), "%"));
        log.debug(String.format("Query %-14s : %,10.2f secs %6.2f%s", "accumulo.metadata", this.timer.getSecs((Enum)Timers.QUERY_METADATA), 100.0 * (double)this.timer.get((Enum)Timers.QUERY_METADATA) / (double)this.timer.get((Enum)Timers.TOTAL), "%"));
        log.debug(String.format("Import Map Files     : %,10.2f secs %6.2f%s", this.timer.getSecs((Enum)Timers.IMPORT_MAP_FILES), 100.0 * (double)this.timer.get((Enum)Timers.IMPORT_MAP_FILES) / (double)this.timer.get((Enum)Timers.TOTAL), "%"));
        log.debug(String.format("Sleep                : %,10.2f secs %6.2f%s", this.timer.getSecs((Enum)Timers.SLEEP), 100.0 * (double)this.timer.get((Enum)Timers.SLEEP) / (double)this.timer.get((Enum)Timers.TOTAL), "%"));
        log.debug(String.format("Misc                 : %,10.2f secs %6.2f%s", (double)(this.timer.get((Enum)Timers.TOTAL) - totalTime) / 1000.0, 100.0 * (double)(this.timer.get((Enum)Timers.TOTAL) - totalTime) / (double)this.timer.get((Enum)Timers.TOTAL), "%"));
        log.debug(String.format("Total                : %,10.2f secs", this.timer.getSecs((Enum)Timers.TOTAL)));
    }

    private Set<Path> processFailures(Map<Path, List<KeyExtent>> completeFailures) {
        Set<Map.Entry<Path, List<KeyExtent>>> es = completeFailures.entrySet();
        if (completeFailures.size() == 0) {
            return Collections.emptySet();
        }
        log.debug("The following map files failed ");
        for (Map.Entry<Path, List<KeyExtent>> entry : es) {
            List<KeyExtent> extents = entry.getValue();
            for (KeyExtent keyExtent : extents) {
                log.debug("\t" + entry.getKey() + " -> " + keyExtent);
            }
        }
        return Collections.emptySet();
    }

    private static List<KeyExtent> extentsOf(List<TabletLocator.TabletLocation> locations) {
        ArrayList<KeyExtent> result = new ArrayList<KeyExtent>(locations.size());
        for (TabletLocator.TabletLocation tl : locations) {
            result.add(tl.tablet_extent);
        }
        return result;
    }

    private Map<Path, List<AssignmentInfo>> estimateSizes(final AccumuloConfiguration acuConf, final Configuration conf, final VolumeManager vm, Map<Path, List<TabletLocator.TabletLocation>> assignments, Collection<Path> paths, int numThreads) {
        long t1 = System.currentTimeMillis();
        final TreeMap<Path, Long> mapFileSizes = new TreeMap<Path, Long>();
        try {
            for (Path path : paths) {
                FileSystem fs = vm.getVolumeByPath(path).getFileSystem();
                mapFileSizes.put(path, fs.getContentSummary(path).getLength());
            }
        }
        catch (IOException e) {
            log.error("Failed to get map files in for {}: {}", new Object[]{paths, e.getMessage(), e});
            throw new RuntimeException(e);
        }
        final Map<Path, List<AssignmentInfo>> ais = Collections.synchronizedMap(new TreeMap());
        ExecutorService threadPool = Executors.newFixedThreadPool(numThreads, (ThreadFactory)new NamingThreadFactory("estimateSizes"));
        for (final Map.Entry entry : assignments.entrySet()) {
            if (((List)entry.getValue()).size() == 1) {
                TabletLocator.TabletLocation tabletLocation = (TabletLocator.TabletLocation)((List)entry.getValue()).get(0);
                ais.put((Path)entry.getKey(), Collections.singletonList(new AssignmentInfo(tabletLocation.tablet_extent, (Long)mapFileSizes.get(entry.getKey()))));
                continue;
            }
            Runnable estimationTask = new Runnable(){

                @Override
                public void run() {
                    Map<Object, Object> estimatedSizes = null;
                    try {
                        estimatedSizes = FileUtil.estimateSizes(acuConf, (Path)entry.getKey(), (Long)mapFileSizes.get(entry.getKey()), BulkImporter.extentsOf((List)entry.getValue()), conf, vm);
                    }
                    catch (IOException e) {
                        log.warn("Failed to estimate map file sizes {}", (Object)e.getMessage());
                    }
                    if (estimatedSizes == null) {
                        estimatedSizes = new TreeMap();
                        long estSize = (long)((double)((Long)mapFileSizes.get(entry.getKey())).longValue() / (double)((List)entry.getValue()).size());
                        for (TabletLocator.TabletLocation tl : (List)entry.getValue()) {
                            estimatedSizes.put(tl.tablet_extent, estSize);
                        }
                    }
                    ArrayList<AssignmentInfo> assignmentInfoList = new ArrayList<AssignmentInfo>(estimatedSizes.size());
                    for (Map.Entry entry2 : estimatedSizes.entrySet()) {
                        assignmentInfoList.add(new AssignmentInfo((KeyExtent)entry2.getKey(), (Long)entry2.getValue()));
                    }
                    ais.put(entry.getKey(), assignmentInfoList);
                }
            };
            threadPool.submit((Runnable)new TraceRunnable((Runnable)new LoggingRunnable(log, estimationTask)));
        }
        threadPool.shutdown();
        while (!threadPool.isTerminated()) {
            try {
                threadPool.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.error("Encountered InterruptedException while waiting for the threadPool to terminate.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        long t2 = System.currentTimeMillis();
        log.debug(String.format("Estimated map files sizes in %6.2f secs", (double)(t2 - t1) / 1000.0));
        return ais;
    }

    private static Map<KeyExtent, String> locationsOf(Map<Path, List<TabletLocator.TabletLocation>> assignments) {
        HashMap<KeyExtent, String> result = new HashMap<KeyExtent, String>();
        for (List<TabletLocator.TabletLocation> entry : assignments.values()) {
            for (TabletLocator.TabletLocation tl : entry) {
                result.put(tl.tablet_extent, tl.tablet_location);
            }
        }
        return result;
    }

    private Map<Path, List<KeyExtent>> assignMapFiles(ClientContext context, Configuration conf, VolumeManager fs, String tableId, Map<Path, List<TabletLocator.TabletLocation>> assignments, Collection<Path> paths, int numThreads, int numMapThreads) {
        this.timer.start((Enum)Timers.EXAMINE_MAP_FILES);
        Map<Path, List<AssignmentInfo>> assignInfo = this.estimateSizes(context.getConfiguration(), conf, fs, assignments, paths, numMapThreads);
        this.timer.stop((Enum)Timers.EXAMINE_MAP_FILES);
        this.timer.start((Enum)Timers.IMPORT_MAP_FILES);
        Map<Path, List<KeyExtent>> ret = this.assignMapFiles(tableId, assignInfo, BulkImporter.locationsOf(assignments), numThreads);
        this.timer.stop((Enum)Timers.IMPORT_MAP_FILES);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Path, List<KeyExtent>> assignMapFiles(String tableName, Map<Path, List<AssignmentInfo>> assignments, Map<KeyExtent, String> locations, int numThreads) {
        String location;
        TreeMap<KeyExtent, Object> assignmentsPerTablet = new TreeMap<KeyExtent, Object>();
        for (Map.Entry<Path, List<AssignmentInfo>> entry : assignments.entrySet()) {
            Path mapFile = entry.getKey();
            List<AssignmentInfo> list = entry.getValue();
            for (AssignmentInfo ai : list) {
                ArrayList<PathSize> mapFiles = (ArrayList<PathSize>)assignmentsPerTablet.get(ai.ke);
                if (mapFiles == null) {
                    mapFiles = new ArrayList<PathSize>();
                    assignmentsPerTablet.put(ai.ke, mapFiles);
                }
                mapFiles.add(new PathSize(mapFile, ai.estSize));
            }
        }
        Map<Path, List<KeyExtent>> assignmentFailures = Collections.synchronizedMap(new TreeMap());
        TreeMap assignmentsPerTabletServer = new TreeMap();
        for (Map.Entry entry : assignmentsPerTablet.entrySet()) {
            KeyExtent keyExtent = (KeyExtent)entry.getKey();
            location = locations.get(keyExtent);
            if (location == null) {
                for (PathSize pathSize : (List)entry.getValue()) {
                    Map<Path, List<KeyExtent>> map = assignmentFailures;
                    synchronized (map) {
                        List<KeyExtent> failures = assignmentFailures.get(pathSize.path);
                        if (failures == null) {
                            failures = new ArrayList<KeyExtent>();
                            assignmentFailures.put(pathSize.path, failures);
                        }
                        failures.add(keyExtent);
                    }
                }
                log.warn("Could not assign " + ((List)entry.getValue()).size() + " map files to tablet " + keyExtent + " because it had no location, will retry ...");
                continue;
            }
            TreeMap apt = (TreeMap)assignmentsPerTabletServer.get(location);
            if (apt == null) {
                apt = new TreeMap();
                assignmentsPerTabletServer.put(location, apt);
            }
            apt.put(entry.getKey(), entry.getValue());
        }
        ExecutorService threadPool = Executors.newFixedThreadPool(numThreads, (ThreadFactory)new NamingThreadFactory("submit"));
        for (Map.Entry entry : assignmentsPerTabletServer.entrySet()) {
            location = (String)entry.getKey();
            threadPool.submit(new AssignmentTask(assignmentFailures, tableName, location, (Map)entry.getValue()));
        }
        threadPool.shutdown();
        while (!threadPool.isTerminated()) {
            try {
                threadPool.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                log.error("Encountered InterruptedException while waiting for the thread pool to terminate.", (Throwable)interruptedException);
                throw new RuntimeException(interruptedException);
            }
        }
        return assignmentFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<KeyExtent> assignMapFiles(ClientContext context, HostAndPort location, Map<KeyExtent, List<PathSize>> assignmentsPerTablet) throws AccumuloException, AccumuloSecurityException {
        List list;
        long timeInMillis = context.getConfiguration().getTimeInMillis(Property.TSERV_BULK_TIMEOUT);
        TabletClientService.Client client = ThriftUtil.getTServerClient((HostAndPort)location, (ClientContext)context, (long)timeInMillis);
        try {
            HashMap files = new HashMap();
            for (Map.Entry<KeyExtent, List<PathSize>> entry : assignmentsPerTablet.entrySet()) {
                HashMap<String, MapFileInfo> tabletFiles = new HashMap<String, MapFileInfo>();
                files.put(entry.getKey(), tabletFiles);
                for (PathSize pathSize : entry.getValue()) {
                    MapFileInfo mfi = new MapFileInfo(pathSize.estSize);
                    tabletFiles.put(pathSize.path.toString(), mfi);
                }
            }
            log.debug("Asking " + location + " to bulk load " + files);
            List failures = client.bulkImport(Tracer.traceInfo(), context.rpcCreds(), this.tid, Translator.translate(files, (Translator)Translators.KET), this.setTime);
            list = Translator.translate((Collection)failures, (Translator)Translators.TKET);
        }
        catch (Throwable throwable) {
            try {
                ThriftUtil.returnClient((TServiceClient)((TServiceClient)client));
                throw throwable;
            }
            catch (ThriftSecurityException e) {
                throw new AccumuloSecurityException(e.user, e.code, (Throwable)e);
            }
            catch (Throwable t) {
                log.error("Encountered unknown exception in assignMapFiles.", t);
                throw new AccumuloException(t);
            }
        }
        ThriftUtil.returnClient((TServiceClient)((TServiceClient)client));
        return list;
    }

    public static List<TabletLocator.TabletLocation> findOverlappingTablets(ClientContext context, VolumeManager fs, TabletLocator locator, Path file) throws Exception {
        return BulkImporter.findOverlappingTablets(context, fs, locator, file, null, null);
    }

    public static List<TabletLocator.TabletLocation> findOverlappingTablets(ClientContext context, VolumeManager fs, TabletLocator locator, Path file, KeyExtent failed) throws Exception {
        locator.invalidateCache(failed);
        Text start = BulkImporter.getStartRowForExtent(failed);
        return BulkImporter.findOverlappingTablets(context, fs, locator, file, start, failed.getEndRow());
    }

    protected static Text getStartRowForExtent(KeyExtent extent) {
        Text start = extent.getPrevEndRow();
        if (start != null) {
            start = new Text(start);
            start.append(byte0, 0, 1);
        }
        return start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TabletLocator.TabletLocation> findOverlappingTablets(ClientContext context, VolumeManager vm, TabletLocator locator, Path file, Text startRow, Text endRow) throws Exception {
        ArrayList<TabletLocator.TabletLocation> result = new ArrayList<TabletLocator.TabletLocation>();
        List columnFamilies = Collections.emptyList();
        String filename = file.toString();
        FileSystem fs = vm.getVolumeByPath(file).getFileSystem();
        try (FileSKVIterator reader = ((FileOperations.OpenReaderOperationBuilder)FileOperations.getInstance().newReaderBuilder().forFile(filename, fs, fs.getConf()).withTableConfiguration(context.getConfiguration())).seekToBeginning().build();){
            Text row = startRow;
            if (row == null) {
                row = new Text();
            }
            while (true) {
                reader.seek(new Range(row, null), columnFamilies, false);
                if (!reader.hasTop()) {
                } else {
                    row = ((Key)reader.getTopKey()).getRow();
                    TabletLocator.TabletLocation tabletLocation = locator.locateTablet(context, row, false, true);
                    result.add(tabletLocation);
                    row = tabletLocation.tablet_extent.getEndRow();
                    if (row != null && (endRow == null || row.compareTo((BinaryComparable)endRow) < 0)) {
                        row = new Text(row);
                        row.append(byte0, 0, byte0.length);
                        continue;
                    }
                }
                break;
            }
        }
        return result;
    }

    public static class AssignmentStats {
        private Map<KeyExtent, Integer> counts = new HashMap<KeyExtent, Integer>();
        private int numUniqueMapFiles;
        private Map<Path, List<KeyExtent>> completeFailures = null;
        private Set<Path> failedFailures = null;

        AssignmentStats(int fileCount) {
            this.numUniqueMapFiles = fileCount;
        }

        void attemptingAssignments(Map<Path, List<TabletLocator.TabletLocation>> assignments) {
            for (Map.Entry<Path, List<TabletLocator.TabletLocation>> entry : assignments.entrySet()) {
                for (TabletLocator.TabletLocation tl : entry.getValue()) {
                    Integer count = this.getCount(tl.tablet_extent);
                    this.counts.put(tl.tablet_extent, count + 1);
                }
            }
        }

        void assignmentsFailed(Map<Path, List<KeyExtent>> assignmentFailures) {
            for (Map.Entry<Path, List<KeyExtent>> entry : assignmentFailures.entrySet()) {
                for (KeyExtent ke : entry.getValue()) {
                    Integer count = this.getCount(ke);
                    this.counts.put(ke, count - 1);
                }
            }
        }

        void assignmentsAbandoned(Map<Path, List<KeyExtent>> completeFailures) {
            this.completeFailures = completeFailures;
        }

        private Integer getCount(KeyExtent parent) {
            Integer count = this.counts.get(parent);
            if (count == null) {
                count = 0;
            }
            return count;
        }

        void unrecoveredMapFiles(Set<Path> failedFailures) {
            this.failedFailures = failedFailures;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int totalAssignments = 0;
            int tabletsImportedTo = 0;
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (Map.Entry<KeyExtent, Integer> entry : this.counts.entrySet()) {
                totalAssignments += entry.getValue().intValue();
                if (entry.getValue() > 0) {
                    ++tabletsImportedTo;
                }
                if (entry.getValue() < min) {
                    min = entry.getValue();
                }
                if (entry.getValue() <= max) continue;
                max = entry.getValue();
            }
            double stddev = 0.0;
            for (Map.Entry<KeyExtent, Integer> entry : this.counts.entrySet()) {
                stddev += Math.pow((double)entry.getValue().intValue() - (double)totalAssignments / (double)this.counts.size(), 2.0);
            }
            stddev /= (double)this.counts.size();
            stddev = Math.sqrt(stddev);
            HashSet<KeyExtent> failedTablets = new HashSet<KeyExtent>();
            for (List<KeyExtent> ft : this.completeFailures.values()) {
                failedTablets.addAll(ft);
            }
            sb.append("BULK IMPORT ASSIGNMENT STATISTICS\n");
            sb.append(String.format("# of map files            : %,10d%n", this.numUniqueMapFiles));
            sb.append(String.format("# map files with failures : %,10d %6.2f%s%n", this.completeFailures.size(), (double)this.completeFailures.size() * 100.0 / (double)this.numUniqueMapFiles, "%"));
            sb.append(String.format("# failed failed map files : %,10d %s%n", this.failedFailures.size(), this.failedFailures.size() > 0 ? " <-- THIS IS BAD" : ""));
            sb.append(String.format("# of tablets              : %,10d%n", this.counts.size()));
            sb.append(String.format("# tablets imported to     : %,10d %6.2f%s%n", tabletsImportedTo, (double)tabletsImportedTo * 100.0 / (double)this.counts.size(), "%"));
            sb.append(String.format("# tablets with failures   : %,10d %6.2f%s%n", failedTablets.size(), (double)failedTablets.size() * 100.0 / (double)this.counts.size(), "%"));
            sb.append(String.format("min map files per tablet  : %,10d%n", min));
            sb.append(String.format("max map files per tablet  : %,10d%n", max));
            sb.append(String.format("avg map files per tablet  : %,10.2f (std dev = %.2f)%n", (double)totalAssignments / (double)this.counts.size(), stddev));
            return sb.toString();
        }
    }

    private class PathSize {
        Path path;
        long estSize;

        public PathSize(Path mapFile, long estSize) {
            this.path = mapFile;
            this.estSize = estSize;
        }

        public String toString() {
            return this.path + " " + this.estSize;
        }
    }

    private class AssignmentTask
    implements Runnable {
        final Map<Path, List<KeyExtent>> assignmentFailures;
        HostAndPort location;
        private Map<KeyExtent, List<PathSize>> assignmentsPerTablet;

        public AssignmentTask(Map<Path, List<KeyExtent>> assignmentFailures, String tableName, String location, Map<KeyExtent, List<PathSize>> assignmentsPerTablet) {
            this.assignmentFailures = assignmentFailures;
            this.location = HostAndPort.fromString((String)location);
            this.assignmentsPerTablet = assignmentsPerTablet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleFailures(Collection<KeyExtent> failures, String message) {
            for (KeyExtent ke : failures) {
                List<PathSize> mapFiles = this.assignmentsPerTablet.get(ke);
                Map<Path, List<KeyExtent>> map = this.assignmentFailures;
                synchronized (map) {
                    for (PathSize pathSize : mapFiles) {
                        List<KeyExtent> existingFailures = this.assignmentFailures.get(pathSize.path);
                        if (existingFailures == null) {
                            existingFailures = new ArrayList<KeyExtent>();
                            this.assignmentFailures.put(pathSize.path, existingFailures);
                        }
                        existingFailures.add(ke);
                    }
                }
                log.info("Could not assign {} map files to tablet {} because : {} .  Will retry ...", new Object[]{mapFiles.size(), ke, message});
            }
        }

        @Override
        public void run() {
            HashSet<Path> uniqMapFiles = new HashSet<Path>();
            for (List<PathSize> mapFiles : this.assignmentsPerTablet.values()) {
                for (PathSize ps : mapFiles) {
                    uniqMapFiles.add(ps.path);
                }
            }
            log.debug("Assigning " + uniqMapFiles.size() + " map files to " + this.assignmentsPerTablet.size() + " tablets at " + this.location);
            try {
                List failures = BulkImporter.this.assignMapFiles(BulkImporter.this.context, this.location, this.assignmentsPerTablet);
                this.handleFailures(failures, "Not Serving Tablet");
            }
            catch (AccumuloException e) {
                this.handleFailures(this.assignmentsPerTablet.keySet(), e.getMessage());
            }
            catch (AccumuloSecurityException e) {
                this.handleFailures(this.assignmentsPerTablet.keySet(), e.getMessage());
            }
        }
    }

    private class AssignmentInfo {
        KeyExtent ke;
        long estSize;

        public AssignmentInfo(KeyExtent keyExtent, Long estSize) {
            this.ke = keyExtent;
            this.estSize = estSize;
        }
    }

    private static enum Timers {
        EXAMINE_MAP_FILES,
        QUERY_METADATA,
        IMPORT_MAP_FILES,
        SLEEP,
        TOTAL;

    }
}

