/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

class NamespaceConfWatcher
implements Watcher {
    private static final Logger log;
    private final Instance instance;
    private final String namespacesPrefix;
    private final int namespacesPrefixLength;
    private ServerConfigurationFactory scf;

    NamespaceConfWatcher(Instance instance) {
        this.instance = instance;
        this.namespacesPrefix = ZooUtil.getRoot((Instance)instance) + "/namespaces" + "/";
        this.namespacesPrefixLength = this.namespacesPrefix.length();
        this.scf = new ServerConfigurationFactory(instance);
    }

    static String toString(WatchedEvent event) {
        return "{path=" + event.getPath() + ",state=" + event.getState() + ",type=" + event.getType() + "}";
    }

    public void process(WatchedEvent event) {
        String path = event.getPath();
        if (log.isTraceEnabled()) {
            log.trace((Object)("WatchedEvent : " + NamespaceConfWatcher.toString(event)));
        }
        String namespaceId = null;
        String key = null;
        if (path != null) {
            if (path.startsWith(this.namespacesPrefix) && (namespaceId = path.substring(this.namespacesPrefixLength)).contains("/")) {
                namespaceId = namespaceId.substring(0, namespaceId.indexOf(47));
                if (path.startsWith(this.namespacesPrefix + namespaceId + "/conf" + "/")) {
                    key = path.substring((this.namespacesPrefix + namespaceId + "/conf" + "/").length());
                }
            }
            if (namespaceId == null) {
                log.warn((Object)("Zookeeper told me about a path I was not watching: " + path + ", event " + NamespaceConfWatcher.toString(event)));
                return;
            }
        }
        block0 : switch (event.getType()) {
            case NodeDataChanged: {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("EventNodeDataChanged " + event.getPath()));
                }
                if (key == null) break;
                this.scf.getNamespaceConfiguration(namespaceId).propertyChanged(key);
                break;
            }
            case NodeChildrenChanged: {
                this.scf.getNamespaceConfiguration(namespaceId).propertiesChanged();
                break;
            }
            case NodeDeleted: {
                if (key != null) break;
                ServerConfigurationFactory.removeCachedNamespaceConfiguration(this.instance.getInstanceID(), namespaceId);
                break;
            }
            case None: {
                switch (event.getState()) {
                    case Expired: {
                        ServerConfigurationFactory.expireAllTableObservers();
                        break block0;
                    }
                    case SyncConnected: {
                        break block0;
                    }
                    case Disconnected: {
                        break block0;
                    }
                }
                log.warn((Object)("EventNone event not handled " + NamespaceConfWatcher.toString(event)));
                break;
            }
            case NodeCreated: {
                switch (event.getState()) {
                    case SyncConnected: {
                        break block0;
                    }
                }
                log.warn((Object)("Event NodeCreated event not handled " + NamespaceConfWatcher.toString(event)));
                break;
            }
            default: {
                log.warn((Object)("Event not handled " + NamespaceConfWatcher.toString(event)));
            }
        }
    }

    static {
        Logger.getLogger((String)"org.apache.zookeeper").setLevel(Level.WARN);
        Logger.getLogger((String)"org.apache.hadoop.io.compress").setLevel(Level.WARN);
        log = Logger.getLogger(NamespaceConfWatcher.class);
    }
}

