/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.balancer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.tabletserver.thrift.TabletStats;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.master.balancer.TabletBalancer;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletMigration;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChaoticLoadBalancer
extends TabletBalancer {
    private static final Logger log = LoggerFactory.getLogger(ChaoticLoadBalancer.class);
    private final String tableName;
    Random r = new Random();
    protected final TabletBalancer.OutstandingMigrations outstandingMigrations = new TabletBalancer.OutstandingMigrations(log);

    public ChaoticLoadBalancer() {
        this.tableName = null;
    }

    public ChaoticLoadBalancer(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public void getAssignments(SortedMap<TServerInstance, TabletServerStatus> current, Map<KeyExtent, TServerInstance> unassigned, Map<KeyExtent, TServerInstance> assignments) {
        long total = assignments.size() + unassigned.size();
        long avg = (long)Math.ceil((double)total / (double)current.size());
        HashMap<TServerInstance, Long> toAssign = new HashMap<TServerInstance, Long>();
        ArrayList<TServerInstance> tServerArray = new ArrayList<TServerInstance>();
        for (Map.Entry<TServerInstance, TabletServerStatus> e : current.entrySet()) {
            long numTablets = 0L;
            for (TableInfo ti : e.getValue().getTableMap().values()) {
                numTablets += (long)ti.tablets;
            }
            if (numTablets >= avg) continue;
            tServerArray.add(e.getKey());
            toAssign.put(e.getKey(), avg - numTablets);
        }
        if (tServerArray.isEmpty()) {
            return;
        }
        for (KeyExtent ke : unassigned.keySet()) {
            int index = this.r.nextInt(tServerArray.size());
            TServerInstance dest = (TServerInstance)tServerArray.get(index);
            assignments.put(ke, dest);
            long remaining = (Long)toAssign.get(dest) - 1L;
            if (remaining == 0L) {
                tServerArray.remove(index);
                toAssign.remove(dest);
                continue;
            }
            toAssign.put(dest, remaining);
        }
    }

    @Override
    public long balance(SortedMap<TServerInstance, TabletServerStatus> current, Set<KeyExtent> migrations, List<TabletMigration> migrationsOut) {
        HashMap<TServerInstance, Long> numTablets = new HashMap<TServerInstance, Long>();
        ArrayList<TServerInstance> underCapacityTServer = new ArrayList<TServerInstance>();
        if (!migrations.isEmpty()) {
            this.outstandingMigrations.migrations = migrations;
            this.constraintNotMet(this.outstandingMigrations);
            return 100L;
        }
        this.resetBalancerErrors();
        boolean moveMetadata = this.r.nextInt(4) == 0;
        long totalTablets = 0L;
        for (Map.Entry<TServerInstance, TabletServerStatus> e : current.entrySet()) {
            long tabletCount = 0L;
            for (TableInfo ti : e.getValue().getTableMap().values()) {
                tabletCount += (long)ti.tablets;
            }
            numTablets.put(e.getKey(), tabletCount);
            underCapacityTServer.add(e.getKey());
            totalTablets += tabletCount;
        }
        long avg = (long)Math.ceil((double)totalTablets / (double)current.size() * 1.2);
        for (Map.Entry<TServerInstance, TabletServerStatus> e : current.entrySet()) {
            for (String tableId : e.getValue().getTableMap().keySet()) {
                if (!moveMetadata && "!0".equals(tableId)) continue;
                try {
                    for (TabletStats ts : this.getOnlineTabletsForTable(e.getKey(), tableId)) {
                        KeyExtent ke = new KeyExtent(ts.extent);
                        int index = this.r.nextInt(underCapacityTServer.size());
                        TServerInstance dest = (TServerInstance)underCapacityTServer.get(index);
                        if (dest.equals(e.getKey())) continue;
                        migrationsOut.add(new TabletMigration(ke, e.getKey(), dest));
                        if (numTablets.put(dest, (Long)numTablets.get(dest) + 1L) > avg) {
                            underCapacityTServer.remove(index);
                        }
                        if (numTablets.put(e.getKey(), (Long)numTablets.get(e.getKey()) - 1L) <= avg && !underCapacityTServer.contains(e.getKey())) {
                            underCapacityTServer.add(e.getKey());
                        }
                        if (!underCapacityTServer.isEmpty()) continue;
                        underCapacityTServer.addAll(numTablets.keySet());
                    }
                }
                catch (ThriftSecurityException e1) {
                    log.debug("Encountered ThriftSecurityException.  This should not happen.  Carrying on anyway.", (Throwable)e1);
                }
                catch (TException e1) {
                    log.debug("Encountered TException.  This should not happen.  Carrying on anyway.", (Throwable)e1);
                }
            }
        }
        return 100L;
    }

    @Override
    @Deprecated
    public void init(ServerConfiguration conf) {
        throw new UnsupportedOperationException();
    }
}

