/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.auto.service.AutoService;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ClientExec;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.server.util.FindOfflineTablets;
import org.apache.accumulo.server.util.ListInstances;
import org.apache.accumulo.server.util.ListVolumesUsed;
import org.apache.accumulo.server.util.RandomizeVolumes;
import org.apache.accumulo.server.util.RemoveEntriesForMissingFiles;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.hadoop.conf.Configuration;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value=KeywordExecutable.class)
public class Admin
implements KeywordExecutable {
    private static final Logger log = LoggerFactory.getLogger(Admin.class);
    private static final String ACCUMULO_SITE_BACKUP_FILE = "accumulo-site.xml.bak";
    private static final String NS_FILE_SUFFIX = "_ns.cfg";
    private static final String USER_FILE_SUFFIX = "_user.cfg";
    private static final MessageFormat configFormat = new MessageFormat("config -t {0} -s {1}\n");
    private static final MessageFormat createNsFormat = new MessageFormat("createnamespace {0}\n");
    private static final MessageFormat createTableFormat = new MessageFormat("createtable {0}\n");
    private static final MessageFormat createUserFormat = new MessageFormat("createuser {0}\n");
    private static final MessageFormat nsConfigFormat = new MessageFormat("config -ns {0} -s {1}\n");
    private static final MessageFormat sysPermFormat = new MessageFormat("grant System.{0} -s -u {1}\n");
    private static final MessageFormat nsPermFormat = new MessageFormat("grant Namespace.{0} -ns {1} -u {2}\n");
    private static final MessageFormat tablePermFormat = new MessageFormat("grant Table.{0} -t {1} -u {2}\n");
    private static final MessageFormat userAuthsFormat = new MessageFormat("setauths -u {0} -s {1}\n");
    private DefaultConfiguration defaultConfig;
    private Map<String, String> siteConfig;
    private Map<String, String> systemConfig;
    private List<String> localUsers;

    public static void main(String[] args) {
        new Admin().execute(args);
    }

    public String keyword() {
        return "admin";
    }

    public void execute(String[] args) {
        AdminOpts opts = new AdminOpts();
        JCommander cl = new JCommander((Object)opts);
        cl.setProgramName(Admin.class.getName());
        CheckTabletsCommand checkTabletsCommand = new CheckTabletsCommand();
        cl.addCommand("checkTablets", (Object)checkTabletsCommand);
        ListInstancesCommand listIntancesOpts = new ListInstancesCommand();
        cl.addCommand("listInstances", (Object)listIntancesOpts);
        PingCommand pingCommand = new PingCommand();
        cl.addCommand("ping", (Object)pingCommand);
        DumpConfigCommand dumpConfigCommand = new DumpConfigCommand();
        cl.addCommand("dumpConfig", (Object)dumpConfigCommand);
        VolumesCommand volumesCommand = new VolumesCommand();
        cl.addCommand("volumes", (Object)volumesCommand);
        StopCommand stopOpts = new StopCommand();
        cl.addCommand("stop", (Object)stopOpts);
        StopAllCommand stopAllOpts = new StopAllCommand();
        cl.addCommand("stopAll", (Object)stopAllOpts);
        StopMasterCommand stopMasterOpts = new StopMasterCommand();
        cl.addCommand("stopMaster", (Object)stopMasterOpts);
        RandomizeVolumesCommand randomizeVolumesOpts = new RandomizeVolumesCommand();
        cl.addCommand("randomizeVolumes", (Object)randomizeVolumesOpts);
        cl.parse(args);
        if (opts.help || cl.getParsedCommand() == null) {
            cl.usage();
            return;
        }
        SiteConfiguration siteConf = SiteConfiguration.getInstance();
        if (siteConf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            SecurityUtil.serverLogin((AccumuloConfiguration)siteConf);
        }
        Instance instance = opts.getInstance();
        ServerConfigurationFactory confFactory = new ServerConfigurationFactory(instance);
        try {
            AccumuloServerContext context = new AccumuloServerContext(confFactory);
            int rc = 0;
            if (cl.getParsedCommand().equals("listInstances")) {
                ListInstances.listInstances(instance.getZooKeepers(), listIntancesOpts.printAll, listIntancesOpts.printErrors);
            } else if (cl.getParsedCommand().equals("ping")) {
                if (Admin.ping(context, pingCommand.args) != 0) {
                    rc = 4;
                }
            } else if (cl.getParsedCommand().equals("checkTablets")) {
                System.out.println("\n*** Looking for offline tablets ***\n");
                if (FindOfflineTablets.findOffline(context, checkTabletsCommand.tableName) != 0) {
                    rc = 5;
                }
                System.out.println("\n*** Looking for missing files ***\n");
                if (checkTabletsCommand.tableName == null) {
                    if (RemoveEntriesForMissingFiles.checkAllTables(context, checkTabletsCommand.fixFiles) != 0) {
                        rc = 6;
                    }
                } else if (RemoveEntriesForMissingFiles.checkTable(context, checkTabletsCommand.tableName, checkTabletsCommand.fixFiles) != 0) {
                    rc = 6;
                }
            } else if (cl.getParsedCommand().equals("stop")) {
                Admin.stopTabletServer(context, stopOpts.args, opts.force);
            } else if (cl.getParsedCommand().equals("dumpConfig")) {
                this.printConfig(context, dumpConfigCommand);
            } else if (cl.getParsedCommand().equals("volumes")) {
                ListVolumesUsed.listVolumes(context);
            } else if (cl.getParsedCommand().equals("randomizeVolumes")) {
                rc = RandomizeVolumes.randomize(context.getConnector(), randomizeVolumesOpts.tableName);
            } else {
                boolean everything = cl.getParsedCommand().equals("stopAll");
                if (everything) {
                    Admin.flushAll(context);
                }
                Admin.stopServer(context, everything);
            }
            if (rc != 0) {
                System.exit(rc);
            }
        }
        catch (AccumuloException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            System.exit(1);
        }
        catch (AccumuloSecurityException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            System.exit(2);
        }
        catch (Exception e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            System.exit(3);
        }
    }

    private static int ping(ClientContext context, List<String> args) throws AccumuloException, AccumuloSecurityException {
        InstanceOperations io = context.getConnector().instanceOperations();
        if (args.size() == 0) {
            args = io.getTabletServers();
        }
        int unreachable = 0;
        for (String tserver : args) {
            try {
                io.ping(tserver);
                System.out.println(tserver + " OK");
            }
            catch (AccumuloException ae) {
                System.out.println(tserver + " FAILED (" + ae.getMessage() + ")");
                ++unreachable;
            }
        }
        System.out.printf("\n%d of %d tablet servers unreachable\n\n", unreachable, args.size());
        return unreachable;
    }

    private static void flushAll(final ClientContext context) throws AccumuloException, AccumuloSecurityException {
        final AtomicInteger flushesStarted = new AtomicInteger(0);
        Runnable flushTask = new Runnable(){

            @Override
            public void run() {
                try {
                    Connector conn = context.getConnector();
                    Set tables = conn.tableOperations().tableIdMap().keySet();
                    for (String table : tables) {
                        if (table.equals("accumulo.metadata")) continue;
                        try {
                            conn.tableOperations().flush(table, null, null, false);
                            flushesStarted.incrementAndGet();
                        }
                        catch (TableNotFoundException tableNotFoundException) {}
                    }
                }
                catch (Exception e) {
                    log.warn("Failed to intiate flush {}", (Object)e.getMessage());
                }
            }
        };
        Thread flusher = new Thread(flushTask);
        flusher.setDaemon(true);
        flusher.start();
        long start = System.currentTimeMillis();
        try {
            flusher.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (flusher.isAlive() && System.currentTimeMillis() - start < 15000L) {
            int flushCount = flushesStarted.get();
            try {
                flusher.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (flushCount != flushesStarted.get()) continue;
            break;
        }
    }

    private static void stopServer(final ClientContext context, final boolean tabletServersToo) throws AccumuloException, AccumuloSecurityException {
        MasterClient.execute((ClientContext)context, (ClientExec)new ClientExec<MasterClientService.Client>(){

            public void execute(MasterClientService.Client client) throws Exception {
                client.shutdown(Tracer.traceInfo(), context.rpcCreds(), tabletServersToo);
            }
        });
    }

    private static void stopTabletServer(final ClientContext context, List<String> servers, final boolean force) throws AccumuloException, AccumuloSecurityException {
        if (context.getInstance().getMasterLocations().size() == 0) {
            log.info("No masters running. Not attempting safe unload of tserver.");
            return;
        }
        Instance instance = context.getInstance();
        String zTServerRoot = Admin.getTServersZkPath(instance);
        ZooCache zc = new ZooCacheFactory().getZooCache(instance.getZooKeepers(), instance.getZooKeepersSessionTimeOut());
        for (String server : servers) {
            for (int port : context.getConfiguration().getPort(Property.TSERV_CLIENTPORT)) {
                HostAndPort address = AddressUtil.parseAddress((String)server, (int)port);
                final String finalServer = Admin.qualifyWithZooKeeperSessionId(zTServerRoot, zc, address.toString());
                log.info("Stopping server " + finalServer);
                MasterClient.execute((ClientContext)context, (ClientExec)new ClientExec<MasterClientService.Client>(){

                    public void execute(MasterClientService.Client client) throws Exception {
                        client.shutdownTabletServer(Tracer.traceInfo(), context.rpcCreds(), finalServer, force);
                    }
                });
            }
        }
    }

    static String getTServersZkPath(Instance instance) {
        Objects.requireNonNull(instance);
        String instanceRoot = ZooUtil.getRoot((Instance)instance);
        return instanceRoot + "/tservers";
    }

    static String qualifyWithZooKeeperSessionId(String zTServerRoot, ZooCache zooCache, String hostAndPort) {
        try {
            long sessionId = ZooLock.getSessionId((ZooCache)zooCache, (String)(zTServerRoot + "/" + hostAndPort));
            if (0L == sessionId) {
                return hostAndPort;
            }
            return hostAndPort + "[" + Long.toHexString(sessionId) + "]";
        }
        catch (InterruptedException | KeeperException e) {
            log.warn("Failed to communicate with ZooKeeper to find session ID for TabletServer.");
            return hostAndPort;
        }
    }

    public void printConfig(ClientContext context, DumpConfigCommand opts) throws Exception {
        block14: {
            Connector connector;
            File outputDirectory;
            block13: {
                outputDirectory = null;
                if (opts.directory != null) {
                    outputDirectory = new File(opts.directory);
                    if (!outputDirectory.isDirectory()) {
                        throw new IllegalArgumentException(opts.directory + " does not exist on the local filesystem.");
                    }
                    if (!outputDirectory.canWrite()) {
                        throw new IllegalArgumentException(opts.directory + " is not writable");
                    }
                }
                connector = context.getConnector();
                this.defaultConfig = AccumuloConfiguration.getDefaultConfiguration();
                this.siteConfig = connector.instanceOperations().getSiteConfiguration();
                this.systemConfig = connector.instanceOperations().getSystemConfiguration();
                if (opts.allConfiguration || opts.users) {
                    this.localUsers = Lists.newArrayList((Iterable)connector.securityOperations().listLocalUsers());
                    Collections.sort(this.localUsers);
                }
                if (!opts.allConfiguration) break block13;
                this.printSystemConfiguration(connector, outputDirectory);
                for (Iterator<String> namespace : connector.namespaceOperations().list()) {
                    this.printNameSpaceConfiguration(connector, (String)((Object)namespace), outputDirectory);
                }
                SortedSet tableNames = connector.tableOperations().list();
                for (String tableName : tableNames) {
                    this.printTableConfiguration(connector, tableName, outputDirectory);
                }
                for (String user : this.localUsers) {
                    Admin.printUserConfiguration(connector, user, outputDirectory);
                }
                break block14;
            }
            if (opts.systemConfiguration) {
                this.printSystemConfiguration(connector, outputDirectory);
            }
            if (opts.namespaceConfiguration) {
                for (String namespace : connector.namespaceOperations().list()) {
                    this.printNameSpaceConfiguration(connector, namespace, outputDirectory);
                }
            }
            if (opts.tables.size() > 0) {
                for (String tableName : opts.tables) {
                    this.printTableConfiguration(connector, tableName, outputDirectory);
                }
            }
            if (!opts.users) break block14;
            for (String user : this.localUsers) {
                Admin.printUserConfiguration(connector, user, outputDirectory);
            }
        }
    }

    private String getDefaultConfigValue(String key) {
        if (null == key) {
            return null;
        }
        String defaultValue = null;
        try {
            Property p = Property.getPropertyByKey((String)key);
            if (null == p) {
                return defaultValue;
            }
            defaultValue = this.defaultConfig.get(p);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return defaultValue;
    }

    private void printNameSpaceConfiguration(Connector connector, String namespace, File outputDirectory) throws IOException, AccumuloException, AccumuloSecurityException, NamespaceNotFoundException {
        File namespaceScript = new File(outputDirectory, namespace + NS_FILE_SUFFIX);
        FileWriter nsWriter = new FileWriter(namespaceScript);
        nsWriter.write(createNsFormat.format(new String[]{namespace}));
        TreeMap props = new TreeMap();
        for (Map.Entry entry : connector.namespaceOperations().getProperties(namespace)) {
            props.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : props.entrySet()) {
            String defaultValue = this.getDefaultConfigValue((String)entry.getKey());
            if (defaultValue != null && defaultValue.equals(entry.getValue()) || ((String)entry.getValue()).equals(this.siteConfig.get(entry.getKey())) || ((String)entry.getValue()).equals(this.systemConfig.get(entry.getKey()))) continue;
            nsWriter.write(nsConfigFormat.format(new String[]{namespace, (String)entry.getKey() + "=" + (String)entry.getValue()}));
        }
        nsWriter.close();
    }

    private static void printUserConfiguration(Connector connector, String user, File outputDirectory) throws IOException, AccumuloException, AccumuloSecurityException {
        File userScript = new File(outputDirectory, user + USER_FILE_SUFFIX);
        FileWriter userWriter = new FileWriter(userScript);
        userWriter.write(createUserFormat.format(new String[]{user}));
        Authorizations auths = connector.securityOperations().getUserAuthorizations(user);
        userWriter.write(userAuthsFormat.format(new String[]{user, auths.toString()}));
        for (SystemPermission sp : SystemPermission.values()) {
            if (!connector.securityOperations().hasSystemPermission(user, sp)) continue;
            userWriter.write(sysPermFormat.format(new String[]{sp.name(), user}));
        }
        for (String namespace : connector.namespaceOperations().list()) {
            NamespacePermission[] namespacePermissionArray = NamespacePermission.values();
            int n = namespacePermissionArray.length;
            for (int i = 0; i < n; ++i) {
                NamespacePermission np = namespacePermissionArray[i];
                if (!connector.securityOperations().hasNamespacePermission(user, namespace, np)) continue;
                userWriter.write(nsPermFormat.format(new String[]{np.name(), namespace, user}));
            }
        }
        for (String tableName : connector.tableOperations().list()) {
            for (TablePermission perm : TablePermission.values()) {
                if (!connector.securityOperations().hasTablePermission(user, tableName, perm)) continue;
                userWriter.write(tablePermFormat.format(new String[]{perm.name(), tableName, user}));
            }
        }
        userWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printSystemConfiguration(Connector connector, File outputDirectory) throws IOException, AccumuloException, AccumuloSecurityException {
        Configuration conf = new Configuration(false);
        TreeMap<String, String> site = new TreeMap<String, String>(this.siteConfig);
        for (Map.Entry<String, String> entry : site.entrySet()) {
            String string = this.getDefaultConfigValue(entry.getKey());
            if (entry.getValue().equals(string) || this.systemConfig.containsKey(entry.getKey())) continue;
            conf.set(entry.getKey(), entry.getValue());
        }
        TreeMap<String, String> system = new TreeMap<String, String>(this.systemConfig);
        for (Map.Entry<String, String> entry : system.entrySet()) {
            String defaultValue = this.getDefaultConfigValue(entry.getKey());
            if (entry.getValue().equals(defaultValue)) continue;
            conf.set(entry.getKey(), entry.getValue());
        }
        File file = new File(outputDirectory, ACCUMULO_SITE_BACKUP_FILE);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            conf.writeXml((OutputStream)fileOutputStream);
        }
    }

    private void printTableConfiguration(Connector connector, String tableName, File outputDirectory) throws AccumuloException, TableNotFoundException, IOException, AccumuloSecurityException {
        File tableBackup = new File(outputDirectory, tableName + ".cfg");
        FileWriter writer = new FileWriter(tableBackup);
        writer.write(createTableFormat.format(new String[]{tableName}));
        TreeMap props = new TreeMap();
        for (Map.Entry entry : connector.tableOperations().getProperties(tableName)) {
            props.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : props.entrySet()) {
            String defaultValue;
            if (!((String)entry.getKey()).startsWith(Property.TABLE_PREFIX.getKey()) || (defaultValue = this.getDefaultConfigValue((String)entry.getKey())) != null && defaultValue.equals(entry.getValue()) || ((String)entry.getValue()).equals(this.siteConfig.get(entry.getKey())) || ((String)entry.getValue()).equals(this.systemConfig.get(entry.getKey()))) continue;
            writer.write(configFormat.format(new String[]{tableName, (String)entry.getKey() + "=" + (String)entry.getValue()}));
        }
        writer.close();
    }

    @Parameters(commandDescription="redistribute tablet directories across the current volume list")
    static class RandomizeVolumesCommand {
        @Parameter(names={"-t"}, description="table to update", required=true)
        String tableName = null;

        RandomizeVolumesCommand() {
        }
    }

    @Parameters(commandDescription="print out non-default configuration settings")
    static class DumpConfigCommand {
        @Parameter(names={"-a", "--all"}, description="print the system and all table configurations")
        boolean allConfiguration = false;
        @Parameter(names={"-d", "--directory"}, description="directory to place config files")
        String directory = null;
        @Parameter(names={"-s", "--system"}, description="print the system configuration")
        boolean systemConfiguration = false;
        @Parameter(names={"-n", "--namespaces"}, description="print the namespace configuration")
        boolean namespaceConfiguration = false;
        @Parameter(names={"-t", "--tables"}, description="print per-table configuration")
        List<String> tables = new ArrayList<String>();
        @Parameter(names={"-u", "--users"}, description="print users and their authorizations and permissions")
        boolean users = false;

        DumpConfigCommand() {
        }
    }

    @Parameters(commandDescription="Accumulo volume utility")
    static class VolumesCommand {
        @Parameter(names={"-l", "--list"}, description="list volumes currently in use")
        boolean printErrors = false;

        VolumesCommand() {
        }
    }

    @Parameters(commandDescription="list Accumulo instances in zookeeper")
    static class ListInstancesCommand {
        @Parameter(names={"--print-errors"}, description="display errors while listing instances")
        boolean printErrors = false;
        @Parameter(names={"--print-all"}, description="print information for all instances, not just those with names")
        boolean printAll = false;

        ListInstancesCommand() {
        }
    }

    @Parameters(commandDescription="stop all the servers")
    static class StopAllCommand {
        StopAllCommand() {
        }
    }

    @Parameters(commandDescription="stop the master")
    static class StopMasterCommand {
        StopMasterCommand() {
        }
    }

    @Parameters(commandDescription="print tablets that are offline in online tables")
    static class CheckTabletsCommand {
        @Parameter(names={"--fixFiles"}, description="Remove dangling file pointers")
        boolean fixFiles = false;
        @Parameter(names={"-t", "--table"}, description="Table to check, if not set checks all tables")
        String tableName = null;

        CheckTabletsCommand() {
        }
    }

    @Parameters(commandDescription="Ping tablet servers.  If no arguments, pings all.")
    static class PingCommand {
        @Parameter(description="{<host> ... }")
        List<String> args = new ArrayList<String>();

        PingCommand() {
        }
    }

    @Parameters(commandDescription="stop the tablet server on the given hosts")
    static class StopCommand {
        @Parameter(description="<host> {<host> ... }")
        List<String> args = new ArrayList<String>();

        StopCommand() {
        }
    }

    static class AdminOpts
    extends ClientOpts {
        @Parameter(names={"-f", "--force"}, description="force the given server to stop by removing its lock")
        boolean force = false;

        AdminOpts() {
        }
    }
}

