/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.zookeeper.KeeperException;

public class NamespacePropUtil {
    public static boolean setNamespaceProperty(String namespaceId, String property, String value) throws KeeperException, InterruptedException {
        if (!NamespacePropUtil.isPropertyValid(property, value)) {
            return false;
        }
        String zkNamespacePath = NamespacePropUtil.getPath(namespaceId);
        ZooReaderWriter.getInstance().putPersistentData(zkNamespacePath, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
        String zPath = zkNamespacePath + "/" + property;
        ZooReaderWriter.getInstance().putPersistentData(zPath, value.getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
        return true;
    }

    public static boolean isPropertyValid(String property, String value) {
        Property p = Property.getPropertyByKey((String)property);
        return (p == null || p.getType().isValidFormat(value)) && Property.isValidTablePropertyKey((String)property);
    }

    public static void removeNamespaceProperty(String namespaceId, String property) throws InterruptedException, KeeperException {
        String zPath = NamespacePropUtil.getPath(namespaceId) + "/" + property;
        ZooReaderWriter.getInstance().recursiveDelete(zPath, ZooUtil.NodeMissingPolicy.SKIP);
    }

    private static String getPath(String namespaceId) {
        return ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/namespaces" + "/" + namespaceId + "/conf";
    }
}

