/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.rpc;

import org.apache.commons.lang.StringUtils;

public enum ThriftServerType {
    CUSTOM_HS_HA("custom_hs_ha"),
    THREADPOOL("threadpool"),
    SSL("ssl"),
    SASL("sasl");

    private final String name;

    private ThriftServerType(String name) {
        this.name = name;
    }

    public static ThriftServerType get(String name) {
        if (StringUtils.isBlank((String)name)) {
            return CUSTOM_HS_HA;
        }
        return ThriftServerType.valueOf(name.trim().toUpperCase());
    }

    public String toString() {
        return this.name;
    }

    public static ThriftServerType getDefault() {
        return CUSTOM_HS_HA;
    }
}

