/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.Set;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.security.handler.Authenticator;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.accumulo.start.spi.KeywordExecutable;

@AutoService(value=KeywordExecutable.class)
public class LoginProperties
implements KeywordExecutable {
    public String keyword() {
        return "login-info";
    }

    public void execute(String[] args) throws Exception {
        AccumuloConfiguration config = new ServerConfigurationFactory(HdfsZooInstance.getInstance()).getConfiguration();
        Authenticator authenticator = AccumuloVFSClassLoader.getClassLoader().loadClass(config.get(Property.INSTANCE_SECURITY_AUTHENTICATOR)).asSubclass(Authenticator.class).newInstance();
        ArrayList<Set> tokenProps = new ArrayList<Set>();
        for (Class<? extends AuthenticationToken> tokenType : authenticator.getSupportedTokenTypes()) {
            tokenProps.add(tokenType.newInstance().getProperties());
        }
        System.out.println("Supported token types for " + authenticator.getClass().getName() + " are : ");
        for (Class<? extends AuthenticationToken> tokenType : authenticator.getSupportedTokenTypes()) {
            System.out.println("\t" + tokenType.getName() + ", which accepts the following properties : ");
            for (AuthenticationToken.TokenProperty tokenProperty : tokenType.newInstance().getProperties()) {
                System.out.println("\t\t" + tokenProperty);
            }
            System.out.println();
        }
    }

    public static void main(String[] args) throws Exception {
        new LoginProperties().execute(args);
    }
}

