/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.volume.Volume;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.cli.ServerUtilOpts;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.htrace.TraceScope;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;

public class ChangeSecret {
    public static void main(String[] args) throws Exception {
        SiteConfiguration siteConfig = new SiteConfiguration();
        VolumeManager fs = VolumeManagerImpl.get((AccumuloConfiguration)siteConfig, new Configuration());
        ChangeSecret.verifyHdfsWritePermission(fs);
        Opts opts = new Opts();
        ArrayList<String> argsList = new ArrayList<String>(args.length + 2);
        argsList.add("--old");
        argsList.add("--new");
        argsList.addAll(Arrays.asList(args));
        try (TraceScope clientSpan = opts.parseArgsAndTrace(ChangeSecret.class.getName(), argsList.toArray(new String[0]), new Object[0]);){
            ServerContext context = opts.getServerContext();
            ChangeSecret.verifyAccumuloIsDown(context, opts.oldPass);
            String newInstanceId = UUID.randomUUID().toString();
            ChangeSecret.updateHdfs(fs, newInstanceId);
            ChangeSecret.rewriteZooKeeperInstance(context, newInstanceId, opts.oldPass, opts.newPass);
            if (opts.oldPass != null) {
                ChangeSecret.deleteInstance(context, opts.oldPass);
            }
            System.out.println("New instance id is " + newInstanceId);
            System.out.println("Be sure to put your new secret in accumulo.properties");
        }
    }

    private static void recurse(ZooReader zoo, String root, Visitor v) {
        try {
            v.visit(zoo, root);
            for (String child : zoo.getChildren(root)) {
                ChangeSecret.recurse(zoo, root + "/" + child, v);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void verifyAccumuloIsDown(ServerContext context, String oldPassword) throws Exception {
        ZooReaderWriter zooReader = new ZooReaderWriter(context.getZooKeepers(), context.getZooKeepersSessionTimeOut(), oldPassword);
        String root = context.getZooKeeperRoot();
        final ArrayList ephemerals = new ArrayList();
        ChangeSecret.recurse((ZooReader)zooReader, root, new Visitor(){

            @Override
            public void visit(ZooReader zoo, String path) throws Exception {
                Stat stat = zoo.getStatus(path);
                if (stat.getEphemeralOwner() != 0L) {
                    ephemerals.add(path);
                }
            }
        });
        if (ephemerals.size() > 0) {
            System.err.println("The following ephemeral nodes exist, something is still running:");
            for (String path : ephemerals) {
                System.err.println(path);
            }
            throw new Exception("Accumulo must be shut down in order to run this tool.");
        }
    }

    private static void rewriteZooKeeperInstance(final ServerContext context, final String newInstanceId, String oldPass, String newPass) throws Exception {
        final ZooReaderWriter orig = new ZooReaderWriter(context.getZooKeepers(), context.getZooKeepersSessionTimeOut(), oldPass);
        ZooReaderWriter new_ = new ZooReaderWriter(context.getZooKeepers(), context.getZooKeepersSessionTimeOut(), newPass);
        String root = context.getZooKeeperRoot();
        ChangeSecret.recurse((ZooReader)orig, root, new Visitor((IZooReaderWriter)new_){
            final /* synthetic */ IZooReaderWriter val$new_;
            {
                this.val$new_ = iZooReaderWriter;
            }

            @Override
            public void visit(ZooReader zoo, String path) throws Exception {
                String newPath = path.replace(context.getInstanceID(), newInstanceId);
                byte[] data = zoo.getData(path, null);
                List acls = orig.getZooKeeper().getACL(path, new Stat());
                if (acls.containsAll(ZooDefs.Ids.READ_ACL_UNSAFE)) {
                    this.val$new_.putPersistentData(newPath, data, ZooUtil.NodeExistsPolicy.FAIL);
                } else if (acls.containsAll(ZooDefs.Ids.OPEN_ACL_UNSAFE)) {
                    String[] parts = path.split("/");
                    if (parts[parts.length - 2].equals("users")) {
                        this.val$new_.putPrivatePersistentData(newPath, data, ZooUtil.NodeExistsPolicy.FAIL);
                    } else {
                        this.val$new_.putPersistentData(newPath, data, ZooUtil.NodeExistsPolicy.FAIL);
                    }
                } else {
                    this.val$new_.putPrivatePersistentData(newPath, data, ZooUtil.NodeExistsPolicy.FAIL);
                }
            }
        });
        String path = "/accumulo/instances/" + context.getInstanceName();
        orig.recursiveDelete(path, ZooUtil.NodeMissingPolicy.SKIP);
        new_.putPersistentData(path, newInstanceId.getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
    }

    private static void updateHdfs(VolumeManager fs, String newInstanceId) throws IOException {
        for (Volume v : fs.getVolumes()) {
            Path instanceId = ServerConstants.getInstanceIdLocation(v);
            if (!v.getFileSystem().delete(instanceId, true)) {
                throw new IOException("Could not recursively delete " + instanceId);
            }
            if (!v.getFileSystem().mkdirs(instanceId)) {
                throw new IOException("Could not create directory " + instanceId);
            }
            v.getFileSystem().create(new Path(instanceId, newInstanceId)).close();
        }
    }

    private static void verifyHdfsWritePermission(VolumeManager fs) throws Exception {
        for (Volume v : fs.getVolumes()) {
            Path instanceId = ServerConstants.getInstanceIdLocation(v);
            FileStatus fileStatus = v.getFileSystem().getFileStatus(instanceId);
            ChangeSecret.checkHdfsAccessPermissions(fileStatus, FsAction.WRITE);
        }
    }

    private static void checkHdfsAccessPermissions(FileStatus stat, FsAction mode) throws Exception {
        FsPermission perm = stat.getPermission();
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        String user = ugi.getShortUserName();
        List<String> groups = Arrays.asList(ugi.getGroupNames());
        if (user.equals(stat.getOwner()) ? perm.getUserAction().implies(mode) : (groups.contains(stat.getGroup()) ? perm.getGroupAction().implies(mode) : perm.getOtherAction().implies(mode))) {
            return;
        }
        throw new Exception(String.format("Permission denied: user=%s, path=\"%s\":%s:%s:%s%s", user, stat.getPath(), stat.getOwner(), stat.getGroup(), stat.isDirectory() ? "d" : "-", perm));
    }

    private static void deleteInstance(ServerContext context, String oldPass) throws Exception {
        ZooReaderWriter orig = new ZooReaderWriter(context.getZooKeepers(), context.getZooKeepersSessionTimeOut(), oldPass);
        orig.recursiveDelete("/accumulo/" + context.getInstanceID(), ZooUtil.NodeMissingPolicy.SKIP);
    }

    static interface Visitor {
        public void visit(ZooReader var1, String var2) throws Exception;
    }

    static class Opts
    extends ServerUtilOpts {
        @Parameter(names={"--old"}, description="old zookeeper password", password=true, hidden=true)
        String oldPass;
        @Parameter(names={"--new"}, description="new zookeeper password", password=true, hidden=true)
        String newPass;

        Opts() {
        }
    }
}

