/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.crypto.CryptoEnvironmentImpl;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iteratorsImpl.IteratorConfigUtil;
import org.apache.accumulo.core.spi.common.ServiceEnvironment;
import org.apache.accumulo.core.spi.compaction.CompactionDispatcher;
import org.apache.accumulo.core.spi.crypto.CryptoEnvironment;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.spi.crypto.CryptoServiceFactory;
import org.apache.accumulo.core.spi.scan.ScanDispatcher;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServiceEnvironmentImpl;
import org.apache.accumulo.server.conf.NamespaceConfiguration;
import org.apache.accumulo.server.conf.ZooBasedConfiguration;
import org.apache.accumulo.server.conf.store.TablePropKey;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableConfiguration
extends ZooBasedConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TableConfiguration.class);
    private final TableId tableId;
    private final EnumMap<IteratorUtil.IteratorScope, AccumuloConfiguration.Deriver<ParsedIteratorConfig>> iteratorConfig;
    private final AccumuloConfiguration.Deriver<ScanDispatcher> scanDispatchDeriver;
    private final AccumuloConfiguration.Deriver<CompactionDispatcher> compactionDispatchDeriver;
    private final AccumuloConfiguration.Deriver<CryptoService> cryptoServiceDeriver;

    public TableConfiguration(ServerContext context, TableId tableId, NamespaceConfiguration parent) {
        super(log, context, TablePropKey.of(context, tableId), parent);
        this.tableId = tableId;
        this.iteratorConfig = new EnumMap(IteratorUtil.IteratorScope.class);
        for (IteratorUtil.IteratorScope scope : IteratorUtil.IteratorScope.values()) {
            this.iteratorConfig.put(scope, (AccumuloConfiguration.Deriver<ParsedIteratorConfig>)this.newDeriver(conf -> {
                HashMap<String, Map<String, String>> allOpts = new HashMap<String, Map<String, String>>();
                List iters = IteratorConfigUtil.parseIterConf((IteratorUtil.IteratorScope)scope, Collections.emptyList(), allOpts, (AccumuloConfiguration)conf);
                return new ParsedIteratorConfig(iters, allOpts, ClassLoaderUtil.tableContext((AccumuloConfiguration)conf));
            }));
        }
        this.scanDispatchDeriver = this.newDeriver(conf -> TableConfiguration.createScanDispatcher(conf, context, tableId));
        this.compactionDispatchDeriver = this.newDeriver(conf -> TableConfiguration.createCompactionDispatcher(conf, context, tableId));
        this.cryptoServiceDeriver = this.newDeriver(conf -> this.createCryptoService((AccumuloConfiguration)conf, tableId, context.getCryptoFactory()));
    }

    @Override
    public boolean isPropertySet(Property prop) {
        if (this._isPropertySet(prop)) {
            return true;
        }
        return this.getParent().isPropertySet(prop);
    }

    private boolean _isPropertySet(Property property) {
        Map<String, String> propMap = this.getSnapshot();
        return propMap.get(property.getKey()) != null;
    }

    @Override
    public String get(Property property) {
        String value = this._get(property);
        if (value != null) {
            return value;
        }
        AccumuloConfiguration parent = this.getParent();
        if (parent != null) {
            return parent.get(property);
        }
        return null;
    }

    private @Nullable String _get(Property property) {
        Map<String, String> propMap = this.getSnapshot();
        if (propMap == null) {
            return null;
        }
        return propMap.get(property.getKey());
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public ParsedIteratorConfig getParsedIteratorConfig(IteratorUtil.IteratorScope scope) {
        return (ParsedIteratorConfig)this.iteratorConfig.get(scope).derive();
    }

    private static ScanDispatcher createScanDispatcher(AccumuloConfiguration conf, final ServerContext context, final TableId tableId) {
        ScanDispatcher newDispatcher = (ScanDispatcher)Property.createTableInstanceFromPropertyName((AccumuloConfiguration)conf, (Property)Property.TABLE_SCAN_DISPATCHER, ScanDispatcher.class, null);
        final Map opts = conf.getAllPropertiesWithPrefixStripped(Property.TABLE_SCAN_DISPATCHER_OPTS);
        newDispatcher.init(new ScanDispatcher.InitParameters(){
            private final ServiceEnvironment senv;
            {
                this.senv = new ServiceEnvironmentImpl(context);
            }

            public TableId getTableId() {
                return tableId;
            }

            public Map<String, String> getOptions() {
                return opts;
            }

            public ServiceEnvironment getServiceEnv() {
                return this.senv;
            }
        });
        return newDispatcher;
    }

    private static CompactionDispatcher createCompactionDispatcher(AccumuloConfiguration conf, final ServerContext context, final TableId tableId) {
        CompactionDispatcher newDispatcher = (CompactionDispatcher)Property.createTableInstanceFromPropertyName((AccumuloConfiguration)conf, (Property)Property.TABLE_COMPACTION_DISPATCHER, CompactionDispatcher.class, null);
        final Map opts = conf.getAllPropertiesWithPrefixStripped(Property.TABLE_COMPACTION_DISPATCHER_OPTS);
        newDispatcher.init(new CompactionDispatcher.InitParameters(){
            private final ServiceEnvironment senv;
            {
                this.senv = new ServiceEnvironmentImpl(context);
            }

            public TableId getTableId() {
                return tableId;
            }

            public Map<String, String> getOptions() {
                return opts;
            }

            public ServiceEnvironment getServiceEnv() {
                return this.senv;
            }
        });
        return newDispatcher;
    }

    public ScanDispatcher getScanDispatcher() {
        return (ScanDispatcher)this.scanDispatchDeriver.derive();
    }

    public CompactionDispatcher getCompactionDispatcher() {
        return (CompactionDispatcher)this.compactionDispatchDeriver.derive();
    }

    private CryptoService createCryptoService(AccumuloConfiguration conf, TableId tableId, CryptoServiceFactory factory) {
        CryptoEnvironmentImpl env = new CryptoEnvironmentImpl(CryptoEnvironment.Scope.TABLE, tableId, null);
        return factory.getService((CryptoEnvironment)env, conf.getAllCryptoProperties());
    }

    public CryptoService getCryptoService() {
        return (CryptoService)this.cryptoServiceDeriver.derive();
    }

    public static class ParsedIteratorConfig {
        private final List<IterInfo> tableIters;
        private final Map<String, Map<String, String>> tableOpts;
        private final String context;

        private ParsedIteratorConfig(List<IterInfo> ii, Map<String, Map<String, String>> opts, String context) {
            this.tableIters = List.copyOf(ii);
            this.tableOpts = opts.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> Map.copyOf((Map)e.getValue())));
            this.context = context;
        }

        public List<IterInfo> getIterInfo() {
            return this.tableIters;
        }

        public Map<String, Map<String, String>> getOpts() {
            return this.tableOpts;
        }

        public String getServiceEnv() {
            return this.context;
        }
    }
}

