/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.init;

import com.beust.jcommander.Parameter;
import com.google.auto.service.AutoService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.core.spi.fs.VolumeChooserEnvironment;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.accumulo.server.AccumuloDataVersion;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServerDirs;
import org.apache.accumulo.server.fs.VolumeChooserEnvironmentImpl;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.init.FileSystemInitializer;
import org.apache.accumulo.server.init.InitialConfiguration;
import org.apache.accumulo.server.init.ZooKeeperInitializer;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.server.util.ChangeSecret;
import org.apache.accumulo.server.util.SystemPropUtil;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"DM_EXIT"}, justification="CLI utility can exit")
@AutoService(value={KeywordExecutable.class})
public class Initialize
implements KeywordExecutable {
    private static final Logger log = LoggerFactory.getLogger(Initialize.class);
    private static final String DEFAULT_ROOT_USER = "root";
    static final TableId REPL_TABLE_ID = ReplicationTable.ID;

    static void checkInit(ZooReaderWriter zoo, VolumeManager fs, InitialConfiguration initConfig) throws IOException {
        Configuration hadoopConf = initConfig.getHadoopConf();
        log.info("Hadoop Filesystem is {}", (Object)FileSystem.getDefaultUri((Configuration)hadoopConf));
        log.info("Accumulo data dirs are {}", List.of(initConfig.getVolumeUris()));
        log.info("Zookeeper server is {}", (Object)initConfig.get(Property.INSTANCE_ZK_HOST));
        log.info("Checking if Zookeeper is available. If this hangs, then you need to make sure zookeeper is running");
        if (!Initialize.zookeeperAvailable(zoo)) {
            throw new IllegalStateException("FATAL Zookeeper needs to be up and running in order to init. Exiting ...");
        }
        if (initConfig.get(Property.INSTANCE_SECRET).equals(Property.INSTANCE_SECRET.getDefaultValue())) {
            System.out.println();
            System.out.println();
            System.out.println("Warning!!! Your instance secret is still set to the default, this is not secure. We highly recommend you change it.");
            System.out.println();
            System.out.println();
            System.out.println("You can change the instance secret in accumulo by using:");
            System.out.println("   bin/accumulo " + ChangeSecret.class.getName());
            System.out.println("You will also need to edit your secret in your configuration file by adding the property instance.secret to your accumulo.properties. Without this accumulo will not operate correctly");
        }
        if (Initialize.isInitialized(fs, initConfig)) {
            Initialize.printInitializeFailureMessages(initConfig);
            throw new IOException("Filesystem is already initialized");
        }
    }

    private static void printInitializeFailureMessages(InitialConfiguration initConfig) {
        log.error("It appears the directories {}", (Object)(initConfig.getVolumeUris() + " were previously initialized."));
        log.error("Change the property {} to use different volumes.", (Object)Property.INSTANCE_VOLUMES.getKey());
        log.error("The current value of {} is |{}|", (Object)Property.INSTANCE_VOLUMES.getKey(), (Object)initConfig.get(Property.INSTANCE_VOLUMES));
    }

    private boolean doInit(ZooReaderWriter zoo, Opts opts, VolumeManager fs, InitialConfiguration initConfig) {
        String instanceName;
        String rootUser;
        String instanceNamePath;
        try {
            Initialize.checkInit(zoo, fs, initConfig);
            instanceNamePath = this.getInstanceNamePath(zoo, opts);
            rootUser = this.getRootUserName(initConfig, opts);
            opts.rootpass = initConfig.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED) ? UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8) : this.getRootPassword(initConfig, opts, rootUser);
            instanceName = instanceNamePath.substring(this.getInstanceNamePrefix().length());
        }
        catch (Exception e) {
            log.error("FATAL: Problem during initialize", (Throwable)e);
            return false;
        }
        InstanceId instanceId = InstanceId.of((UUID)UUID.randomUUID());
        ZooKeeperInitializer zki = new ZooKeeperInitializer();
        zki.initializeConfig(instanceId, zoo);
        try (ServerContext context = ServerContext.initialize(initConfig.getSiteConf(), instanceName, instanceId);){
            VolumeChooserEnvironmentImpl chooserEnv = new VolumeChooserEnvironmentImpl(VolumeChooserEnvironment.Scope.INIT, RootTable.ID, null, context);
            String rootTabletDirName = "root_tablet";
            String ext = FileOperations.getNewFileExtension((AccumuloConfiguration)DefaultConfiguration.getInstance());
            String rootTabletFileUri = new Path(fs.choose(chooserEnv, initConfig.getVolumeUris()) + "/tables/" + RootTable.ID + "/" + rootTabletDirName + "/00000_00000." + ext).toString();
            zki.initialize(context, opts.clearInstanceName, instanceNamePath, rootTabletDirName, rootTabletFileUri);
            if (!Initialize.createDirs(fs, instanceId, initConfig.getVolumeUris())) {
                throw new IOException("Problem creating directories on " + fs.getVolumes());
            }
            FileSystemInitializer fileSystemInitializer = new FileSystemInitializer(initConfig, zoo, instanceId);
            String rootVol = fs.choose(chooserEnv, initConfig.getVolumeUris());
            Path rootPath = new Path(rootVol + "/tables/" + RootTable.ID + "/" + rootTabletDirName);
            fileSystemInitializer.initialize(fs, rootPath.toString(), rootTabletFileUri, context);
            this.checkSASL(initConfig);
            Initialize.initSecurity(context, opts, rootUser);
            this.checkUploadProps(context, initConfig, opts);
        }
        catch (Exception e) {
            log.error("FATAL: Problem during initialize", (Throwable)e);
            return false;
        }
        return true;
    }

    private void checkUploadProps(ServerContext context, InitialConfiguration initConfig, Opts opts) {
        if (opts.uploadAccumuloProps) {
            log.info("Uploading properties in accumulo.properties to Zookeeper. Properties that cannot be set in Zookeeper will be skipped:");
            TreeMap<String, String> entries = new TreeMap<String, String>();
            initConfig.getProperties(entries, x -> true, false);
            for (Map.Entry entry : entries.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (Property.isValidZooPropertyKey((String)key)) {
                    SystemPropUtil.setSystemProperty(context, key, value);
                    log.info("Uploaded - {} = {}", (Object)key, (Object)(Property.isSensitive((String)key) ? "<hidden>" : value));
                    continue;
                }
                log.info("Skipped - {} = {}", (Object)key, (Object)(Property.isSensitive((String)key) ? "<hidden>" : value));
            }
        }
    }

    private void checkSASL(InitialConfiguration initConfig) throws IOException, AccumuloSecurityException {
        UserGroupInformation ugi;
        if (initConfig.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED) && !(ugi = UserGroupInformation.getCurrentUser()).hasKerberosCredentials()) {
            String accumuloKeytab = initConfig.get(Property.GENERAL_KERBEROS_KEYTAB);
            String accumuloPrincipal = initConfig.get(Property.GENERAL_KERBEROS_PRINCIPAL);
            if (StringUtils.isBlank((CharSequence)accumuloKeytab) || StringUtils.isBlank((CharSequence)accumuloPrincipal)) {
                log.error("FATAL: No Kerberos credentials provided, and Accumulo is not properly configured for server login");
                throw new AccumuloSecurityException(ugi.getUserName(), SecurityErrorCode.BAD_CREDENTIALS);
            }
            log.info("Logging in as {} with {}", (Object)accumuloPrincipal, (Object)accumuloKeytab);
            UserGroupInformation.loginUserFromKeytab((String)accumuloPrincipal, (String)accumuloKeytab);
        }
    }

    private static boolean zookeeperAvailable(ZooReaderWriter zoo) {
        try {
            return zoo.exists("/");
        }
        catch (InterruptedException | KeeperException e) {
            return false;
        }
    }

    private static boolean createDirs(VolumeManager fs, InstanceId instanceId, Set<String> baseDirs) {
        try {
            for (String baseDir : baseDirs) {
                boolean success;
                log.debug("creating instance directories for base: {}", (Object)baseDir);
                Path verDir = new Path(new Path(baseDir, "version"), "" + AccumuloDataVersion.get());
                FsPermission permission = new FsPermission("700");
                if (fs.exists(verDir)) {
                    FileStatus fsStat = fs.getFileStatus(verDir);
                    log.info("directory {} exists. Permissions match: {}", (Object)fsStat.getPath(), (Object)fsStat.getPermission().equals((Object)permission));
                } else {
                    success = fs.mkdirs(verDir, permission);
                    log.info("Directory {} created - call returned {}", (Object)verDir, (Object)success);
                }
                Path iidLocation = new Path(baseDir, "instance_id");
                if (fs.exists(iidLocation)) {
                    log.info("directory {} exists.", (Object)iidLocation);
                } else {
                    success = fs.mkdirs(iidLocation);
                    log.info("Directory {} created - call returned {}", (Object)iidLocation, (Object)success);
                }
                Path iidPath = new Path(iidLocation, instanceId.canonical());
                if (fs.exists(iidPath)) {
                    log.info("InstanceID file {} exists.", (Object)iidPath);
                    continue;
                }
                success = fs.createNewFile(iidPath);
                if (success && fs.exists(iidPath)) {
                    log.info("Created instanceId file {} in hdfs", (Object)iidPath);
                    continue;
                }
                log.warn("May have failed to create instanceId file {} in hdfs", (Object)iidPath);
            }
            return true;
        }
        catch (IOException e) {
            log.error("Problem creating new directories", (Throwable)e);
            return false;
        }
    }

    private String getInstanceNamePrefix() {
        return "/accumulo/instances/";
    }

    private String getInstanceNamePath(ZooReaderWriter zoo, Opts opts) throws KeeperException, InterruptedException {
        String instanceNamePath = null;
        boolean exists = true;
        do {
            String instanceName;
            if ((instanceName = opts.cliInstanceName == null ? System.console().readLine("Instance name : ", new Object[0]) : opts.cliInstanceName) == null) {
                System.exit(0);
            }
            if ((instanceName = instanceName.trim()).isEmpty()) continue;
            instanceNamePath = this.getInstanceNamePrefix() + instanceName;
            if (opts.clearInstanceName) {
                exists = false;
                continue;
            }
            exists = zoo.exists(instanceNamePath);
            if (!exists) continue;
            String decision = System.console().readLine("Instance name \"" + instanceName + "\" exists. Delete existing entry from zookeeper? [Y/N] : ", new Object[0]);
            if (decision == null) {
                System.exit(0);
            }
            if (decision.length() != 1 || decision.toLowerCase(Locale.ENGLISH).charAt(0) != 'y') continue;
            opts.clearInstanceName = true;
            exists = false;
        } while (exists);
        return instanceNamePath;
    }

    private String getRootUserName(InitialConfiguration initConfig, Opts opts) {
        String user;
        String keytab = initConfig.get(Property.GENERAL_KERBEROS_KEYTAB);
        if (keytab.equals(Property.GENERAL_KERBEROS_KEYTAB.getDefaultValue()) || !initConfig.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            return DEFAULT_ROOT_USER;
        }
        System.out.println("Running against secured HDFS");
        if (opts.rootUser != null) {
            return opts.rootUser;
        }
        do {
            if ((user = System.console().readLine("Principal (user) to grant administrative privileges to : ", new Object[0])) != null) continue;
            System.exit(1);
        } while (user.isEmpty());
        return user;
    }

    private byte[] getRootPassword(InitialConfiguration initConfig, Opts opts, String rootUser) {
        String strconfirmpass;
        String strrootpass;
        if (opts.cliPassword != null) {
            return opts.cliPassword.getBytes(StandardCharsets.UTF_8);
        }
        do {
            char[] confirmpass;
            char[] rootpass;
            if ((rootpass = System.console().readPassword("Enter initial password for " + rootUser + this.getInitialPasswordWarning(initConfig), new Object[0])) == null) {
                System.exit(0);
            }
            if ((confirmpass = System.console().readPassword("Confirm initial password for " + rootUser + ":", new Object[0])) == null) {
                System.exit(0);
            }
            if ((strrootpass = new String(rootpass)).equals(strconfirmpass = new String(confirmpass))) continue;
            log.error("Passwords do not match");
        } while (!strrootpass.equals(strconfirmpass));
        return strrootpass.getBytes(StandardCharsets.UTF_8);
    }

    private String getInitialPasswordWarning(InitialConfiguration initConfig) {
        Property authenticatorProperty = Property.INSTANCE_SECURITY_AUTHENTICATOR;
        String optionalWarning = initConfig.get(authenticatorProperty).equals(authenticatorProperty.getDefaultValue()) ? ": " : " (this may not be applicable for your security setup): ";
        return optionalWarning;
    }

    private static void initSecurity(ServerContext context, Opts opts, String rootUser) throws AccumuloSecurityException {
        context.getSecurityOperation().initializeSecurity(context.rpcCreds(), rootUser, opts.rootpass);
    }

    static boolean isInitialized(VolumeManager fs, InitialConfiguration initConfig) throws IOException {
        for (String baseDir : initConfig.getVolumeUris()) {
            if (!fs.exists(new Path(baseDir, "instance_id")) && !fs.exists(new Path(baseDir, "version"))) continue;
            return true;
        }
        return false;
    }

    private static boolean addVolumes(VolumeManager fs, InitialConfiguration initConfig, ServerDirs serverDirs) {
        Configuration hadoopConf = initConfig.getHadoopConf();
        SiteConfiguration siteConfig = initConfig.getSiteConf();
        Set volumeURIs = VolumeConfiguration.getVolumeUris((AccumuloConfiguration)siteConfig);
        Set<String> initializedDirs = serverDirs.checkBaseUris(hadoopConf, volumeURIs, true);
        HashSet<String> uinitializedDirs = new HashSet<String>(volumeURIs);
        uinitializedDirs.removeAll(initializedDirs);
        Path aBasePath = new Path(initializedDirs.iterator().next());
        Path iidPath = new Path(aBasePath, "instance_id");
        Path versionPath = new Path(aBasePath, "version");
        InstanceId instanceId = VolumeManager.getInstanceIDFromHdfs(iidPath, hadoopConf);
        for (Pair<Path, Path> replacementVolume : serverDirs.getVolumeReplacements()) {
            if (!aBasePath.equals(replacementVolume.getFirst())) continue;
            log.error("{} is set to be replaced in {} and should not appear in {}. It is highly recommended that this property be removed as data could still be written to this volume.", new Object[]{aBasePath, Property.INSTANCE_VOLUMES_REPLACEMENTS, Property.INSTANCE_VOLUMES});
        }
        try {
            int persistentVersion = serverDirs.getAccumuloPersistentVersion(versionPath.getFileSystem(hadoopConf), versionPath);
            if (persistentVersion != AccumuloDataVersion.get()) {
                throw new IOException("Accumulo 2.1.0 cannot initialize data version " + persistentVersion);
            }
        }
        catch (IOException e) {
            log.error("Problem getting accumulo data version", (Throwable)e);
            return false;
        }
        return Initialize.createDirs(fs, instanceId, uinitializedDirs);
    }

    public String keyword() {
        return "init";
    }

    public KeywordExecutable.UsageGroup usageGroup() {
        return KeywordExecutable.UsageGroup.CORE;
    }

    public String description() {
        return "Initializes Accumulo";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String[] args) {
        boolean success = true;
        Opts opts = new Opts();
        opts.parseArgs("accumulo init", args, new Object[0]);
        SiteConfiguration siteConfig = SiteConfiguration.auto();
        ZooReaderWriter zoo = new ZooReaderWriter((AccumuloConfiguration)siteConfig);
        SecurityUtil.serverLogin((AccumuloConfiguration)siteConfig);
        Configuration hadoopConfig = new Configuration();
        InitialConfiguration initConfig = new InitialConfiguration(hadoopConfig, siteConfig);
        ServerDirs serverDirs = new ServerDirs((AccumuloConfiguration)siteConfig, hadoopConfig);
        try (VolumeManager fs = VolumeManagerImpl.get((AccumuloConfiguration)siteConfig, hadoopConfig);){
            if (opts.resetSecurity) {
                success = this.resetSecurity(initConfig, opts, fs);
            }
            if (success && opts.addVolumes) {
                success = Initialize.addVolumes(fs, initConfig, serverDirs);
            }
            if (!opts.resetSecurity && !opts.addVolumes) {
                success = this.doInit(zoo, opts, fs, initConfig);
            }
        }
        catch (IOException e) {
            log.error("Problem trying to get Volume configuration", (Throwable)e);
            success = false;
        }
        finally {
            SingletonManager.setMode((SingletonManager.Mode)SingletonManager.Mode.CLOSED);
            if (!success) {
                System.exit(-1);
            }
        }
    }

    private boolean resetSecurity(InitialConfiguration initConfig, Opts opts, VolumeManager fs) {
        boolean bl;
        log.info("Resetting security on accumulo.");
        ServerContext context = new ServerContext(initConfig.getSiteConf());
        try {
            String userEnteredName;
            if (!Initialize.isInitialized(fs, initConfig)) {
                throw new IllegalStateException("FATAL: Attempted to reset security on accumulo before it was initialized");
            }
            if (!opts.forceResetSecurity && (userEnteredName = System.console().readLine("WARNING: This will remove all users from Accumulo! If you wish to proceed enter the instance name: ", new Object[0])) != null && !context.getInstanceName().equals(userEnteredName)) {
                throw new IllegalStateException("Aborted reset security: Instance name did not match current instance.");
            }
            String rootUser = this.getRootUserName(initConfig, opts);
            opts.rootpass = this.getRootPassword(initConfig, opts, rootUser);
            Initialize.initSecurity(context, opts, rootUser);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    context.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("Problem calling reset security", (Throwable)e);
                return false;
            }
        }
        context.close();
        return bl;
    }

    public static void main(String[] args) {
        new Initialize().execute(args);
    }

    private static class Opts
    extends Help {
        @Parameter(names={"--add-volumes"}, description="Initialize any uninitialized volumes listed in instance.volumes")
        boolean addVolumes = false;
        @Parameter(names={"--reset-security"}, description="just update the security information, will prompt")
        boolean resetSecurity = false;
        @Parameter(names={"-f", "--force"}, description="force reset of the security information without prompting")
        boolean forceResetSecurity = false;
        @Parameter(names={"--clear-instance-name"}, description="delete any existing instance name without prompting")
        boolean clearInstanceName = false;
        @Parameter(names={"--upload-accumulo-props"}, description="Uploads properties in accumulo.properties to Zookeeper")
        boolean uploadAccumuloProps = false;
        @Parameter(names={"--instance-name"}, description="the instance name, if not provided, will prompt")
        String cliInstanceName = null;
        @Parameter(names={"--password"}, description="set the password on the command line")
        String cliPassword = null;
        @Parameter(names={"-u", "--user"}, description="the name of the user to grant system permissions to")
        String rootUser = null;
        byte[] rootpass = null;

        private Opts() {
        }
    }
}

