/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.manager.state;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletLocationState;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.manager.state.Assignment;
import org.apache.accumulo.server.manager.state.ClosableIterator;
import org.apache.accumulo.server.manager.state.CurrentState;
import org.apache.accumulo.server.manager.state.DistributedStoreException;
import org.apache.accumulo.server.manager.state.LoggingTabletStateStore;
import org.apache.accumulo.server.manager.state.MetaDataStateStore;
import org.apache.accumulo.server.manager.state.RootTabletStateStore;
import org.apache.accumulo.server.manager.state.ZooTabletStateStore;
import org.apache.hadoop.fs.Path;

public interface TabletStateStore
extends Iterable<TabletLocationState> {
    public String name();

    @Override
    public ClosableIterator<TabletLocationState> iterator();

    public void setFutureLocations(Collection<Assignment> var1) throws DistributedStoreException;

    public void setLocations(Collection<Assignment> var1) throws DistributedStoreException;

    public void unassign(Collection<TabletLocationState> var1, Map<TServerInstance, List<Path>> var2) throws DistributedStoreException;

    public void suspend(Collection<TabletLocationState> var1, Map<TServerInstance, List<Path>> var2, long var3) throws DistributedStoreException;

    public void unsuspend(Collection<TabletLocationState> var1) throws DistributedStoreException;

    public static void unassign(ServerContext context, TabletLocationState tls, Map<TServerInstance, List<Path>> logsForDeadServers) throws DistributedStoreException {
        TabletStateStore.getStoreForTablet(tls.extent, context).unassign(Collections.singletonList(tls), logsForDeadServers);
    }

    public static void suspend(ServerContext context, TabletLocationState tls, Map<TServerInstance, List<Path>> logsForDeadServers, long suspensionTimestamp) throws DistributedStoreException {
        TabletStateStore.getStoreForTablet(tls.extent, context).suspend(Collections.singletonList(tls), logsForDeadServers, suspensionTimestamp);
    }

    public static void setLocation(ServerContext context, Assignment assignment) throws DistributedStoreException {
        TabletStateStore.getStoreForTablet(assignment.tablet, context).setLocations(Collections.singletonList(assignment));
    }

    public static TabletStateStore getStoreForTablet(KeyExtent extent, ServerContext context) {
        return TabletStateStore.getStoreForLevel(Ample.DataLevel.of((TableId)extent.tableId()), context);
    }

    public static TabletStateStore getStoreForLevel(Ample.DataLevel level, ClientContext context) {
        return TabletStateStore.getStoreForLevel(level, context, null);
    }

    public static TabletStateStore getStoreForLevel(Ample.DataLevel level, ClientContext context, CurrentState state) {
        TabletStateStore tss;
        switch (level) {
            case ROOT: {
                tss = new ZooTabletStateStore(context.getAmple());
                break;
            }
            case METADATA: {
                tss = new RootTabletStateStore(context, state);
                break;
            }
            case USER: {
                tss = new MetaDataStateStore(context, state);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown level " + level);
            }
        }
        return new LoggingTabletStateStore(tss);
    }
}

