/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.metadata;

import com.google.common.base.Preconditions;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.FateTxId;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.SuspendingTServer;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionMetadata;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.MetadataTime;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.server.ServerContext;
import org.apache.hadoop.io.Text;

public abstract class TabletMutatorBase
implements Ample.TabletMutator {
    private final ServerContext context;
    private final KeyExtent extent;
    private final Mutation mutation;
    protected AutoCloseable closeAfterMutate;
    private boolean updatesEnabled = true;

    protected TabletMutatorBase(ServerContext context, KeyExtent extent) {
        this.extent = extent;
        this.context = context;
        this.mutation = new Mutation(extent.toMetaRow());
    }

    public Ample.TabletMutator putPrevEndRow(Text per) {
        Preconditions.checkState((boolean)this.updatesEnabled, (Object)"Cannot make updates after calling mutate.");
        MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.put(this.mutation, MetadataSchema.TabletsSection.TabletColumnFamily.encodePrevEndRow((Text)this.extent.prevEndRow()));
        return this;
    }

    public Ample.TabletMutator putDirName(String dirName) {
        MetadataSchema.TabletsSection.ServerColumnFamily.validateDirCol((String)dirName);
        Preconditions.checkState((boolean)this.updatesEnabled, (Object)"Cannot make updates after calling mutate.");
        MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(this.mutation, new Value((CharSequence)dirName));
        return this;
    }

    public Ample.TabletMutator putFile(TabletFile path, DataFileValue dfv) {
        Preconditions.checkState((boolean)this.updatesEnabled, (Object)"Cannot make updates after calling mutate.");
        this.mutation.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, path.getMetaInsertText(), new Value(dfv.encode()));
        return this;
    }

    public Ample.TabletMutator deleteFile(StoredTabletFile path) {
        Preconditions.checkState((boolean)this.updatesEnabled, (Object)"Cannot make updates after calling mutate.");
        this.mutation.putDelete(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, path.getMetaUpdateDeleteText());
        return this;
    }

    public Ample.TabletMutator putScan(TabletFile path) {
        Preconditions.checkState((boolean)this.updatesEnabled, (Object)"Cannot make updates after calling mutate.");
        this.mutation.put(MetadataSchema.TabletsSection.ScanFileColumnFamily.NAME, path.getMetaInsertText(), new Value());
        return this;
    }

    public Ample.TabletMutator deleteScan(StoredTabletFile path) {
        Preconditions.checkState((boolean)this.updatesEnabled, (Object)"Cannot make updates after calling mutate.");
        this.mutation.putDelete(MetadataSchema.TabletsSection.ScanFileColumnFamily.NAME, path.getMetaUpdateDeleteText());
        return this;
    }

    public Ample.TabletMutator putCompactionId(long compactionId) {
        Preconditions.checkState((boolean)this.updatesEnabled, (Object)"Cannot make updates after calling mutate.");
        MetadataSchema.TabletsSection.ServerColumnFamily.COMPACT_COLUMN.put(this.mutation, new Value((CharSequence)Long.toString(compactionId)));
        return this;
    }

    public Ample.TabletMutator putFlushId(long flushId) {
        Preconditions.checkState((boolean)this.updatesEnabled, (Object)"Cannot make updates after calling mutate.");
        MetadataSchema.TabletsSection.ServerColumnFamily.FLUSH_COLUMN.put(this.mutation, new Value((CharSequence)Long.toString(flushId)));
        return this;
    }

    public Ample.TabletMutator putTime(MetadataTime time) {
        Preconditions.checkState((boolean)this.updatesEnabled, (Object)"Cannot make updates after calling mutate.");
        MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(this.mutation, new Value((CharSequence)time.encode()));
        return this;
    }

    private String getLocationFamily(TabletMetadata.LocationType type) {
        switch (type) {
            case CURRENT: {
                return "loc";
            }
            case FUTURE: {
                return "future";
            }
            case LAST: {
                return "last";
            }
        }
        throw new IllegalArgumentException();
    }

    public Ample.TabletMutator putLocation(TServerInstance tsi, TabletMetadata.LocationType type) {
        Preconditions.checkState((boolean)this.updatesEnabled, (Object)"Cannot make updates after calling mutate.");
        this.mutation.put((CharSequence)this.getLocationFamily(type), (CharSequence)tsi.getSession(), (CharSequence)tsi.getHostPort());
        return this;
    }

    public Ample.TabletMutator deleteLocation(TServerInstance tsi, TabletMetadata.LocationType type) {
        Preconditions.checkState((boolean)this.updatesEnabled, (Object)"Cannot make updates after calling mutate.");
        this.mutation.putDelete((CharSequence)this.getLocationFamily(type), (CharSequence)tsi.getSession());
        return this;
    }

    public Ample.TabletMutator putZooLock(ServiceLock zooLock) {
        Preconditions.checkState((boolean)this.updatesEnabled, (Object)"Cannot make updates after calling mutate.");
        MetadataSchema.TabletsSection.ServerColumnFamily.LOCK_COLUMN.put(this.mutation, new Value((CharSequence)zooLock.getLockID().serialize(this.context.getZooKeeperRoot() + "/")));
        return this;
    }

    public Ample.TabletMutator putWal(LogEntry logEntry) {
        Preconditions.checkState((boolean)this.updatesEnabled, (Object)"Cannot make updates after calling mutate.");
        this.mutation.put(logEntry.getColumnFamily(), logEntry.getColumnQualifier(), logEntry.getValue());
        return this;
    }

    public Ample.TabletMutator deleteWal(LogEntry logEntry) {
        Preconditions.checkState((boolean)this.updatesEnabled, (Object)"Cannot make updates after calling mutate.");
        this.mutation.putDelete(logEntry.getColumnFamily(), logEntry.getColumnQualifier());
        return this;
    }

    public Ample.TabletMutator deleteWal(String wal) {
        Preconditions.checkState((boolean)this.updatesEnabled, (Object)"Cannot make updates after calling mutate.");
        this.mutation.putDelete((CharSequence)"log", (CharSequence)wal);
        return this;
    }

    public Ample.TabletMutator putBulkFile(TabletFile bulkref, long tid) {
        Preconditions.checkState((boolean)this.updatesEnabled, (Object)"Cannot make updates after calling mutate.");
        this.mutation.put(MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME, bulkref.getMetaInsertText(), new Value((CharSequence)FateTxId.formatTid((long)tid)));
        return this;
    }

    public Ample.TabletMutator deleteBulkFile(TabletFile bulkref) {
        Preconditions.checkState((boolean)this.updatesEnabled, (Object)"Cannot make updates after calling mutate.");
        this.mutation.putDelete(MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME, bulkref.getMetaInsertText());
        return this;
    }

    public Ample.TabletMutator putChopped() {
        Preconditions.checkState((boolean)this.updatesEnabled, (Object)"Cannot make updates after calling mutate.");
        MetadataSchema.TabletsSection.ChoppedColumnFamily.CHOPPED_COLUMN.put(this.mutation, new Value((CharSequence)"chopped"));
        return this;
    }

    public Ample.TabletMutator putSuspension(TServerInstance tServer, long suspensionTime) {
        Preconditions.checkState((boolean)this.updatesEnabled, (Object)"Cannot make updates after calling mutate.");
        this.mutation.put(MetadataSchema.TabletsSection.SuspendLocationColumn.SUSPEND_COLUMN.getColumnFamily(), MetadataSchema.TabletsSection.SuspendLocationColumn.SUSPEND_COLUMN.getColumnQualifier(), SuspendingTServer.toValue((TServerInstance)tServer, (long)suspensionTime));
        return this;
    }

    public Ample.TabletMutator deleteSuspension() {
        Preconditions.checkState((boolean)this.updatesEnabled, (Object)"Cannot make updates after calling mutate.");
        this.mutation.putDelete(MetadataSchema.TabletsSection.SuspendLocationColumn.SUSPEND_COLUMN.getColumnFamily(), MetadataSchema.TabletsSection.SuspendLocationColumn.SUSPEND_COLUMN.getColumnQualifier());
        return this;
    }

    public Ample.TabletMutator putExternalCompaction(ExternalCompactionId ecid, ExternalCompactionMetadata ecMeta) {
        this.mutation.put((CharSequence)"ecomp", (CharSequence)ecid.canonical(), (CharSequence)ecMeta.toJson());
        return this;
    }

    public Ample.TabletMutator deleteExternalCompaction(ExternalCompactionId ecid) {
        this.mutation.putDelete((CharSequence)"ecomp", (CharSequence)ecid.canonical());
        return this;
    }

    protected Mutation getMutation() {
        this.updatesEnabled = false;
        return this.mutation;
    }

    public void setCloseAfterMutate(AutoCloseable closeable) {
        this.closeAfterMutate = closeable;
    }
}

