/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.problems;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.iterators.SortedKeyIterator;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProblemReports
implements Iterable<ProblemReport> {
    private static final Logger log = LoggerFactory.getLogger(ProblemReports.class);
    private final LRUMap<ProblemReport, Long> problemReports = new LRUMap(1000);
    private ExecutorService reportExecutor = ThreadPools.getServerThreadPools().createThreadPool(0, 1, 60L, TimeUnit.SECONDS, "acu-problem-reporter", new LinkedBlockingQueue(500), false);
    private final ServerContext context;
    private static ProblemReports instance;

    public ProblemReports(ServerContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(ProblemReport pr) {
        LRUMap<ProblemReport, Long> lRUMap = this.problemReports;
        synchronized (lRUMap) {
            if (this.problemReports.containsKey((Object)pr)) {
                return;
            }
            this.problemReports.put((Object)pr, (Object)System.currentTimeMillis());
        }
        Runnable r = () -> {
            log.debug("Filing problem report {} {} {}", new Object[]{pr.getTableId(), pr.getProblemType(), pr.getResource()});
            try {
                if (ProblemReports.isMeta(pr.getTableId())) {
                    pr.saveToZooKeeper(this.context);
                } else {
                    pr.saveToMetadataTable(this.context);
                }
            }
            catch (Exception e) {
                log.error("Failed to file problem report " + pr.getTableId() + " " + pr.getProblemType() + " " + pr.getResource(), (Throwable)e);
            }
        };
        try {
            this.reportExecutor.execute(r);
        }
        catch (RejectedExecutionException ree) {
            log.error("Failed to report problem {} {} {} {}", new Object[]{pr.getTableId(), pr.getProblemType(), pr.getResource(), ree.getMessage()});
        }
    }

    public void printProblems() {
        for (ProblemReport pr : this) {
            System.out.println(pr.getTableId() + " " + pr.getProblemType() + " " + pr.getResource() + " " + pr.getException());
        }
    }

    public void deleteProblemReport(TableId table, ProblemType pType, String resource) {
        ProblemReport pr = new ProblemReport(table, pType, resource, null);
        Runnable r = () -> {
            try {
                if (ProblemReports.isMeta(pr.getTableId())) {
                    pr.removeFromZooKeeper(this.context);
                } else {
                    pr.removeFromMetadataTable(this.context);
                }
            }
            catch (Exception e) {
                log.error("Failed to delete problem report {} {} {}", new Object[]{pr.getTableId(), pr.getProblemType(), pr.getResource(), e});
            }
        };
        try {
            this.reportExecutor.execute(r);
        }
        catch (RejectedExecutionException ree) {
            log.error("Failed to delete problem report {} {} {} {}", new Object[]{pr.getTableId(), pr.getProblemType(), pr.getResource(), ree.getMessage()});
        }
    }

    public void deleteProblemReports(TableId table) throws Exception {
        if (ProblemReports.isMeta(table)) {
            Iterator<ProblemReport> pri = this.iterator(table);
            while (pri.hasNext()) {
                pri.next().removeFromZooKeeper(this.context);
            }
            return;
        }
        Scanner scanner = this.context.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
        scanner.addScanIterator(new IteratorSetting(1, "keys-only", SortedKeyIterator.class));
        scanner.setRange(new Range(new Text("~err_" + table)));
        Mutation delMut = new Mutation(new Text("~err_" + table));
        boolean hasProblems = false;
        for (Map.Entry entry : scanner) {
            hasProblems = true;
            delMut.putDelete(((Key)entry.getKey()).getColumnFamily(), ((Key)entry.getKey()).getColumnQualifier());
        }
        if (hasProblems) {
            MetadataTableUtil.getMetadataTable(this.context).update(delMut);
        }
    }

    private static boolean isMeta(TableId tableId) {
        return tableId.equals((Object)MetadataTable.ID) || tableId.equals((Object)RootTable.ID);
    }

    public Iterator<ProblemReport> iterator(final TableId table) {
        try {
            return new Iterator<ProblemReport>(){
                ZooReaderWriter zoo;
                private int iter1Count;
                private Iterator<String> iter1;
                private Iterator<Map.Entry<Key, Value>> iter2;
                {
                    this.zoo = ProblemReports.this.context.getZooReaderWriter();
                    this.iter1Count = 0;
                }

                private Iterator<String> getIter1() {
                    if (this.iter1 == null) {
                        try {
                            List children = table == null || ProblemReports.isMeta(table) ? this.zoo.getChildren(ProblemReports.this.context.getZooKeeperRoot() + "/problems") : Collections.emptyList();
                            this.iter1 = children.iterator();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return this.iter1;
                }

                private Iterator<Map.Entry<Key, Value>> getIter2() {
                    if (this.iter2 == null) {
                        try {
                            if (!(table != null && ProblemReports.isMeta(table) || this.iter1Count != 0)) {
                                Scanner scanner = ProblemReports.this.context.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
                                scanner.setTimeout(3L, TimeUnit.SECONDS);
                                if (table == null) {
                                    scanner.setRange(new Range(new Text("~err_"), false, new Text("~err`"), false));
                                } else {
                                    scanner.setRange(new Range(new Text("~err_" + table)));
                                }
                                this.iter2 = scanner.iterator();
                            } else {
                                Map m = Collections.emptyMap();
                                this.iter2 = m.entrySet().iterator();
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return this.iter2;
                }

                @Override
                public boolean hasNext() {
                    if (this.getIter1().hasNext()) {
                        return true;
                    }
                    return this.getIter2().hasNext();
                }

                @Override
                public ProblemReport next() {
                    try {
                        if (this.getIter1().hasNext()) {
                            ++this.iter1Count;
                            return ProblemReport.decodeZooKeeperEntry(ProblemReports.this.context, this.getIter1().next());
                        }
                        if (this.getIter2().hasNext()) {
                            return ProblemReport.decodeMetadataEntry(this.getIter2().next());
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<ProblemReport> iterator() {
        return this.iterator(null);
    }

    public static synchronized ProblemReports getInstance(ServerContext context) {
        if (instance == null) {
            instance = new ProblemReports(context);
        }
        return instance;
    }

    public static void main(String[] args) {
        ServerContext context = new ServerContext(SiteConfiguration.auto());
        ProblemReports.getInstance(context).printProblems();
    }

    public Map<TableId, Map<ProblemType, Integer>> summarize() {
        TreeMap<TableId, Map<ProblemType, Integer>> summary = new TreeMap<TableId, Map<ProblemType, Integer>>();
        for (ProblemReport pr : this) {
            Integer count;
            Map<ProblemType, Integer> tableProblems = summary.get(pr.getTableId());
            if (tableProblems == null) {
                tableProblems = new EnumMap<ProblemType, Integer>(ProblemType.class);
                summary.put(pr.getTableId(), tableProblems);
            }
            if ((count = tableProblems.get((Object)pr.getProblemType())) == null) {
                count = 0;
            }
            tableProblems.put(pr.getProblemType(), count + 1);
        }
        return summary;
    }
}

