/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.rpc;

import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.metrics.MetricsUtil;
import org.apache.accumulo.server.metrics.ThriftMetrics;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;

public class TimedProcessor
implements TProcessor {
    private final TProcessor other;
    private final ThriftMetrics thriftMetrics;
    private long idleStart = 0L;

    public TimedProcessor(AccumuloConfiguration conf, TProcessor next, String serverName, String threadName) {
        this(next, serverName, threadName);
    }

    public TimedProcessor(TProcessor next, String serverName, String threadName) {
        this.other = next;
        this.thriftMetrics = new ThriftMetrics(serverName, threadName);
        MetricsUtil.initializeProducers((MetricsProducer[])new MetricsProducer[]{this.thriftMetrics});
        this.idleStart = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(TProtocol in, TProtocol out) throws TException {
        long now = System.currentTimeMillis();
        this.thriftMetrics.addIdle(now - this.idleStart);
        try {
            this.other.process(in, out);
        }
        finally {
            this.idleStart = System.currentTimeMillis();
            this.thriftMetrics.addExecute(this.idleStart - now);
        }
    }
}

