/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util.fateCommand;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.accumulo.core.fate.AdminUtil;

public class FateTxnDetails
implements Comparable<FateTxnDetails> {
    static final String TXN_HEADER = "Running\ttxn_id\t\t\t\tStatus\t\tCommand\t\tStep (top)\t\tlocks held:(table id, name)\tlocks waiting:(table id, name)";
    private long running;
    private String status = "?";
    private String txName = "?";
    private String step = "?";
    private String txnId = "?";
    private List<String> locksHeld = List.of();
    private List<String> locksWaiting = List.of();

    public FateTxnDetails(long reportTime, AdminUtil.TransactionStatus txnStatus, Map<String, String> idsToNameMap) {
        if (txnStatus == null) {
            return;
        }
        if (txnStatus.getTimeCreated() != 0L) {
            this.running = reportTime - txnStatus.getTimeCreated();
        }
        if (txnStatus.getStatus() != null) {
            this.status = txnStatus.getStatus().name();
        }
        if (txnStatus.getTop() != null) {
            this.step = txnStatus.getTop();
        }
        if (txnStatus.getTxName() != null) {
            this.txName = txnStatus.getTxName();
        }
        if (txnStatus.getTxid() != null) {
            this.txnId = txnStatus.getTxid();
        }
        this.locksHeld = this.formatLockInfo(txnStatus.getHeldLocks(), idsToNameMap);
        this.locksWaiting = this.formatLockInfo(txnStatus.getWaitingLocks(), idsToNameMap);
    }

    private List<String> formatLockInfo(List<String> lockInfo, Map<String, String> idsToNameMap) {
        ArrayList<String> formattedLocks = new ArrayList<String>();
        for (String lock : lockInfo) {
            String[] parts = lock.split(":");
            if (parts.length != 2) continue;
            String lockType = parts[0];
            String id = parts[1];
            formattedLocks.add(String.format("%s:(%s,%s)", lockType, id, idsToNameMap.get(id)));
        }
        return formattedLocks;
    }

    public String getTxnId() {
        return this.txnId;
    }

    @Override
    public int compareTo(FateTxnDetails other) {
        int v = Long.compare(other.running, this.running);
        if (v != 0) {
            return v;
        }
        return this.txnId.compareTo(other.txnId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FateTxnDetails that = (FateTxnDetails)o;
        return this.running == that.running && this.txnId.equals(that.txnId);
    }

    public int hashCode() {
        return Objects.hash(this.running, this.txnId);
    }

    public String toString() {
        Duration elapsed = Duration.ofMillis(this.running);
        String hms = String.format("%d:%02d:%02d", elapsed.toHours(), elapsed.toMinutesPart(), elapsed.toSecondsPart());
        return hms + "\t" + this.txnId + "\t" + this.status + "\t" + this.txName + "\t" + this.step + "\theld:" + this.locksHeld.toString() + "\twaiting:" + this.locksWaiting.toString();
    }
}

