/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.crypto.CryptoFactoryLoader;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.rpc.SslConnectionParams;
import org.apache.accumulo.core.singletons.SingletonReservation;
import org.apache.accumulo.core.spi.crypto.CryptoServiceFactory;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.accumulo.server.AccumuloDataVersion;
import org.apache.accumulo.server.ServerDirs;
import org.apache.accumulo.server.ServerInfo;
import org.apache.accumulo.server.conf.NamespaceConfiguration;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.conf.store.PropStore;
import org.apache.accumulo.server.conf.store.impl.ZooPropStore;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.metadata.ServerAmpleImpl;
import org.apache.accumulo.server.rpc.SaslServerConnectionParams;
import org.apache.accumulo.server.rpc.ThriftServerType;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SecurityOperation;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.server.security.delegation.AuthenticationTokenSecretManager;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.accumulo.server.tablets.UniqueNameAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerContext
extends ClientContext {
    private static final Logger log = LoggerFactory.getLogger(ServerContext.class);
    private final ServerInfo info;
    private final ZooReaderWriter zooReaderWriter;
    private final ServerDirs serverDirs;
    private final Supplier<ZooPropStore> propStore;
    private final Supplier<TableManager> tableManager;
    private final Supplier<UniqueNameAllocator> nameAllocator;
    private final Supplier<ServerConfigurationFactory> serverConfFactory;
    private final Supplier<AuthenticationTokenSecretManager> secretManager;
    private final Supplier<ScheduledThreadPoolExecutor> sharedScheduledThreadPool;
    private final Supplier<AuditedSecurityOperation> securityOperation;
    private final Supplier<CryptoServiceFactory> cryptoFactorySupplier;

    public ServerContext(SiteConfiguration siteConfig) {
        this(new ServerInfo(siteConfig));
    }

    private ServerContext(ServerInfo info) {
        super(SingletonReservation.noop(), (ClientInfo)info, (AccumuloConfiguration)info.getSiteConfiguration(), Threads.UEH);
        this.info = info;
        this.zooReaderWriter = new ZooReaderWriter((AccumuloConfiguration)info.getSiteConfiguration());
        this.serverDirs = info.getServerDirs();
        this.propStore = Suppliers.memoize(() -> ZooPropStore.initialize(this.getInstanceID(), this.getZooReaderWriter()));
        this.tableManager = Suppliers.memoize(() -> new TableManager(this));
        this.nameAllocator = Suppliers.memoize(() -> new UniqueNameAllocator(this));
        this.serverConfFactory = Suppliers.memoize(() -> new ServerConfigurationFactory(this, this.getSiteConfiguration()));
        this.secretManager = Suppliers.memoize(() -> new AuthenticationTokenSecretManager(this.getInstanceID(), this.getConfiguration().getTimeInMillis(Property.GENERAL_DELEGATION_TOKEN_LIFETIME)));
        this.cryptoFactorySupplier = Suppliers.memoize(() -> CryptoFactoryLoader.newInstance((AccumuloConfiguration)this.getConfiguration()));
        this.sharedScheduledThreadPool = Suppliers.memoize(() -> ThreadPools.getServerThreadPools().createGeneralScheduledExecutorService(this.getConfiguration()));
        this.securityOperation = Suppliers.memoize(() -> new AuditedSecurityOperation(this, SecurityOperation.getAuthorizor(this), SecurityOperation.getAuthenticator(this), SecurityOperation.getPermHandler(this)));
    }

    public static ServerContext initialize(SiteConfiguration siteConfig, String instanceName, InstanceId instanceID) {
        return new ServerContext(new ServerInfo(siteConfig, instanceName, instanceID));
    }

    public static ServerContext override(SiteConfiguration siteConfig, String instanceName, String zooKeepers, int zkSessionTimeOut) {
        return new ServerContext(new ServerInfo(siteConfig, instanceName, zooKeepers, zkSessionTimeOut));
    }

    public InstanceId getInstanceID() {
        return this.info.getInstanceID();
    }

    public SiteConfiguration getSiteConfiguration() {
        return this.info.getSiteConfiguration();
    }

    public AccumuloConfiguration getConfiguration() {
        return this.serverConfFactory.get().getSystemConfiguration();
    }

    public TableConfiguration getTableConfiguration(TableId id) {
        return this.serverConfFactory.get().getTableConfiguration(id);
    }

    public NamespaceConfiguration getNamespaceConfiguration(NamespaceId namespaceId) {
        return this.serverConfFactory.get().getNamespaceConfiguration(namespaceId);
    }

    public DefaultConfiguration getDefaultConfiguration() {
        return DefaultConfiguration.getInstance();
    }

    public ServerDirs getServerDirs() {
        return this.serverDirs;
    }

    void enforceKerberosLogin() {
        UserGroupInformation loginUser;
        SiteConfiguration conf = this.getSiteConfiguration();
        String kerberosPrincipal = SecurityUtil.getServerPrincipal(conf.get(Property.GENERAL_KERBEROS_PRINCIPAL));
        try {
            loginUser = UserGroupInformation.getLoginUser();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get login user", e);
        }
        Preconditions.checkArgument((boolean)loginUser.hasKerberosCredentials(), (Object)"Server does not have Kerberos credentials");
        Preconditions.checkArgument((boolean)kerberosPrincipal.equals(loginUser.getUserName()), (Object)("Expected login user to be " + kerberosPrincipal + " but was " + loginUser.getUserName()));
    }

    public VolumeManager getVolumeManager() {
        return this.info.getVolumeManager();
    }

    public ZooReader getZooReader() {
        return this.getZooReaderWriter();
    }

    public ZooReaderWriter getZooReaderWriter() {
        return this.zooReaderWriter;
    }

    public SslConnectionParams getServerSslParams() {
        return SslConnectionParams.forServer((AccumuloConfiguration)this.getConfiguration());
    }

    public SaslServerConnectionParams getSaslParams() {
        SiteConfiguration conf = this.getSiteConfiguration();
        if (!conf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            return null;
        }
        return new SaslServerConnectionParams((AccumuloConfiguration)conf, this.getCredentials().getToken(), this.getSecretManager());
    }

    public ThriftServerType getThriftServerType() {
        AccumuloConfiguration conf = this.getConfiguration();
        if (conf.getBoolean(Property.INSTANCE_RPC_SSL_ENABLED)) {
            if (conf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
                throw new IllegalStateException("Cannot create a Thrift server capable of both SASL and SSL");
            }
            return ThriftServerType.SSL;
        }
        if (conf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            if (conf.getBoolean(Property.INSTANCE_RPC_SSL_ENABLED)) {
                throw new IllegalStateException("Cannot create a Thrift server capable of both SASL and SSL");
            }
            return ThriftServerType.SASL;
        }
        String serverTypeName = conf.get(Property.GENERAL_RPC_SERVER_TYPE);
        return ThriftServerType.get(serverTypeName);
    }

    public AuthenticationTokenSecretManager getSecretManager() {
        return this.secretManager.get();
    }

    public TableManager getTableManager() {
        return this.tableManager.get();
    }

    public UniqueNameAllocator getUniqueNameAllocator() {
        return this.nameAllocator.get();
    }

    public CryptoServiceFactory getCryptoFactory() {
        return this.cryptoFactorySupplier.get();
    }

    public Ample getAmple() {
        return new ServerAmpleImpl(this);
    }

    public Set<String> getBaseUris() {
        return this.serverDirs.getBaseUris();
    }

    public List<Pair<Path, Path>> getVolumeReplacements() {
        return this.serverDirs.getVolumeReplacements();
    }

    public Set<String> getTablesDirs() {
        return this.serverDirs.getTablesDirs();
    }

    public Set<String> getRecoveryDirs() {
        return this.serverDirs.getRecoveryDirs();
    }

    public static void ensureDataVersionCompatible(int dataVersion) {
        if (!AccumuloDataVersion.CAN_RUN.contains(dataVersion)) {
            throw new IllegalStateException("This version of accumulo (2.1.1) is not compatible with files stored using data version " + dataVersion);
        }
    }

    public void waitForZookeeperAndHdfs() {
        log.info("Attempting to talk to zookeeper");
        while (true) {
            try {
                this.getZooReaderWriter().getChildren("/accumulo");
            }
            catch (InterruptedException | KeeperException ex) {
                log.info("Waiting for accumulo to be initialized");
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            break;
        }
        log.info("ZooKeeper connected and initialized, attempting to talk to HDFS");
        long sleep = 1000L;
        int unknownHostTries = 3;
        while (true) {
            try {
                if (this.getVolumeManager().isReady()) break;
                log.warn("Waiting for the NameNode to leave safemode");
            }
            catch (IOException ex) {
                log.warn("Unable to connect to HDFS", (Throwable)ex);
            }
            catch (IllegalArgumentException e) {
                if (e.getCause() instanceof UnknownHostException) {
                    if (unknownHostTries <= 0) {
                        log.error("Unable to connect to HDFS and exceeded the maximum number of retries.", (Throwable)e);
                        throw e;
                    }
                    log.warn("Unable to connect to HDFS, will retry. cause: ", e.getCause());
                    int ttl = AddressUtil.getAddressCacheNegativeTtl((UnknownHostException)((UnknownHostException)e.getCause()));
                    sleep = Math.max(sleep, (long)(ttl + 1) * 1000L);
                    --unknownHostTries;
                }
                throw e;
            }
            log.info("Backing off due to failure; current sleep period is {} seconds", (Object)((double)sleep / 1000.0));
            UtilWaitThread.sleepUninterruptibly((long)sleep, (TimeUnit)TimeUnit.MILLISECONDS);
            sleep = Math.min(TimeUnit.MINUTES.toMillis(1L), sleep * 2L);
        }
        log.info("Connected to HDFS");
    }

    public void init(String application) {
        AccumuloConfiguration conf = this.getConfiguration();
        log.info("{} starting", (Object)application);
        log.info("Instance {}", (Object)this.getInstanceID());
        int dataVersion = this.serverDirs.getAccumuloPersistentVersion(this.getVolumeManager().getFirst());
        log.info("Data Version {}", (Object)dataVersion);
        this.waitForZookeeperAndHdfs();
        ServerContext.ensureDataVersionCompatible(dataVersion);
        TreeMap<String, String> sortedProps = new TreeMap<String, String>();
        for (Map.Entry entry : conf) {
            sortedProps.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : sortedProps.entrySet()) {
            String key;
            log.info("{} = {}", (Object)key, (Object)(Property.isSensitive((String)(key = (String)entry.getKey())) ? "<hidden>" : entry.getValue()));
            Property prop = Property.getPropertyByKey((String)key);
            if (prop == null || !conf.isPropertySet(prop) || !prop.isDeprecated()) continue;
            Property replacedBy = prop.replacedBy();
            if (replacedBy != null) {
                log.warn("{} is deprecated, use {} instead.", (Object)prop.getKey(), (Object)replacedBy.getKey());
                continue;
            }
            log.warn("{} is deprecated", (Object)prop.getKey());
        }
        this.monitorSwappiness();
        String SSL = "SSL";
        for (Property sslProtocolProperty : Arrays.asList(Property.RPC_SSL_CLIENT_PROTOCOL, Property.RPC_SSL_ENABLED_PROTOCOLS, Property.MONITOR_SSL_INCLUDE_PROTOCOLS)) {
            String value = conf.get(sslProtocolProperty);
            if (!value.contains("SSL")) continue;
            log.warn("It is recommended that {} only allow TLS", (Object)sslProtocolProperty);
        }
    }

    private void monitorSwappiness() {
        ScheduledFuture<?> future = this.getScheduledExecutor().scheduleWithFixedDelay(() -> {
            block8: {
                try {
                    String procFile = "/proc/sys/vm/swappiness";
                    File swappiness = new File(procFile);
                    if (!swappiness.exists() || !swappiness.canRead()) break block8;
                    try (FileInputStream is = new FileInputStream(procFile);){
                        byte[] buffer = new byte[10];
                        int bytes = ((InputStream)is).read(buffer);
                        String setting = new String(buffer, 0, bytes, StandardCharsets.UTF_8);
                        setting = setting.trim();
                        if (bytes > 0 && Integer.parseInt(setting) > 10) {
                            log.warn("System swappiness setting is greater than ten ({}) which can cause time-sensitive operations to be delayed. Accumulo is time sensitive because it needs to maintain distributed lock agreement.", (Object)setting);
                        }
                    }
                }
                catch (Exception t) {
                    log.error("", (Throwable)t);
                }
            }
        }, TimeUnit.SECONDS.toMillis(1L), TimeUnit.MINUTES.toMillis(10L), TimeUnit.MILLISECONDS);
        ThreadPools.watchNonCriticalScheduledTask(future);
    }

    public ScheduledThreadPoolExecutor getScheduledExecutor() {
        return this.sharedScheduledThreadPool.get();
    }

    public PropStore getPropStore() {
        return this.propStore.get();
    }

    protected long getTransportPoolMaxAgeMillis() {
        return this.getClientTimeoutInMillis();
    }

    public AuditedSecurityOperation getSecurityOperation() {
        return this.securityOperation.get();
    }
}

