/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.gc;

import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.gc.ReferenceFile;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;

public class AllVolumesDirectory
extends ReferenceFile {
    public AllVolumesDirectory(TableId tableId, String dirName) {
        super(tableId, AllVolumesDirectory.getDeleteTabletOnAllVolumesUri(tableId, dirName));
    }

    private static String getDeleteTabletOnAllVolumesUri(TableId tableId, String dirName) {
        MetadataSchema.TabletsSection.ServerColumnFamily.validateDirCol((String)dirName);
        return "agcav:/tables/" + tableId + "/" + dirName;
    }

    public String getMetadataEntry() {
        return this.metadataEntry;
    }

    public boolean isDirectory() {
        return true;
    }
}

