/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.manager.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletLocationState;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.server.manager.state.Assignment;
import org.apache.accumulo.server.manager.state.ClosableIterator;
import org.apache.accumulo.server.manager.state.DistributedStoreException;
import org.apache.accumulo.server.manager.state.TabletStateStore;
import org.apache.accumulo.server.util.ManagerMetadataUtil;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZooTabletStateStore
implements TabletStateStore {
    private static final Logger log = LoggerFactory.getLogger(ZooTabletStateStore.class);
    private final Ample ample;
    private final ClientContext context;

    ZooTabletStateStore(ClientContext context) {
        this.context = context;
        this.ample = context.getAmple();
    }

    @Override
    public ClosableIterator<TabletLocationState> iterator() {
        return new ClosableIterator<TabletLocationState>(){
            boolean finished = false;

            @Override
            public boolean hasNext() {
                return !this.finished;
            }

            @Override
            public TabletLocationState next() {
                this.finished = true;
                try {
                    TabletMetadata rootMeta = ZooTabletStateStore.this.ample.readTablet(RootTable.EXTENT, Ample.ReadConsistency.EVENTUAL, new TabletMetadata.ColumnType[0]);
                    TabletMetadata.Location currentSession = null;
                    TabletMetadata.Location futureSession = null;
                    TabletMetadata.Location lastSession = null;
                    TabletMetadata.Location loc = rootMeta.getLocation();
                    if (loc != null && loc.getType() == TabletMetadata.LocationType.FUTURE) {
                        futureSession = loc;
                    }
                    if (rootMeta.getLast() != null) {
                        lastSession = rootMeta.getLast();
                    }
                    if (loc != null && loc.getType() == TabletMetadata.LocationType.CURRENT) {
                        currentSession = loc;
                    }
                    ArrayList logs = new ArrayList();
                    rootMeta.getLogs().forEach(logEntry -> {
                        logs.add(Collections.singleton(logEntry.filename));
                        log.debug("root tablet log {}", (Object)logEntry.filename);
                    });
                    return new TabletLocationState(RootTable.EXTENT, futureSession, currentSession, lastSession, null, logs, false);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public void setFutureLocations(Collection<Assignment> assignments) throws DistributedStoreException {
        if (assignments.size() != 1) {
            throw new IllegalArgumentException("There is only one root tablet");
        }
        Assignment assignment = assignments.iterator().next();
        if (assignment.tablet.compareTo(RootTable.EXTENT) != 0) {
            throw new IllegalArgumentException("You can only store the root tablet location");
        }
        Ample.TabletMutator tabletMutator = this.ample.mutateTablet(assignment.tablet);
        tabletMutator.putLocation(TabletMetadata.Location.future((TServerInstance)assignment.server));
        tabletMutator.mutate();
    }

    @Override
    public void setLocations(Collection<Assignment> assignments) throws DistributedStoreException {
        if (assignments.size() != 1) {
            throw new IllegalArgumentException("There is only one root tablet");
        }
        Assignment assignment = assignments.iterator().next();
        if (assignment.tablet.compareTo(RootTable.EXTENT) != 0) {
            throw new IllegalArgumentException("You can only store the root tablet location");
        }
        Ample.TabletMutator tabletMutator = this.ample.mutateTablet(assignment.tablet);
        tabletMutator.putLocation(TabletMetadata.Location.current((TServerInstance)assignment.server));
        ManagerMetadataUtil.updateLastForAssignmentMode(this.context, tabletMutator, assignment.server, assignment.lastLocation);
        tabletMutator.deleteLocation(TabletMetadata.Location.future((TServerInstance)assignment.server));
        tabletMutator.mutate();
    }

    @Override
    public void unassign(Collection<TabletLocationState> tablets, Map<TServerInstance, List<Path>> logsForDeadServers) throws DistributedStoreException {
        List<Path> logs;
        if (tablets.size() != 1) {
            throw new IllegalArgumentException("There is only one root tablet");
        }
        TabletLocationState tls = tablets.iterator().next();
        if (tls.extent.compareTo(RootTable.EXTENT) != 0) {
            throw new IllegalArgumentException("You can only store the root tablet location");
        }
        Ample.TabletMutator tabletMutator = this.ample.mutateTablet(tls.extent);
        TServerInstance futureOrCurrent = tls.futureOrCurrent().getServerInstance();
        tabletMutator.deleteLocation(TabletMetadata.Location.future((TServerInstance)futureOrCurrent));
        tabletMutator.deleteLocation(TabletMetadata.Location.current((TServerInstance)futureOrCurrent));
        ManagerMetadataUtil.updateLastForAssignmentMode(this.context, tabletMutator, futureOrCurrent, tls.last);
        if (logsForDeadServers != null && (logs = logsForDeadServers.get(futureOrCurrent)) != null) {
            for (Path entry : logs) {
                LogEntry logEntry = new LogEntry(RootTable.EXTENT, System.currentTimeMillis(), entry.toString());
                tabletMutator.putWal(logEntry);
            }
        }
        tabletMutator.mutate();
        log.debug("unassign root tablet location");
    }

    @Override
    public void suspend(Collection<TabletLocationState> tablets, Map<TServerInstance, List<Path>> logsForDeadServers, long suspensionTimestamp) throws DistributedStoreException {
        this.unassign(tablets, logsForDeadServers);
    }

    @Override
    public void unsuspend(Collection<TabletLocationState> tablets) {
    }

    @Override
    public String name() {
        return "Root Table";
    }
}

