/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.NumUtil;
import org.apache.accumulo.server.cli.ServerUtilOpts;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDiskUsage {
    private static final Logger log = LoggerFactory.getLogger(TableDiskUsage.class);
    private int nextInternalId = 0;
    private Map<TableId, Integer> internalIds = new HashMap<TableId, Integer>();
    private Map<Integer, TableId> externalIds = new HashMap<Integer, TableId>();
    private Map<String, Integer[]> tableFiles = new HashMap<String, Integer[]>();
    private Map<String, Long> fileSizes = new HashMap<String, Long>();

    void addTable(TableId tableId) {
        if (this.internalIds.containsKey(tableId)) {
            throw new IllegalArgumentException("Already added table " + tableId);
        }
        int iid = this.nextInternalId++;
        this.internalIds.put(tableId, iid);
        this.externalIds.put(iid, tableId);
    }

    void linkFileAndTable(TableId tableId, String file) {
        int internalId = this.internalIds.get(tableId);
        Integer[] tables = this.tableFiles.get(file);
        if (tables == null) {
            tables = new Integer[this.internalIds.size()];
            for (int i = 0; i < tables.length; ++i) {
                tables[i] = 0;
            }
            this.tableFiles.put(file, tables);
        }
        tables[internalId] = 1;
    }

    void addFileSize(String file, long size) {
        this.fileSizes.put(file, size);
    }

    Map<List<TableId>, Long> calculateUsage() {
        HashMap<List<Integer>, Long> usage = new HashMap<List<Integer>, Long>();
        if (log.isTraceEnabled()) {
            log.trace("fileSizes {}", this.fileSizes);
        }
        for (Map.Entry<String, Integer[]> entry : this.tableFiles.entrySet()) {
            if (log.isTraceEnabled()) {
                log.trace("file {} table bitset {}", (Object)entry.getKey(), (Object)Arrays.toString((Object[])entry.getValue()));
            }
            List<Integer> key = Arrays.asList(entry.getValue());
            Long size = this.fileSizes.get(entry.getKey());
            Long tablesUsage = (Long)usage.get(key);
            if (tablesUsage == null) {
                tablesUsage = 0L;
            }
            tablesUsage = tablesUsage + size;
            usage.put(key, tablesUsage);
        }
        HashMap<List<TableId>, Long> externalUsage = new HashMap<List<TableId>, Long>();
        for (Map.Entry entry : usage.entrySet()) {
            ArrayList<TableId> externalKey = new ArrayList<TableId>();
            List key = (List)entry.getKey();
            for (int i = 0; i < key.size(); ++i) {
                if ((Integer)key.get(i) == 0) continue;
                externalKey.add(this.externalIds.get(i));
            }
            externalUsage.put(externalKey, (Long)entry.getValue());
        }
        return externalUsage;
    }

    public static void printDiskUsage(Collection<String> tableNames, AccumuloClient client, boolean humanReadable) throws TableNotFoundException, IOException {
        TableDiskUsage.printDiskUsage(tableNames, client, System.out::println, humanReadable);
    }

    public static Map<SortedSet<String>, Long> getDiskUsage(Set<TableId> tableIds, AccumuloClient client) throws TableNotFoundException {
        TableDiskUsage tdu = new TableDiskUsage();
        for (TableId tableId : tableIds) {
            tdu.addTable(tableId);
        }
        HashSet<TableId> emptyTableIds = new HashSet<TableId>();
        for (TableId tableId : tableIds) {
            Scanner mdScanner = tableId.equals((Object)MetadataTable.ID) ? client.createScanner(RootTable.NAME, Authorizations.EMPTY) : client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
            try {
                mdScanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                mdScanner.setRange(new KeyExtent(tableId, null, null).toMetaRange());
                HashSet<TabletFile> files = new HashSet<TabletFile>();
                for (Map.Entry entry : mdScanner) {
                    TabletFile file = new TabletFile(new Path(((Key)entry.getKey()).getColumnQualifier().toString()));
                    TableId fileTableRef = file.getTableId();
                    if (!fileTableRef.equals((Object)tableId) && tableIds.contains(fileTableRef)) {
                        tdu.linkFileAndTable(fileTableRef, file.getFileName());
                    }
                    tdu.linkFileAndTable(tableId, file.getFileName());
                    if (!files.add(file)) continue;
                    tdu.addFileSize(file.getFileName(), new DataFileValue(((Value)entry.getValue()).get()).getSize());
                }
                if (!files.isEmpty()) continue;
                emptyTableIds.add(tableId);
            }
            finally {
                if (mdScanner == null) continue;
                mdScanner.close();
            }
        }
        return TableDiskUsage.buildSharedUsageMap(tdu, (ClientContext)client, emptyTableIds);
    }

    protected static Map<SortedSet<String>, Long> buildSharedUsageMap(TableDiskUsage tdu, ClientContext clientContext, Set<TableId> emptyTableIds) {
        Map reverseTableIdMap = clientContext.getTableIdToNameMap();
        TreeMap<SortedSet<String>, Long> usage = new TreeMap<SortedSet<String>, Long>((o1, o2) -> {
            int len1 = o1.size();
            int len2 = o2.size();
            int min = Math.min(len1, len2);
            Iterator iter1 = o1.iterator();
            Iterator iter2 = o2.iterator();
            for (int count = 0; count < min; ++count) {
                String s2;
                String s1 = (String)iter1.next();
                int cmp = s1.compareTo(s2 = (String)iter2.next());
                if (cmp == 0) continue;
                return cmp;
            }
            return len1 - len2;
        });
        for (Map.Entry<List<TableId>, Long> entry : tdu.calculateUsage().entrySet()) {
            TreeSet<String> tableNames = new TreeSet<String>();
            for (TableId tableId : entry.getKey()) {
                tableNames.add((String)reverseTableIdMap.get(tableId));
            }
            usage.put(tableNames, entry.getValue());
        }
        if (!emptyTableIds.isEmpty()) {
            TreeSet<String> emptyTables = new TreeSet<String>();
            for (TableId tableId : emptyTableIds) {
                emptyTables.add((String)reverseTableIdMap.get(tableId));
            }
            usage.put(emptyTables, 0L);
        }
        return usage;
    }

    public static void printDiskUsage(Collection<String> tableNames, AccumuloClient client, Printer printer, boolean humanReadable) throws TableNotFoundException, IOException {
        HashSet<TableId> tableIds = new HashSet<TableId>();
        for (String tableName : tableNames) {
            TableId tableId = ((ClientContext)client).getTableId(tableName);
            if (tableId == null) {
                throw new TableNotFoundException(null, tableName, "Table " + tableName + " not found");
            }
            tableIds.add(tableId);
        }
        Map<SortedSet<String>, Long> usage = TableDiskUsage.getDiskUsage(tableIds, client);
        String valueFormat = humanReadable ? "%9s" : "%,24d";
        for (Map.Entry<SortedSet<String>, Long> entry : usage.entrySet()) {
            Long value = humanReadable ? NumUtil.bigNumberForSize((long)entry.getValue()) : entry.getValue();
            printer.print(String.format(valueFormat + " %s", value, entry.getKey()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(TableDiskUsage.class.getName(), args, new Object[0]);
        Span span = TraceUtil.startSpan(TableDiskUsage.class, (String)"main");
        try (Scope scope = span.makeCurrent();){
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(opts.getClientProps()).build();){
                TableDiskUsage.printDiskUsage(opts.tables, client, false);
            }
            finally {
                span.end();
            }
        }
    }

    static class Opts
    extends ServerUtilOpts {
        @Parameter(description=" <table> { <table> ... } ")
        List<String> tables = new ArrayList<String>();

        Opts() {
        }
    }

    public static interface Printer {
        public void print(String var1);
    }
}

