/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.InitialMultiScan;
import org.apache.accumulo.core.dataImpl.thrift.MultiScanResult;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TRange;
import org.apache.accumulo.core.metadata.MetadataServicer;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.tabletserver.thrift.TabletScanClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyTabletAssignments {
    private static final Logger log = LoggerFactory.getLogger(VerifyTabletAssignments.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Properties clientProps, boolean verbose) throws Exception {
        Span span = TraceUtil.startSpan(VerifyTabletAssignments.class, (String)"main");
        try (Scope scope = span.makeCurrent();){
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(clientProps).build();){
                for (String table : client.tableOperations().list()) {
                    VerifyTabletAssignments.checkTable((ClientContext)client, verbose, table, null);
                }
            }
            finally {
                span.end();
            }
        }
    }

    private static void checkTable(ClientContext context, boolean verbose, String tableName, HashSet<KeyExtent> check) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, InterruptedException {
        if (check == null) {
            System.out.println("Checking table " + tableName);
        } else {
            System.out.println("Checking table " + tableName + " again, failures " + check.size());
        }
        TreeMap tabletLocations = new TreeMap();
        TableId tableId = (TableId)context.getTableNameToIdMap().get(tableName);
        MetadataServicer.forTableId((ClientContext)context, (TableId)tableId).getTabletLocations(tabletLocations);
        HashSet<KeyExtent> failures = new HashSet<KeyExtent>();
        TreeMap<HostAndPort, List> extentsPerServer = new TreeMap<HostAndPort, List>();
        for (Map.Entry entry : tabletLocations.entrySet()) {
            KeyExtent keyExtent = (KeyExtent)entry.getKey();
            String loc = (String)entry.getValue();
            if (loc == null) {
                System.out.println(" Tablet " + keyExtent + " has no location");
            } else if (verbose) {
                System.out.println(" Tablet " + keyExtent + " is located at " + loc);
            }
            if (loc == null) continue;
            HostAndPort parsedLoc = HostAndPort.fromString((String)loc);
            List extentList = extentsPerServer.computeIfAbsent(parsedLoc, k -> new ArrayList());
            if (check != null && !check.contains(keyExtent)) continue;
            extentList.add(keyExtent);
        }
        ThreadPoolExecutor tp = ThreadPools.getServerThreadPools().createFixedThreadPool(20, "CheckTabletServer", false);
        for (Map.Entry entry : extentsPerServer.entrySet()) {
            Runnable r = () -> {
                try {
                    VerifyTabletAssignments.checkTabletServer(context, entry, failures);
                }
                catch (Exception e) {
                    log.error("Failure on tablet server '" + entry.getKey() + ".", (Throwable)e);
                    failures.addAll((Collection)entry.getValue());
                }
            };
            tp.execute(r);
        }
        tp.shutdown();
        while (!tp.awaitTermination(1L, TimeUnit.HOURS)) {
        }
        if (!failures.isEmpty()) {
            VerifyTabletAssignments.checkTable(context, verbose, tableName, failures);
        }
    }

    private static void checkFailures(HostAndPort server, HashSet<KeyExtent> failures, MultiScanResult scanResult) {
        for (TKeyExtent tke : scanResult.failures.keySet()) {
            KeyExtent ke = KeyExtent.fromThrift((TKeyExtent)tke);
            System.out.println(" Tablet " + ke + " failed at " + server);
            failures.add(ke);
        }
    }

    private static void checkTabletServer(ClientContext context, Map.Entry<HostAndPort, List<KeyExtent>> entry, HashSet<KeyExtent> failures) throws TException {
        TabletScanClientService.Iface client = (TabletScanClientService.Iface)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SCAN, (HostAndPort)entry.getKey(), (ClientContext)context);
        TreeMap<TKeyExtent, List<TRange>> batch = new TreeMap<TKeyExtent, List<TRange>>();
        for (KeyExtent keyExtent : entry.getValue()) {
            Text row = keyExtent.endRow();
            Text row2 = null;
            if (row == null) {
                row = keyExtent.prevEndRow();
                if (row != null) {
                    row = new Text(row);
                    row.append(new byte[]{97}, 0, 1);
                } else {
                    row = new Text("1234567890");
                }
                row2 = new Text(row);
                row2.append(new byte[]{33}, 0, 1);
            } else {
                row = new Text(row);
                row2 = new Text(row);
                row.getBytes()[row.getLength() - 1] = (byte)(row.getBytes()[row.getLength() - 1] - 1);
            }
            Range r = new Range(row, true, row2, false);
            batch.put(keyExtent.toThrift(), Collections.singletonList(r.toThrift()));
        }
        TInfo tinfo = TraceUtil.traceInfo();
        Map emptyMapSMapSS = Collections.emptyMap();
        List emptyListIterInfo = Collections.emptyList();
        List emptyListColumn = Collections.emptyList();
        InitialMultiScan is = client.startMultiScan(tinfo, context.rpcCreds(), batch, emptyListColumn, emptyListIterInfo, emptyMapSMapSS, Authorizations.EMPTY.getAuthorizationsBB(), false, null, 0L, null, null, 0L);
        if (is.result.more) {
            MultiScanResult result = client.continueMultiScan(tinfo, is.scanID, 0L);
            VerifyTabletAssignments.checkFailures(entry.getKey(), failures, result);
            while (result.more) {
                result = client.continueMultiScan(tinfo, is.scanID, 0L);
                VerifyTabletAssignments.checkFailures(entry.getKey(), failures, result);
            }
        }
        client.closeMultiScan(tinfo, is.scanID);
        ThriftUtil.returnClient((TServiceClient)((TServiceClient)client), (ClientContext)context);
    }
}

