/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.volume.Volume;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class ServerDirs {
    private Set<String> baseUris;
    private Set<String> tablesDirs;
    private Set<String> recoveryDirs;
    private final List<Pair<Path, Path>> replacementsList;
    private final AccumuloConfiguration conf;
    private final Configuration hadoopConf;

    public ServerDirs(AccumuloConfiguration conf, Configuration hadoopConf) {
        this.conf = Objects.requireNonNull(conf, "Configuration cannot be null");
        this.hadoopConf = Objects.requireNonNull(hadoopConf, "Hadoop configuration cannot be null");
        this.replacementsList = this.loadVolumeReplacements();
    }

    public Set<String> getBaseUris() {
        if (this.baseUris == null) {
            this.baseUris = Collections.unmodifiableSet(this.checkBaseUris(this.hadoopConf, VolumeConfiguration.getVolumeUris((AccumuloConfiguration)this.conf), false));
        }
        return this.baseUris;
    }

    public Set<String> checkBaseUris(Configuration hadoopConf, Set<String> configuredBaseDirs, boolean ignore) {
        String firstDir = null;
        InstanceId firstIid = null;
        Integer firstVersion = null;
        LinkedHashSet<String> baseDirsList = new LinkedHashSet<String>();
        for (String baseDir : configuredBaseDirs) {
            int currentVersion;
            InstanceId currentIid;
            Path path = new Path(baseDir, "instance_id");
            try {
                currentIid = VolumeManager.getInstanceIDFromHdfs(path, hadoopConf);
                Path vpath = new Path(baseDir, "version");
                currentVersion = this.getAccumuloPersistentVersion(vpath.getFileSystem(hadoopConf), vpath);
            }
            catch (Exception e) {
                if (ignore) continue;
                throw new IllegalArgumentException("Accumulo volume " + path + " not initialized", e);
            }
            if (firstIid == null) {
                firstIid = currentIid;
                firstDir = baseDir;
                firstVersion = currentVersion;
            } else {
                if (!currentIid.equals((Object)firstIid)) {
                    throw new IllegalArgumentException("Configuration " + Property.INSTANCE_VOLUMES.getKey() + " contains paths that have different instance ids " + baseDir + " has " + currentIid + " and " + firstDir + " has " + firstIid);
                }
                if (currentVersion != firstVersion) {
                    throw new IllegalArgumentException("Configuration " + Property.INSTANCE_VOLUMES.getKey() + " contains paths that have different versions " + baseDir + " has " + currentVersion + " and " + firstDir + " has " + firstVersion);
                }
            }
            baseDirsList.add(baseDir);
        }
        if (baseDirsList.isEmpty()) {
            throw new RuntimeException("None of the configured paths are initialized.");
        }
        return baseDirsList;
    }

    private Set<String> prefix(Set<String> bases, String suffix) {
        String actualSuffix = suffix.startsWith("/") ? suffix.substring(1) : suffix;
        return bases.stream().map(base -> base + (base.endsWith("/") ? "" : "/") + actualSuffix).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<String> getTablesDirs() {
        if (this.tablesDirs == null) {
            this.tablesDirs = this.prefix(this.getBaseUris(), "tables");
        }
        return this.tablesDirs;
    }

    public Set<String> getRecoveryDirs() {
        if (this.recoveryDirs == null) {
            this.recoveryDirs = this.prefix(this.getBaseUris(), "recovery");
        }
        return this.recoveryDirs;
    }

    /*
     * WARNING - void declaration
     */
    private List<Pair<Path, Path>> loadVolumeReplacements() {
        void var7_8;
        String replacements = this.conf.get(Property.INSTANCE_VOLUMES_REPLACEMENTS);
        if (replacements == null || replacements.trim().isEmpty()) {
            return Collections.emptyList();
        }
        replacements = replacements.trim();
        String[] pairs = replacements.split(",");
        ArrayList<Pair<Path, Path>> ret = new ArrayList<Pair<Path, Path>>();
        String[] stringArray = pairs;
        int n = stringArray.length;
        boolean bl = false;
        while (var7_8 < n) {
            Path p2;
            Path p1;
            String pair = stringArray[var7_8];
            String[] uris = pair.split("\\s+");
            if (uris.length != 2) {
                throw new IllegalArgumentException(Property.INSTANCE_VOLUMES_REPLACEMENTS.getKey() + " contains malformed pair " + pair);
            }
            try {
                p1 = new Path(new URI(VolumeUtil.removeTrailingSlash(uris[0].trim())));
                if (p1.toUri().getScheme() == null) {
                    throw new IllegalArgumentException(Property.INSTANCE_VOLUMES_REPLACEMENTS.getKey() + " contains " + uris[0] + " which is not fully qualified");
                }
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(Property.INSTANCE_VOLUMES_REPLACEMENTS.getKey() + " contains " + uris[0] + " which has a syntax error", e);
            }
            try {
                p2 = new Path(new URI(VolumeUtil.removeTrailingSlash(uris[1].trim())));
                if (p2.toUri().getScheme() == null) {
                    throw new IllegalArgumentException(Property.INSTANCE_VOLUMES_REPLACEMENTS.getKey() + " contains " + uris[1] + " which is not fully qualified");
                }
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(Property.INSTANCE_VOLUMES_REPLACEMENTS.getKey() + " contains " + uris[1] + " which has a syntax error", e);
            }
            ret.add((Pair<Path, Path>)new Pair((Object)p1, (Object)p2));
            ++var7_8;
        }
        HashSet<Path> baseDirs = new HashSet<Path>();
        for (String string : this.getBaseUris()) {
            baseDirs.add(new Path(string));
        }
        for (Pair pair : ret) {
            if (baseDirs.contains(pair.getSecond())) continue;
            throw new IllegalArgumentException(Property.INSTANCE_VOLUMES_REPLACEMENTS.getKey() + " contains " + pair.getSecond() + " which is not a configured volume");
        }
        ArrayList<Pair<Path, Path>> replacementsList = ret;
        return replacementsList;
    }

    public List<Pair<Path, Path>> getVolumeReplacements() {
        return this.replacementsList;
    }

    public Path getDataVersionLocation(Volume v) {
        return v.prefixChild("version");
    }

    public int getAccumuloPersistentVersion(Volume v) {
        Path path = this.getDataVersionLocation(v);
        return this.getAccumuloPersistentVersion(v.getFileSystem(), path);
    }

    public int getAccumuloPersistentVersion(FileSystem fs, Path path) {
        try {
            FileStatus[] files = fs.listStatus(path);
            int dataVersion = files == null || files.length == 0 ? -1 : Integer.parseInt(files[0].getPath().getName());
            return dataVersion;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read accumulo version: an error occurred.", e);
        }
    }

    public Path getInstanceIdLocation(Volume v) {
        return v.prefixChild("instance_id");
    }
}

