/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf.store.impl;

import com.github.benmanes.caffeine.cache.CacheLoader;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.server.conf.codec.VersionedPropCodec;
import org.apache.accumulo.server.conf.codec.VersionedProperties;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.apache.accumulo.server.conf.store.impl.PropStoreMetrics;
import org.apache.accumulo.server.conf.store.impl.PropStoreWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooPropLoader
implements CacheLoader<PropStoreKey<?>, VersionedProperties> {
    private static final Logger log = LoggerFactory.getLogger(ZooPropLoader.class);
    private final ZooReaderWriter zrw;
    private final VersionedPropCodec propCodec;
    private final PropStoreWatcher propStoreWatcher;
    private final PropStoreMetrics metrics;

    public ZooPropLoader(ZooReaderWriter zrw, VersionedPropCodec propCodec, PropStoreWatcher propStoreWatcher, PropStoreMetrics metrics) {
        this.zrw = zrw;
        this.propCodec = propCodec;
        this.propStoreWatcher = propStoreWatcher;
        this.metrics = metrics;
    }

    public @Nullable VersionedProperties load(PropStoreKey<?> propStoreKey) {
        try {
            log.trace("load called for {}", propStoreKey);
            long startNanos = System.nanoTime();
            Stat stat = new Stat();
            byte[] bytes = this.zrw.getData(propStoreKey.getPath(), (Watcher)this.propStoreWatcher, stat);
            if (stat.getDataLength() == 0) {
                return new VersionedProperties();
            }
            VersionedProperties vProps = this.propCodec.fromBytes(stat.getVersion(), bytes);
            this.metrics.addLoadTime(TimeUnit.MILLISECONDS.convert(System.nanoTime() - startNanos, TimeUnit.NANOSECONDS));
            return vProps;
        }
        catch (KeeperException.NoNodeException ex) {
            this.metrics.incrZkError();
            log.debug("property node for {} does not exist - it may be being created", propStoreKey);
            this.propStoreWatcher.signalZkChangeEvent(propStoreKey);
            return null;
        }
        catch (Exception ex) {
            this.metrics.incrZkError();
            log.info("Failed to load properties for: {} from ZooKeeper, returning null", propStoreKey, (Object)ex);
            this.propStoreWatcher.signalZkChangeEvent(propStoreKey);
            return null;
        }
    }

    public CompletableFuture<? extends VersionedProperties> asyncLoad(PropStoreKey<?> propStoreKey, Executor executor) throws Exception {
        log.trace("asyncLoad called for key: {}", propStoreKey);
        return super.asyncLoad(propStoreKey, executor);
    }

    public CompletableFuture<VersionedProperties> asyncReload(PropStoreKey<?> propStoreKey, VersionedProperties oldValue, Executor executor) throws Exception {
        log.trace("asyncReload called for key: {}", propStoreKey);
        this.metrics.incrRefresh();
        return CompletableFuture.supplyAsync(() -> this.loadIfDifferentVersion(propStoreKey, oldValue), executor);
    }

    public @Nullable VersionedProperties reload(PropStoreKey<?> propStoreKey, VersionedProperties oldValue) throws Exception {
        log.trace("reload called for: {}", propStoreKey);
        this.metrics.incrRefresh();
        return this.loadIfDifferentVersion(propStoreKey, oldValue);
    }

    private @Nullable VersionedProperties loadIfDifferentVersion(PropStoreKey<?> propCacheId, VersionedProperties currentValue) {
        Objects.requireNonNull(propCacheId, "propCacheId cannot be null");
        try {
            Stat stat = this.zrw.getStatus(propCacheId.getPath());
            log.trace("Check stat version on reload. Zk: {}, Cache: {}", (Object)stat.getVersion(), (Object)currentValue.getDataVersion());
            if ((long)stat.getVersion() == currentValue.getDataVersion()) {
                return currentValue;
            }
            log.trace("different version in cache for {}, calling loader to get update from ZooKeeper", propCacheId);
            VersionedProperties updatedValue = this.load(propCacheId);
            this.metrics.incrRefreshLoad();
            this.propStoreWatcher.signalCacheChangeEvent(propCacheId);
            log.trace("Updated value {}", (Object)(updatedValue == null ? "null" : updatedValue.print(true)));
            return updatedValue;
        }
        catch (InterruptedException | RuntimeException | KeeperException ex) {
            log.warn("async exception occurred reading properties from ZooKeeper for: {} returning null", propCacheId, (Object)ex);
            this.metrics.incrZkError();
            this.propStoreWatcher.signalZkChangeEvent(propCacheId);
            return null;
        }
    }
}

