/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.fs;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.spi.fs.VolumeChooser;
import org.apache.accumulo.core.spi.fs.VolumeChooserEnvironment;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.core.volume.Volume;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.accumulo.core.volume.VolumeImpl;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeManagerImpl
implements VolumeManager {
    private static final Logger log = LoggerFactory.getLogger(VolumeManagerImpl.class);
    private static final HashSet<String> WARNED_ABOUT_SYNCONCLOSE = new HashSet();
    private final Map<String, Volume> volumesByName;
    private final Multimap<URI, Volume> volumesByFileSystemUri;
    private final VolumeChooser chooser;
    private final AccumuloConfiguration conf;
    private final Configuration hadoopConf;

    protected VolumeManagerImpl(Map<String, Volume> volumes, AccumuloConfiguration conf, Configuration hadoopConf) {
        VolumeChooser chooser1;
        this.volumesByName = volumes;
        this.volumesByFileSystemUri = this.invertVolumesByFileSystem(this.volumesByName);
        this.ensureSyncIsEnabled();
        try {
            chooser1 = (VolumeChooser)Property.createInstanceFromPropertyName((AccumuloConfiguration)conf, (Property)Property.GENERAL_VOLUME_CHOOSER, VolumeChooser.class, null);
        }
        catch (NullPointerException npe) {
            chooser1 = null;
        }
        if (chooser1 == null) {
            throw new RuntimeException("Failed to load volume chooser specified by " + Property.GENERAL_VOLUME_CHOOSER);
        }
        this.chooser = chooser1;
        this.conf = conf;
        this.hadoopConf = hadoopConf;
    }

    private Multimap<URI, Volume> invertVolumesByFileSystem(Map<String, Volume> forward) {
        HashMultimap inverted = HashMultimap.create();
        forward.values().forEach(arg_0 -> VolumeManagerImpl.lambda$invertVolumesByFileSystem$0((Multimap)inverted, arg_0));
        return inverted;
    }

    public static VolumeManager getLocalForTesting(String localBasePath) throws IOException {
        DefaultConfiguration accConf = DefaultConfiguration.getInstance();
        Configuration hadoopConf = new Configuration();
        LocalFileSystem localFS = FileSystem.getLocal((Configuration)hadoopConf);
        VolumeImpl defaultLocalVolume = new VolumeImpl((FileSystem)localFS, localBasePath);
        return new VolumeManagerImpl(Collections.singletonMap("", defaultLocalVolume), (AccumuloConfiguration)accConf, hadoopConf);
    }

    @Override
    public void close() throws IOException {
        IOException ex = null;
        for (Volume volume : this.volumesByName.values()) {
            try {
                volume.getFileSystem().close();
            }
            catch (IOException e) {
                if (ex == null) {
                    ex = e;
                    continue;
                }
                ex.addSuppressed(e);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    @Override
    public FSDataOutputStream create(Path path) throws IOException {
        return this.getFileSystemByPath(path).create(path);
    }

    @Override
    public FSDataOutputStream overwrite(Path path) throws IOException {
        return this.getFileSystemByPath(path).create(path, true);
    }

    private static long correctBlockSize(Configuration conf, long blockSize) {
        if (blockSize <= 0L) {
            blockSize = conf.getLong("dfs.block.size", 0x4000000L);
        }
        int checkSum = conf.getInt("io.bytes.per.checksum", 512);
        blockSize -= blockSize % (long)checkSum;
        return Math.max(blockSize, (long)checkSum);
    }

    private static int correctBufferSize(Configuration conf, int bufferSize) {
        return bufferSize <= 0 ? conf.getInt("io.file.buffer.size", 4096) : bufferSize;
    }

    @Override
    public FSDataOutputStream create(Path path, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        FileSystem fs = this.getFileSystemByPath(path);
        blockSize = VolumeManagerImpl.correctBlockSize(fs.getConf(), blockSize);
        bufferSize = VolumeManagerImpl.correctBufferSize(fs.getConf(), bufferSize);
        return fs.create(path, overwrite, bufferSize, replication, blockSize);
    }

    @Override
    public boolean createNewFile(Path path) throws IOException {
        return this.getFileSystemByPath(path).createNewFile(path);
    }

    @Override
    public FSDataOutputStream createSyncable(Path logPath, int bufferSize, short replication, long blockSize) throws IOException {
        FileSystem fs = this.getFileSystemByPath(logPath);
        blockSize = VolumeManagerImpl.correctBlockSize(fs.getConf(), blockSize);
        bufferSize = VolumeManagerImpl.correctBufferSize(fs.getConf(), bufferSize);
        EnumSet<CreateFlag> set = EnumSet.of(CreateFlag.SYNC_BLOCK, CreateFlag.CREATE);
        log.debug("creating {} with CreateFlag set: {}", (Object)logPath, set);
        try {
            return fs.create(logPath, FsPermission.getDefault(), set, bufferSize, replication, blockSize, null);
        }
        catch (Exception ex) {
            log.debug("Exception", (Throwable)ex);
            return fs.create(logPath, true, bufferSize, replication, blockSize);
        }
    }

    @Override
    public boolean delete(Path path) throws IOException {
        return this.getFileSystemByPath(path).delete(path, false);
    }

    @Override
    public boolean deleteRecursively(Path path) throws IOException {
        return this.getFileSystemByPath(path).delete(path, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureSyncIsEnabled() {
        for (Map.Entry<String, Volume> entry : this.volumesByName.entrySet()) {
            FileSystem fs = entry.getValue().getFileSystem();
            if (!(fs instanceof DistributedFileSystem)) continue;
            String DFS_SUPPORT_APPEND = "dfs.support.append";
            String DFS_DATANODE_SYNCONCLOSE = "dfs.datanode.synconclose";
            String ticketMessage = "See ACCUMULO-623 and ACCUMULO-1637 for more details.";
            if (!fs.getConf().getBoolean("dfs.support.append", true)) {
                String msg = "Accumulo requires that dfs.support.append not be configured as false. See ACCUMULO-623 and ACCUMULO-1637 for more details.";
                log.error("FATAL {}", (Object)msg);
                throw new RuntimeException(msg);
            }
            if (fs.getConf().getBoolean("dfs.datanode.synconclose", false)) continue;
            HashSet<String> hashSet = WARNED_ABOUT_SYNCONCLOSE;
            synchronized (hashSet) {
                if (!WARNED_ABOUT_SYNCONCLOSE.contains(entry.getKey())) {
                    WARNED_ABOUT_SYNCONCLOSE.add(entry.getKey());
                    log.warn("{} set to false in hdfs-site.xml: data loss is possible on hard system reset or power loss", (Object)"dfs.datanode.synconclose");
                }
            }
        }
    }

    @Override
    public boolean exists(Path path) throws IOException {
        return this.getFileSystemByPath(path).exists(path);
    }

    @Override
    public FileStatus getFileStatus(Path path) throws IOException {
        return this.getFileSystemByPath(path).getFileStatus(path);
    }

    @Override
    public FileSystem getFileSystemByPath(Path path) {
        FileSystem desiredFs;
        try {
            Configuration volumeConfig = this.hadoopConf;
            for (String vol : this.volumesByName.keySet()) {
                if (!path.toString().startsWith(vol)) continue;
                volumeConfig = VolumeManagerImpl.getVolumeManagerConfiguration(this.conf, this.hadoopConf, vol);
                break;
            }
            desiredFs = Objects.requireNonNull(path).getFileSystem(volumeConfig);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        URI desiredFsUri = desiredFs.getUri();
        Collection candidateVolumes = this.volumesByFileSystemUri.get((Object)desiredFsUri);
        if (candidateVolumes != null) {
            return candidateVolumes.stream().filter(volume -> volume.containsPath(path)).map(Volume::getFileSystem).findFirst().orElse(desiredFs);
        }
        log.debug("Could not determine volume for Path: {}", (Object)path);
        return desiredFs;
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listFiles(Path path, boolean recursive) throws IOException {
        return this.getFileSystemByPath(path).listFiles(path, recursive);
    }

    @Override
    public FileStatus[] listStatus(Path path) throws IOException {
        return this.getFileSystemByPath(path).listStatus(path);
    }

    @Override
    public boolean mkdirs(Path path) throws IOException {
        return this.getFileSystemByPath(path).mkdirs(path);
    }

    @Override
    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        return this.getFileSystemByPath(path).mkdirs(path, permission);
    }

    @Override
    public FSDataInputStream open(Path path) throws IOException {
        return this.getFileSystemByPath(path).open(path);
    }

    @Override
    public boolean rename(Path path, Path newPath) throws IOException {
        FileSystem dest;
        FileSystem source = this.getFileSystemByPath(path);
        if (source != (dest = this.getFileSystemByPath(newPath))) {
            throw new UnsupportedOperationException("Cannot rename files across volumes: " + path + " -> " + newPath);
        }
        return source.rename(path, newPath);
    }

    @Override
    public void bulkRename(Map<Path, Path> oldToNewPathMap, int poolSize, String poolName, String transactionId) throws IOException {
        ArrayList results = new ArrayList();
        ThreadPoolExecutor workerPool = ThreadPools.getServerThreadPools().createFixedThreadPool(poolSize, poolName, false);
        oldToNewPathMap.forEach((oldPath, newPath) -> results.add(workerPool.submit(() -> {
            boolean success;
            try {
                success = this.rename((Path)oldPath, (Path)newPath);
            }
            catch (IOException e) {
                if (!this.exists((Path)newPath) || this.exists((Path)oldPath)) {
                    throw e;
                }
                log.debug("Ignoring rename exception for {} because destination already exists. orig: {} new: {}", new Object[]{transactionId, oldPath, newPath, e});
                success = true;
            }
            if (!(success || this.exists((Path)newPath) && !this.exists((Path)oldPath))) {
                throw new IOException("Rename operation " + transactionId + " returned false. orig: " + oldPath + " new: " + newPath);
            }
            if (log.isTraceEnabled()) {
                log.trace("{} moved {} to {}", new Object[]{transactionId, oldPath, newPath});
            }
            return null;
        })));
        workerPool.shutdown();
        try {
            while (!workerPool.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
            }
            for (Future future : results) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean moveToTrash(Path path) throws IOException {
        FileSystem fs = this.getFileSystemByPath(path);
        String key = "fs.trash.interval";
        log.trace("{}: {}", (Object)key, (Object)fs.getConf().get(key));
        Trash trash = new Trash(fs, fs.getConf());
        log.trace("Hadoop Trash is enabled for {}: {}", (Object)path, (Object)trash.isEnabled());
        return trash.moveToTrash(path);
    }

    @Override
    public short getDefaultReplication(Path path) {
        return this.getFileSystemByPath(path).getDefaultReplication(path);
    }

    private static Configuration getVolumeManagerConfiguration(AccumuloConfiguration conf, Configuration hadoopConf, String filesystemURI) {
        Configuration volumeConfig = new Configuration(hadoopConf);
        conf.getAllPropertiesWithPrefixStripped(Property.INSTANCE_VOLUME_CONFIG_PREFIX).entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(filesystemURI + ".")).forEach(e -> {
            String key = ((String)e.getKey()).substring(filesystemURI.length() + 1);
            String value = (String)e.getValue();
            log.info("Overriding property {} for volume {}", new Object[]{key, value, filesystemURI});
            volumeConfig.set(key, value);
        });
        return volumeConfig;
    }

    protected static Stream<Map.Entry<String, String>> findVolumeOverridesMissingVolume(AccumuloConfiguration conf, Set<String> definedVolumes) {
        return conf.getAllPropertiesWithPrefixStripped(Property.INSTANCE_VOLUME_CONFIG_PREFIX).entrySet().stream().filter(e -> definedVolumes.stream().noneMatch(vol -> ((String)e.getKey()).startsWith(vol + ".")));
    }

    public static VolumeManager get(AccumuloConfiguration conf, Configuration hadoopConf) throws IOException {
        HashMap<String, Volume> volumes = new HashMap<String, Volume>();
        Set volumeStrings = VolumeConfiguration.getVolumeUris((AccumuloConfiguration)conf);
        VolumeManagerImpl.findVolumeOverridesMissingVolume(conf, volumeStrings).forEach(e -> log.warn("Found no matching volume for volume config override property {}", e));
        for (String volumeUriOrDir : volumeStrings) {
            if (volumeUriOrDir.isBlank()) {
                throw new IllegalArgumentException("Empty volume specified in configuration");
            }
            if (volumeUriOrDir.startsWith("viewfs")) {
                throw new IllegalArgumentException("Cannot use viewfs as a volume");
            }
            if (volumeUriOrDir.contains(":")) {
                Configuration volumeConfig = VolumeManagerImpl.getVolumeManagerConfiguration(conf, hadoopConf, volumeUriOrDir);
                volumes.put(volumeUriOrDir, (Volume)new VolumeImpl(new Path(volumeUriOrDir), volumeConfig));
                continue;
            }
            throw new IllegalArgumentException("Expected fully qualified URI for " + Property.INSTANCE_VOLUMES.getKey() + " got " + volumeUriOrDir);
        }
        return new VolumeManagerImpl(volumes, conf, hadoopConf);
    }

    private static boolean inSafeMode(DistributedFileSystem dfs) throws IOException {
        return dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET);
    }

    @Override
    public boolean isReady() throws IOException {
        for (Volume volume : this.volumesByName.values()) {
            FileSystem fs = volume.getFileSystem();
            if (!(fs instanceof DistributedFileSystem) || !VolumeManagerImpl.inSafeMode((DistributedFileSystem)fs)) continue;
            return false;
        }
        return true;
    }

    @Override
    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        return this.getFileSystemByPath(pathPattern).globStatus(pathPattern);
    }

    @Override
    public Path matchingFileSystem(Path source, Set<String> options) {
        URI sourceUri = source.toUri();
        return options.stream().filter(opt -> {
            URI optUri = URI.create(opt);
            return sourceUri.getScheme().equals(optUri.getScheme()) && Objects.equals(sourceUri.getAuthority(), optUri.getAuthority());
        }).map(opt -> new Path(opt)).findFirst().orElse(null);
    }

    @Override
    public String choose(VolumeChooserEnvironment env, Set<String> options) {
        String choice = this.chooser.choose(env, options);
        if (!options.contains(choice)) {
            String msg = "The configured volume chooser, '" + this.chooser.getClass() + "', or one of its delegates returned a volume not in the set of options provided";
            throw new RuntimeException(msg);
        }
        return choice;
    }

    @Override
    public Set<String> choosable(VolumeChooserEnvironment env, Set<String> options) {
        Set choices = this.chooser.choosable(env, options);
        for (String choice : choices) {
            if (options.contains(choice)) continue;
            String msg = "The configured volume chooser, '" + this.chooser.getClass() + "', or one of its delegates returned a volume not in the set of options provided";
            throw new RuntimeException(msg);
        }
        return choices;
    }

    @Override
    public boolean canSyncAndFlush(Path path) {
        FileSystem fs = this.getFileSystemByPath(path);
        if (fs instanceof DistributedFileSystem) {
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            try {
                ErasureCodingPolicy currEC = dfs.getErasureCodingPolicy(path);
                if (currEC != null && !currEC.isReplicationPolicy()) {
                    return false;
                }
            }
            catch (IOException e) {
                log.debug("exception getting EC policy for " + path, (Throwable)e);
            }
        }
        return true;
    }

    @Override
    public Collection<Volume> getVolumes() {
        return this.volumesByName.values();
    }

    private static /* synthetic */ void lambda$invertVolumesByFileSystem$0(Multimap inverted, Volume volume) {
        inverted.put((Object)volume.getFileSystem().getUri(), (Object)volume);
    }
}

