/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.rpc;

import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.metrics.MetricsUtil;
import org.apache.accumulo.server.metrics.ThriftMetrics;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;

public class TimedProcessor
implements TProcessor {
    private final TProcessor other;
    private final ThriftMetrics thriftMetrics;
    private long idleStart = 0L;

    public TimedProcessor(TProcessor next) {
        this.other = next;
        this.thriftMetrics = new ThriftMetrics();
        MetricsUtil.initializeProducers((MetricsProducer[])new MetricsProducer[]{this.thriftMetrics});
        this.idleStart = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(TProtocol in, TProtocol out) throws TException {
        long processStart = System.nanoTime();
        this.thriftMetrics.addIdle(TimeUnit.NANOSECONDS.toMillis(processStart - this.idleStart));
        try {
            this.other.process(in, out);
        }
        finally {
            this.idleStart = System.nanoTime();
            this.thriftMetrics.addExecute(TimeUnit.NANOSECONDS.toMillis(this.idleStart - processStart));
        }
    }
}

