/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ScannerImpl;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.MetadataTime;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.util.FileUtil;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerMetadataUtil {
    private static final Logger log = LoggerFactory.getLogger(ManagerMetadataUtil.class);

    public static void addNewTablet(ServerContext context, KeyExtent extent, String dirName, TServerInstance tServerInstance, Map<StoredTabletFile, DataFileValue> datafileSizes, Map<Long, ? extends Collection<TabletFile>> bulkLoadedFiles, MetadataTime time, long lastFlushID, long lastCompactID, ServiceLock zooLock) {
        Ample.TabletMutator tablet = context.getAmple().mutateTablet(extent);
        tablet.putPrevEndRow(extent.prevEndRow());
        tablet.putZooLock(zooLock);
        tablet.putDirName(dirName);
        tablet.putTime(time);
        if (lastFlushID > 0L) {
            tablet.putFlushId(lastFlushID);
        }
        if (lastCompactID > 0L) {
            tablet.putCompactionId(lastCompactID);
        }
        if (tServerInstance != null) {
            tablet.putLocation(TabletMetadata.Location.current((TServerInstance)tServerInstance));
            tablet.deleteLocation(TabletMetadata.Location.future((TServerInstance)tServerInstance));
        }
        datafileSizes.forEach((arg_0, arg_1) -> ((Ample.TabletMutator)tablet).putFile(arg_0, arg_1));
        for (Map.Entry<Long, ? extends Collection<TabletFile>> entry : bulkLoadedFiles.entrySet()) {
            for (TabletFile ref : entry.getValue()) {
                tablet.putBulkFile(ref, entry.getKey().longValue());
            }
        }
        tablet.mutate();
    }

    public static KeyExtent fixSplit(ServerContext context, TabletMetadata meta, ServiceLock lock) throws AccumuloException {
        log.info("Incomplete split {} attempting to fix", (Object)meta.getExtent());
        if (meta.getSplitRatio() == null) {
            throw new IllegalArgumentException("Metadata entry does not have split ratio (" + meta.getExtent() + ")");
        }
        if (meta.getTime() == null) {
            throw new IllegalArgumentException("Metadata entry does not have time (" + meta.getExtent() + ")");
        }
        return ManagerMetadataUtil.fixSplit(context, meta.getTableId(), meta.getExtent().toMetaRow(), meta.getPrevEndRow(), meta.getOldPrevEndRow(), meta.getSplitRatio(), lock);
    }

    private static KeyExtent fixSplit(ServerContext context, TableId tableId, Text metadataEntry, Text metadataPrevEndRow, Text oper, double splitRatio, ServiceLock lock) throws AccumuloException {
        if (metadataPrevEndRow == null) {
            throw new AccumuloException("Split tablet does not have prev end row, something is amiss, extent = " + metadataEntry);
        }
        Key prevRowKey = new Key(new Text(MetadataSchema.TabletsSection.encodeRow((TableId)tableId, (Text)metadataPrevEndRow)));
        try (ScannerImpl scanner2 = new ScannerImpl((ClientContext)context, MetadataTable.ID, Authorizations.EMPTY);){
            scanner2.setRange(new Range(prevRowKey, prevRowKey.followingKey(PartialKey.ROW)));
            if (scanner2.iterator().hasNext()) {
                log.info("Finishing incomplete split {} {}", (Object)metadataEntry, (Object)metadataPrevEndRow);
                ArrayList<StoredTabletFile> highDatafilesToRemove = new ArrayList<StoredTabletFile>();
                TreeMap<StoredTabletFile, DataFileValue> origDatafileSizes = new TreeMap<StoredTabletFile, DataFileValue>();
                TreeMap<StoredTabletFile, DataFileValue> highDatafileSizes = new TreeMap<StoredTabletFile, DataFileValue>();
                TreeMap<StoredTabletFile, DataFileValue> lowDatafileSizes = new TreeMap<StoredTabletFile, DataFileValue>();
                Key rowKey = new Key(metadataEntry);
                try (ScannerImpl scanner3 = new ScannerImpl((ClientContext)context, MetadataTable.ID, Authorizations.EMPTY);){
                    scanner3.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                    scanner3.setRange(new Range(rowKey, rowKey.followingKey(PartialKey.ROW)));
                    for (Map.Entry entry : scanner3) {
                        if (((Key)entry.getKey()).compareColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME) != 0) continue;
                        StoredTabletFile stf = new StoredTabletFile(((Key)entry.getKey()).getColumnQualifierData().toString());
                        origDatafileSizes.put(stf, new DataFileValue(((Value)entry.getValue()).get()));
                    }
                }
                MetadataTableUtil.splitDatafiles(metadataPrevEndRow, splitRatio, new HashMap<TabletFile, FileUtil.FileInfo>(), origDatafileSizes, lowDatafileSizes, highDatafileSizes, highDatafilesToRemove);
                MetadataTableUtil.finishSplit(metadataEntry, highDatafileSizes, highDatafilesToRemove, context, lock);
                KeyExtent keyExtent = KeyExtent.fromMetaRow((Text)rowKey.getRow(), (Text)metadataPrevEndRow);
                return keyExtent;
            }
            log.info("Rolling back incomplete split {} {}", (Object)metadataEntry, (Object)metadataPrevEndRow);
            MetadataTableUtil.rollBackSplit(metadataEntry, oper, context, lock);
            KeyExtent keyExtent = KeyExtent.fromMetaRow((Text)metadataEntry, (Text)oper);
            return keyExtent;
        }
    }

    public static void replaceDatafiles(ServerContext context, KeyExtent extent, Set<StoredTabletFile> datafilesToDelete, Set<StoredTabletFile> scanFiles, Optional<StoredTabletFile> path, Long compactionId, DataFileValue size, TServerInstance tServerInstance, TabletMetadata.Location lastLocation, ServiceLock zooLock, Optional<ExternalCompactionId> ecid) {
        context.getAmple().putGcCandidates(extent.tableId(), datafilesToDelete);
        Ample.TabletMutator tablet = context.getAmple().mutateTablet(extent);
        datafilesToDelete.forEach(arg_0 -> ((Ample.TabletMutator)tablet).deleteFile(arg_0));
        scanFiles.forEach(arg_0 -> ((Ample.TabletMutator)tablet).putScan(arg_0));
        if (path.isPresent()) {
            tablet.putFile(path.orElseThrow(), size);
        }
        if (compactionId != null) {
            tablet.putCompactionId(compactionId.longValue());
        }
        ManagerMetadataUtil.updateLastForCompactionMode(context, tablet, lastLocation, tServerInstance);
        if (ecid.isPresent()) {
            tablet.deleteExternalCompaction(ecid.orElseThrow());
        }
        tablet.putZooLock(zooLock);
        tablet.mutate();
    }

    public static Optional<StoredTabletFile> updateTabletDataFile(ServerContext context, KeyExtent extent, TabletFile newDatafile, DataFileValue dfv, MetadataTime time, TServerInstance tServerInstance, ServiceLock zooLock, Set<String> unusedWalLogs, TabletMetadata.Location lastLocation, long flushId) {
        Ample.TabletMutator tablet = context.getAmple().mutateTablet(extent);
        Optional<StoredTabletFile> newFile = Optional.empty();
        if (dfv.getNumEntries() > 0L) {
            tablet.putFile(newDatafile, dfv);
            tablet.putTime(time);
            newFile = Optional.of(newDatafile.insert());
            ManagerMetadataUtil.updateLastForCompactionMode(context, tablet, lastLocation, tServerInstance);
        }
        tablet.putFlushId(flushId);
        unusedWalLogs.forEach(arg_0 -> ((Ample.TabletMutator)tablet).deleteWal(arg_0));
        tablet.putZooLock(zooLock);
        tablet.mutate();
        return newFile;
    }

    public static void updateLastForAssignmentMode(ClientContext context, Ample.TabletMutator tabletMutator, TServerInstance location, TabletMetadata.Location lastLocation) {
        Preconditions.checkArgument((lastLocation == null || lastLocation.getType() == TabletMetadata.LocationType.LAST ? 1 : 0) != 0);
        if ("assignment".equals(context.getConfiguration().get(Property.TSERV_LAST_LOCATION_MODE))) {
            ManagerMetadataUtil.updateLocation(tabletMutator, lastLocation, TabletMetadata.Location.last((TServerInstance)location));
        }
    }

    public static void updateLastForCompactionMode(ClientContext context, Ample.TabletMutator tabletMutator, TabletMetadata.Location lastLocation, TServerInstance tServerInstance) {
        if ("compaction".equals(context.getConfiguration().get(Property.TSERV_LAST_LOCATION_MODE))) {
            TabletMetadata.Location newLocation = TabletMetadata.Location.last((TServerInstance)tServerInstance);
            ManagerMetadataUtil.updateLocation(tabletMutator, lastLocation, newLocation);
        }
    }

    private static void updateLocation(Ample.TabletMutator tabletMutator, TabletMetadata.Location previousLocation, TabletMetadata.Location newLocation) {
        if (previousLocation != null) {
            if (!previousLocation.equals((Object)newLocation)) {
                tabletMutator.deleteLocation(previousLocation);
                tabletMutator.putLocation(newLocation);
            }
        } else {
            tabletMutator.putLocation(newLocation);
        }
    }
}

