/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.google.protobuf.GeneratedMessageV3;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Credentials;
import org.apache.accumulo.core.clientImpl.Writer;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.iterators.Combiner;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.server.replication.StatusCombiner;
import org.apache.accumulo.server.replication.StatusFormatter;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationTableUtil {
    private static Map<Credentials, Writer> writers = new HashMap<Credentials, Writer>();
    private static final Logger log = LoggerFactory.getLogger(ReplicationTableUtil.class);
    public static final String COMBINER_NAME = "replcombiner";
    public static final String STATUS_FORMATTER_CLASS_NAME = StatusFormatter.class.getName();

    private ReplicationTableUtil() {
    }

    static synchronized void addWriter(Credentials creds, Writer writer) {
        writers.put(creds, writer);
    }

    static synchronized Writer getWriter(ClientContext context) {
        Writer replicationTable = writers.get(context.getCredentials());
        if (replicationTable == null) {
            ReplicationTableUtil.configureMetadataTable((AccumuloClient)context, MetadataTable.NAME);
            replicationTable = new Writer(context, MetadataTable.ID);
            writers.put(context.getCredentials(), replicationTable);
        }
        return replicationTable;
    }

    public static synchronized void configureMetadataTable(AccumuloClient client, String tableName) {
        Map properties;
        TableOperations tops = client.tableOperations();
        Map iterators = null;
        try {
            iterators = tops.listIterators(tableName);
        }
        catch (AccumuloException | AccumuloSecurityException | TableNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (!iterators.containsKey(COMBINER_NAME)) {
            Class<StatusCombiner> statusCombinerClass = StatusCombiner.class;
            IteratorSetting setting = new IteratorSetting(9, COMBINER_NAME, statusCombinerClass);
            Combiner.setColumns((IteratorSetting)setting, Collections.singletonList(new IteratorSetting.Column(MetadataSchema.ReplicationSection.COLF)));
            try {
                tops.attachIterator(tableName, setting);
            }
            catch (AccumuloException | AccumuloSecurityException | TableNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            properties = tops.getConfiguration(tableName);
        }
        catch (AccumuloException | TableNotFoundException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry property : properties.entrySet()) {
            if (!Property.TABLE_FORMATTER_CLASS.getKey().equals(property.getKey())) continue;
            if (!STATUS_FORMATTER_CLASS_NAME.equals(property.getValue())) {
                log.info("Setting formatter for {} from {} to {}", new Object[]{tableName, property.getValue(), STATUS_FORMATTER_CLASS_NAME});
                try {
                    tops.setProperty(tableName, Property.TABLE_FORMATTER_CLASS.getKey(), STATUS_FORMATTER_CLASS_NAME);
                }
                catch (AccumuloException | AccumuloSecurityException e) {
                    throw new RuntimeException(e);
                }
            }
            return;
        }
        try {
            tops.setProperty(tableName, Property.TABLE_FORMATTER_CLASS.getKey(), STATUS_FORMATTER_CLASS_NAME);
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    static void update(ClientContext context, Mutation m) {
        Writer t = ReplicationTableUtil.getWriter(context);
        while (true) {
            try {
                t.update(m);
                return;
            }
            catch (AccumuloException | AccumuloSecurityException | TableNotFoundException | ConstraintViolationException e) {
                log.error(e.toString(), e);
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            break;
        }
    }

    public static void updateFiles(ClientContext context, KeyExtent extent, String file, Replication.Status stat) {
        if (log.isDebugEnabled()) {
            log.debug("Updating replication status for {} with {} using {}", new Object[]{extent, file, ProtobufUtil.toString((GeneratedMessageV3)stat)});
        }
        Value v = ProtobufUtil.toValue((GeneratedMessageV3)stat);
        ReplicationTableUtil.update(context, ReplicationTableUtil.createUpdateMutation(new Path(file), v, extent));
    }

    static Mutation createUpdateMutation(Path file, Value v, KeyExtent extent) {
        return ReplicationTableUtil.createUpdateMutation(new Text(MetadataSchema.ReplicationSection.getRowPrefix() + file), v, extent);
    }

    private static Mutation createUpdateMutation(Text row, Value v, KeyExtent extent) {
        Mutation m = new Mutation(row);
        m.put(MetadataSchema.ReplicationSection.COLF, new Text(extent.tableId().canonical()), v);
        return m;
    }
}

