/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.manager.state;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.logging.TabletLogger;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletLocationState;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.server.manager.state.Assignment;
import org.apache.accumulo.server.manager.state.ClosableIterator;
import org.apache.accumulo.server.manager.state.DistributedStoreException;
import org.apache.accumulo.server.manager.state.TabletStateStore;
import org.apache.hadoop.fs.Path;

class LoggingTabletStateStore
implements TabletStateStore {
    private TabletStateStore wrapped;

    LoggingTabletStateStore(TabletStateStore tss) {
        this.wrapped = tss;
    }

    @Override
    public Ample.DataLevel getLevel() {
        return this.wrapped.getLevel();
    }

    @Override
    public String name() {
        return this.wrapped.name();
    }

    @Override
    public ClosableIterator<TabletLocationState> iterator() {
        return this.wrapped.iterator();
    }

    @Override
    public void setFutureLocations(Collection<Assignment> assignments) throws DistributedStoreException {
        this.wrapped.setFutureLocations(assignments);
        assignments.forEach(assignment -> TabletLogger.assigned((KeyExtent)assignment.tablet, (TServerInstance)assignment.server));
    }

    @Override
    public void setLocations(Collection<Assignment> assignments) throws DistributedStoreException {
        this.wrapped.setLocations(assignments);
        assignments.forEach(assignment -> TabletLogger.loaded((KeyExtent)assignment.tablet, (TServerInstance)assignment.server));
    }

    @Override
    public void unassign(Collection<TabletLocationState> tablets, Map<TServerInstance, List<Path>> logsForDeadServers) throws DistributedStoreException {
        this.wrapped.unassign(tablets, logsForDeadServers);
        if (logsForDeadServers == null) {
            logsForDeadServers = Map.of();
        }
        for (TabletLocationState tls : tablets) {
            TabletLogger.unassigned((KeyExtent)tls.extent, (int)logsForDeadServers.size());
        }
    }

    @Override
    public void suspend(Collection<TabletLocationState> tablets, Map<TServerInstance, List<Path>> logsForDeadServers, long suspensionTimestamp) throws DistributedStoreException {
        this.wrapped.suspend(tablets, logsForDeadServers, suspensionTimestamp);
        if (logsForDeadServers == null) {
            logsForDeadServers = Map.of();
        }
        for (TabletLocationState tls : tablets) {
            TabletMetadata.Location location = tls.getLocation();
            HostAndPort server = null;
            if (location != null) {
                server = location.getHostAndPort();
            }
            TabletLogger.suspended((KeyExtent)tls.extent, (HostAndPort)server, (long)suspensionTimestamp, (TimeUnit)TimeUnit.MILLISECONDS, (int)logsForDeadServers.size());
        }
    }

    @Override
    public void unsuspend(Collection<TabletLocationState> tablets) throws DistributedStoreException {
        this.wrapped.unsuspend(tablets);
        for (TabletLocationState tls : tablets) {
            TabletLogger.unsuspended((KeyExtent)tls.extent);
        }
    }
}

