/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.clientImpl.BatchWriterImpl;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ScannerImpl;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.gc.ReferenceFile;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.MetadataTime;
import org.apache.accumulo.core.metadata.schema.TabletDeletedException;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.gc.AllVolumesDirectory;
import org.apache.accumulo.server.util.FileUtil;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataTableUtil {
    public static final Text EMPTY_TEXT = new Text();
    private static final Logger log = LoggerFactory.getLogger(MetadataTableUtil.class);

    private MetadataTableUtil() {
    }

    public static void putLockID(ServerContext context, ServiceLock zooLock, Mutation m) {
        MetadataSchema.TabletsSection.ServerColumnFamily.LOCK_COLUMN.put(m, new Value((CharSequence)zooLock.getLockID().serialize(context.getZooKeeperRoot() + "/")));
    }

    public static void update(ServerContext context, ServiceLock zooLock, Mutation m, KeyExtent extent) {
        if (zooLock != null) {
            MetadataTableUtil.putLockID(context, zooLock, m);
        }
        String metaTable = Ample.DataLevel.of((TableId)extent.tableId()).metaTable();
        while (true) {
            try (BatchWriter writer = context.createBatchWriter(metaTable);){
                writer.addMutation(m);
                writer.flush();
                return;
            }
            catch (MutationsRejectedException e) {
                if (!e.getConstraintViolationSummaries().isEmpty()) {
                    throw new IllegalArgumentException(e);
                }
            }
            catch (TableNotFoundException e) {
                MetadataTableUtil.logUpdateFailure(m, extent, (Exception)((Object)e));
            }
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    private static void logUpdateFailure(Mutation m, KeyExtent extent, Exception e) {
        log.error("Failed to write metadata updates for extent {} {}", new Object[]{extent, m.prettyPrint(), e});
    }

    public static void updateTabletFlushID(KeyExtent extent, long flushID, ServerContext context, ServiceLock zooLock) {
        Ample.TabletMutator tablet = context.getAmple().mutateTablet(extent);
        tablet.putFlushId(flushID);
        tablet.putZooLock(zooLock);
        tablet.mutate();
    }

    public static void updateTabletCompactID(KeyExtent extent, long compactID, ServerContext context, ServiceLock zooLock) {
        Ample.TabletMutator tablet = context.getAmple().mutateTablet(extent);
        tablet.putCompactionId(compactID);
        tablet.putZooLock(zooLock);
        tablet.mutate();
    }

    public static Map<StoredTabletFile, DataFileValue> updateTabletDataFile(long tid, KeyExtent extent, Map<TabletFile, DataFileValue> estSizes, MetadataTime time, ServerContext context, ServiceLock zooLock) {
        Ample.TabletMutator tablet = context.getAmple().mutateTablet(extent);
        tablet.putTime(time);
        HashMap<StoredTabletFile, DataFileValue> newFiles = new HashMap<StoredTabletFile, DataFileValue>(estSizes.size());
        estSizes.forEach((tf, dfv) -> {
            tablet.putFile(tf, dfv);
            tablet.putBulkFile(tf, tid);
            newFiles.put(tf.insert(), (DataFileValue)dfv);
        });
        tablet.putZooLock(zooLock);
        tablet.mutate();
        return newFiles;
    }

    public static void addTablet(KeyExtent extent, String path, ServerContext context, TimeType timeType, ServiceLock zooLock) {
        Ample.TabletMutator tablet = context.getAmple().mutateTablet(extent);
        tablet.putPrevEndRow(extent.prevEndRow());
        tablet.putDirName(path);
        tablet.putTime(new MetadataTime(0L, timeType));
        tablet.putZooLock(zooLock);
        tablet.mutate();
    }

    public static void updateTabletVolumes(KeyExtent extent, List<LogEntry> logsToRemove, List<LogEntry> logsToAdd, List<StoredTabletFile> filesToRemove, SortedMap<TabletFile, DataFileValue> filesToAdd, ServiceLock zooLock, ServerContext context) {
        Ample.TabletMutator tabletMutator = context.getAmple().mutateTablet(extent);
        logsToRemove.forEach(arg_0 -> ((Ample.TabletMutator)tabletMutator).deleteWal(arg_0));
        logsToAdd.forEach(arg_0 -> ((Ample.TabletMutator)tabletMutator).putWal(arg_0));
        filesToRemove.forEach(arg_0 -> ((Ample.TabletMutator)tabletMutator).deleteFile(arg_0));
        filesToAdd.forEach((arg_0, arg_1) -> ((Ample.TabletMutator)tabletMutator).putFile(arg_0, arg_1));
        tabletMutator.putZooLock(zooLock);
        tabletMutator.mutate();
    }

    public static void rollBackSplit(Text metadataEntry, Text oldPrevEndRow, ServerContext context, ServiceLock zooLock) {
        KeyExtent ke = KeyExtent.fromMetaRow((Text)metadataEntry, (Text)oldPrevEndRow);
        Mutation m = MetadataSchema.TabletsSection.TabletColumnFamily.createPrevRowMutation((KeyExtent)ke);
        MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN.putDelete(m);
        MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN.putDelete(m);
        MetadataTableUtil.update(context, zooLock, m, KeyExtent.fromMetaRow((Text)metadataEntry));
    }

    public static void splitTablet(KeyExtent extent, Text oldPrevEndRow, double splitRatio, ServerContext context, ServiceLock zooLock, Set<ExternalCompactionId> ecids) {
        Mutation m = MetadataSchema.TabletsSection.TabletColumnFamily.createPrevRowMutation((KeyExtent)extent);
        MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN.put(m, new Value((CharSequence)Double.toString(splitRatio)));
        MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN.put(m, MetadataSchema.TabletsSection.TabletColumnFamily.encodePrevEndRow((Text)oldPrevEndRow));
        MetadataSchema.TabletsSection.ChoppedColumnFamily.CHOPPED_COLUMN.putDelete(m);
        ecids.forEach(ecid -> m.putDelete((CharSequence)"ecomp", (CharSequence)ecid.canonical()));
        MetadataTableUtil.update(context, zooLock, m, extent);
    }

    public static void finishSplit(Text metadataEntry, Map<StoredTabletFile, DataFileValue> datafileSizes, List<StoredTabletFile> highDatafilesToRemove, ServerContext context, ServiceLock zooLock) {
        Mutation m = new Mutation(metadataEntry);
        MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN.putDelete(m);
        MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN.putDelete(m);
        MetadataSchema.TabletsSection.ChoppedColumnFamily.CHOPPED_COLUMN.putDelete(m);
        for (Map.Entry<StoredTabletFile, DataFileValue> entry : datafileSizes.entrySet()) {
            m.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, entry.getKey().getMetaUpdateDeleteText(), new Value(entry.getValue().encode()));
        }
        for (StoredTabletFile pathToRemove : highDatafilesToRemove) {
            m.putDelete(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, pathToRemove.getMetaUpdateDeleteText());
        }
        MetadataTableUtil.update(context, zooLock, m, KeyExtent.fromMetaRow((Text)metadataEntry));
    }

    public static void finishSplit(KeyExtent extent, Map<StoredTabletFile, DataFileValue> datafileSizes, List<StoredTabletFile> highDatafilesToRemove, ServerContext context, ServiceLock zooLock) {
        MetadataTableUtil.finishSplit(extent.toMetaRow(), datafileSizes, highDatafilesToRemove, context, zooLock);
    }

    public static void removeScanFiles(KeyExtent extent, Set<StoredTabletFile> scanFiles, ServerContext context, ServiceLock zooLock) {
        Ample.TabletMutator tablet = context.getAmple().mutateTablet(extent);
        scanFiles.forEach(arg_0 -> ((Ample.TabletMutator)tablet).deleteScan(arg_0));
        tablet.putZooLock(zooLock);
        tablet.mutate();
    }

    public static void splitDatafiles(Text midRow, double splitRatio, Map<TabletFile, FileUtil.FileInfo> firstAndLastRows, SortedMap<StoredTabletFile, DataFileValue> datafiles, SortedMap<StoredTabletFile, DataFileValue> lowDatafileSizes, SortedMap<StoredTabletFile, DataFileValue> highDatafileSizes, List<StoredTabletFile> highDatafilesToRemove) {
        for (Map.Entry<StoredTabletFile, DataFileValue> entry : datafiles.entrySet()) {
            long lowEntries;
            long lowSize;
            Text firstRow = null;
            Text lastRow = null;
            boolean rowsKnown = false;
            FileUtil.FileInfo mfi = firstAndLastRows.get(entry.getKey());
            if (mfi != null) {
                firstRow = mfi.getFirstRow();
                lastRow = mfi.getLastRow();
                rowsKnown = true;
            }
            if (rowsKnown && firstRow.compareTo((BinaryComparable)midRow) > 0) {
                long highSize = entry.getValue().getSize();
                long highEntries = entry.getValue().getNumEntries();
                highDatafileSizes.put(entry.getKey(), new DataFileValue(highSize, highEntries, entry.getValue().getTime()));
                continue;
            }
            if (rowsKnown && lastRow.compareTo((BinaryComparable)midRow) <= 0) {
                lowSize = entry.getValue().getSize();
                lowEntries = entry.getValue().getNumEntries();
                lowDatafileSizes.put(entry.getKey(), new DataFileValue(lowSize, lowEntries, entry.getValue().getTime()));
                highDatafilesToRemove.add(entry.getKey());
                continue;
            }
            lowSize = (long)Math.floor((double)entry.getValue().getSize() * splitRatio);
            lowEntries = (long)Math.floor((double)entry.getValue().getNumEntries() * splitRatio);
            lowDatafileSizes.put(entry.getKey(), new DataFileValue(lowSize, lowEntries, entry.getValue().getTime()));
            long highSize = (long)Math.ceil((double)entry.getValue().getSize() * (1.0 - splitRatio));
            long highEntries = (long)Math.ceil((double)entry.getValue().getNumEntries() * (1.0 - splitRatio));
            highDatafileSizes.put(entry.getKey(), new DataFileValue(highSize, highEntries, entry.getValue().getTime()));
        }
    }

    public static void deleteTable(TableId tableId, boolean insertDeletes, ServerContext context, ServiceLock lock) throws AccumuloException {
        try (ScannerImpl ms = new ScannerImpl((ClientContext)context, MetadataTable.ID, Authorizations.EMPTY);
             BatchWriterImpl bw = new BatchWriterImpl((ClientContext)context, MetadataTable.ID, new BatchWriterConfig().setMaxMemory(1000000L).setMaxLatency(120000L, TimeUnit.MILLISECONDS).setMaxWriteThreads(2));){
            Key key;
            Mutation m = null;
            Ample ample = context.getAmple();
            ms.setRange(new KeyExtent(tableId, null, null).toMetaRange());
            if (insertDeletes) {
                ms.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)ms);
                for (Map.Entry cell : ms) {
                    key = (Key)cell.getKey();
                    if (key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                        StoredTabletFile stf = new StoredTabletFile(key.getColumnQualifierData().toString());
                        bw.addMutation(ample.createDeleteMutation(ReferenceFile.forFile((TableId)tableId, (String)stf.getMetaUpdateDelete())));
                    }
                    if (!MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.hasColumns(key)) continue;
                    AllVolumesDirectory uri = new AllVolumesDirectory(tableId, ((Value)cell.getValue()).toString());
                    bw.addMutation(ample.createDeleteMutation((ReferenceFile)uri));
                }
                bw.flush();
                ms.clearColumns();
            }
            for (Map.Entry cell : ms) {
                key = (Key)cell.getKey();
                if (m == null) {
                    m = new Mutation(key.getRow());
                    if (lock != null) {
                        MetadataTableUtil.putLockID(context, lock, m);
                    }
                }
                if (key.getRow().compareTo(m.getRow(), 0, m.getRow().length) != 0) {
                    bw.addMutation(m);
                    m = new Mutation(key.getRow());
                    if (lock != null) {
                        MetadataTableUtil.putLockID(context, lock, m);
                    }
                }
                m.putDelete(key.getColumnFamily(), key.getColumnQualifier());
            }
            if (m != null) {
                bw.addMutation(m);
            }
        }
    }

    public static Pair<List<LogEntry>, SortedMap<StoredTabletFile, DataFileValue>> getFileAndLogEntries(ServerContext context, KeyExtent extent) throws IOException {
        ArrayList result = new ArrayList();
        TreeMap sizes = new TreeMap();
        TabletMetadata tablet = context.getAmple().readTablet(extent, new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.FILES, TabletMetadata.ColumnType.LOGS, TabletMetadata.ColumnType.PREV_ROW, TabletMetadata.ColumnType.DIR});
        if (tablet == null) {
            throw new RuntimeException("Tablet " + extent + " not found in metadata");
        }
        result.addAll(tablet.getLogs());
        tablet.getFilesMap().forEach(sizes::put);
        return new Pair(result, sizes);
    }

    public static void removeUnusedWALEntries(ServerContext context, KeyExtent extent, List<LogEntry> entries, ServiceLock zooLock) {
        Ample.TabletMutator tablet = context.getAmple().mutateTablet(extent);
        entries.forEach(arg_0 -> ((Ample.TabletMutator)tablet).deleteWal(arg_0));
        tablet.putZooLock(zooLock);
        tablet.mutate();
    }

    private static Mutation createCloneMutation(TableId srcTableId, TableId tableId, Map<Key, Value> tablet) {
        KeyExtent ke = KeyExtent.fromMetaRow((Text)tablet.keySet().iterator().next().getRow());
        Mutation m = new Mutation(MetadataSchema.TabletsSection.encodeRow((TableId)tableId, (Text)ke.endRow()));
        for (Map.Entry<Key, Value> entry : tablet.entrySet()) {
            if (entry.getKey().getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                Object cf = entry.getKey().getColumnQualifier().toString();
                if (!((String)cf).startsWith("../") && !((String)cf).contains(":")) {
                    cf = "../" + srcTableId + entry.getKey().getColumnQualifier();
                }
                m.put(entry.getKey().getColumnFamily(), new Text((String)cf), entry.getValue());
                continue;
            }
            if (entry.getKey().getColumnFamily().equals((Object)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME)) {
                m.put(MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME, entry.getKey().getColumnQualifier(), entry.getValue());
                continue;
            }
            if (entry.getKey().getColumnFamily().equals((Object)MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME)) continue;
            m.put(entry.getKey().getColumnFamily(), entry.getKey().getColumnQualifier(), entry.getValue());
        }
        return m;
    }

    private static Iterable<TabletMetadata> createCloneScanner(String testTableName, TableId tableId, AccumuloClient client) throws TableNotFoundException {
        Range range;
        String tableName;
        if (testTableName != null) {
            tableName = testTableName;
            range = MetadataSchema.TabletsSection.getRange((TableId)tableId);
        } else if (tableId.equals((Object)MetadataTable.ID)) {
            tableName = RootTable.NAME;
            range = MetadataSchema.TabletsSection.getRange();
        } else {
            tableName = MetadataTable.NAME;
            range = MetadataSchema.TabletsSection.getRange((TableId)tableId);
        }
        return TabletsMetadata.builder((AccumuloClient)client).scanTable(tableName).overRange(range).checkConsistency().saveKeyValues().fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.FILES, TabletMetadata.ColumnType.LOCATION, TabletMetadata.ColumnType.LAST, TabletMetadata.ColumnType.CLONED, TabletMetadata.ColumnType.PREV_ROW, TabletMetadata.ColumnType.TIME}).build();
    }

    @VisibleForTesting
    public static void initializeClone(String testTableName, TableId srcTableId, TableId tableId, AccumuloClient client, BatchWriter bw) throws TableNotFoundException, MutationsRejectedException {
        Iterator<TabletMetadata> ti = MetadataTableUtil.createCloneScanner(testTableName, srcTableId, client).iterator();
        if (!ti.hasNext()) {
            throw new RuntimeException(" table deleted during clone?  srcTableId = " + srcTableId);
        }
        while (ti.hasNext()) {
            bw.addMutation(MetadataTableUtil.createCloneMutation(srcTableId, tableId, ti.next().getKeyValues()));
        }
        bw.flush();
    }

    private static int compareEndRows(Text endRow1, Text endRow2) {
        return new KeyExtent(TableId.of((String)"0"), endRow1, null).compareTo(new KeyExtent(TableId.of((String)"0"), endRow2, null));
    }

    @VisibleForTesting
    public static int checkClone(String testTableName, TableId srcTableId, TableId tableId, AccumuloClient client, BatchWriter bw) throws TableNotFoundException, MutationsRejectedException {
        Iterator<TabletMetadata> srcIter = MetadataTableUtil.createCloneScanner(testTableName, srcTableId, client).iterator();
        Iterator<TabletMetadata> cloneIter = MetadataTableUtil.createCloneScanner(testTableName, tableId, client).iterator();
        if (!cloneIter.hasNext() || !srcIter.hasNext()) {
            throw new RuntimeException(" table deleted during clone?  srcTableId = " + srcTableId + " tableId=" + tableId);
        }
        int rewrites = 0;
        while (cloneIter.hasNext()) {
            Mutation m;
            boolean cloneSuccessful;
            TabletMetadata cloneTablet = cloneIter.next();
            Text cloneEndRow = cloneTablet.getEndRow();
            HashSet cloneFiles = new HashSet();
            boolean bl = cloneSuccessful = cloneTablet.getCloned() != null;
            if (!cloneSuccessful) {
                cloneFiles.addAll(cloneTablet.getFiles());
            }
            ArrayList<TabletMetadata> srcTablets = new ArrayList<TabletMetadata>();
            TabletMetadata srcTablet = srcIter.next();
            srcTablets.add(srcTablet);
            Text srcEndRow = srcTablet.getEndRow();
            int cmp = MetadataTableUtil.compareEndRows(cloneEndRow, srcEndRow);
            if (cmp < 0) {
                throw new TabletDeletedException("Tablets deleted from src during clone : " + cloneEndRow + " " + srcEndRow);
            }
            HashSet srcFiles = new HashSet();
            if (!cloneSuccessful) {
                srcFiles.addAll(srcTablet.getFiles());
            }
            while (cmp > 0) {
                srcTablet = srcIter.next();
                srcTablets.add(srcTablet);
                srcEndRow = srcTablet.getEndRow();
                cmp = MetadataTableUtil.compareEndRows(cloneEndRow, srcEndRow);
                if (cmp < 0) {
                    throw new TabletDeletedException("Tablets deleted from src during clone : " + cloneEndRow + " " + srcEndRow);
                }
                if (cloneSuccessful) continue;
                srcFiles.addAll(srcTablet.getFiles());
            }
            if (cloneSuccessful) continue;
            if (srcFiles.containsAll(cloneFiles)) {
                m = new Mutation(cloneTablet.getExtent().toMetaRow());
                m.put(MetadataSchema.TabletsSection.ClonedColumnFamily.NAME, new Text(""), new Value((CharSequence)"OK"));
                bw.addMutation(m);
                continue;
            }
            m = new Mutation(cloneTablet.getExtent().toMetaRow());
            for (Map.Entry entry : cloneTablet.getKeyValues().entrySet()) {
                Key k = (Key)entry.getKey();
                m.putDelete(k.getColumnFamily(), k.getColumnQualifier(), k.getTimestamp());
            }
            bw.addMutation(m);
            for (TabletMetadata st : srcTablets) {
                bw.addMutation(MetadataTableUtil.createCloneMutation(srcTableId, tableId, st.getKeyValues()));
            }
            ++rewrites;
        }
        bw.flush();
        return rewrites;
    }

    public static void cloneTable(ServerContext context, TableId srcTableId, TableId tableId) throws Exception {
        try (BatchWriter bw = context.createBatchWriter(MetadataTable.NAME);){
            while (true) {
                try {
                    int rewrites;
                    MetadataTableUtil.initializeClone(null, srcTableId, tableId, (AccumuloClient)context, bw);
                    while ((rewrites = MetadataTableUtil.checkClone(null, srcTableId, tableId, (AccumuloClient)context, bw)) != 0) {
                    }
                    bw.flush();
                }
                catch (TabletDeletedException tde) {
                    bw.flush();
                    MetadataTableUtil.deleteTable(tableId, false, context, null);
                    log.debug("Tablets merged in table {} while attempting to clone, trying again", (Object)srcTableId);
                    UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                    continue;
                }
                break;
            }
            Scanner mscanner = context.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
            mscanner.setRange(new KeyExtent(tableId, null, null).toMetaRange());
            mscanner.fetchColumnFamily(MetadataSchema.TabletsSection.ClonedColumnFamily.NAME);
            int dirCount = 0;
            for (Map.Entry entry : mscanner) {
                Key k = (Key)entry.getKey();
                Mutation m = new Mutation(k.getRow());
                m.putDelete(k.getColumnFamily(), k.getColumnQualifier());
                byte[] dirName = FastFormat.toZeroPaddedString((long)dirCount++, (int)8, (int)16, (byte[])Constants.CLONE_PREFIX_BYTES);
                MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(m, new Value(dirName));
                bw.addMutation(m);
            }
        }
    }

    public static void chopped(ServerContext context, KeyExtent extent, ServiceLock zooLock) {
        Ample.TabletMutator tablet = context.getAmple().mutateTablet(extent);
        tablet.putChopped();
        tablet.putZooLock(zooLock);
        tablet.mutate();
    }
}

