/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.ValidationUtil;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.threads.ThreadPoolNames;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.cli.ServerUtilOpts;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.hadoop.fs.Path;

public class RemoveEntriesForMissingFiles {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int checkTable(ServerContext context, String tableName, Range range, boolean fix) throws Exception {
        LRUMap cache = new LRUMap(100000);
        HashSet<Path> processing = new HashSet<Path>();
        ThreadPoolExecutor threadPool = ThreadPools.getServerThreadPools().getPoolBuilder(ThreadPoolNames.UTILITY_CHECK_FILE_TASKS).numCoreThreads(16).build();
        System.out.printf("Scanning : %s %s\n", tableName, range);
        VolumeManager fs = context.getVolumeManager();
        Scanner metadata = context.createScanner(tableName, Authorizations.EMPTY);
        metadata.setRange(range);
        metadata.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        int count = 0;
        AtomicInteger missing = new AtomicInteger(0);
        AtomicReference<Object> exceptionRef = new AtomicReference<Object>(null);
        BatchWriter writer = null;
        if (fix) {
            writer = context.createBatchWriter(MetadataTable.NAME);
        }
        for (Map.Entry entry : metadata) {
            if (exceptionRef.get() != null) break;
            ++count;
            Key key = (Key)entry.getKey();
            Path map = new Path(ValidationUtil.validate((String)key.getColumnQualifierData().toString()));
            HashSet<Path> hashSet = processing;
            synchronized (hashSet) {
                while (processing.size() >= 64 || processing.contains(map)) {
                    processing.wait();
                }
                if (cache.get(map) != null) {
                    continue;
                }
                processing.add(map);
            }
            threadPool.execute(new CheckFileTask((Map<Path, Path>)cache, fs, missing, writer, key, map, processing, exceptionRef));
        }
        threadPool.shutdown();
        HashSet<Path> hashSet = processing;
        synchronized (hashSet) {
            while (!processing.isEmpty()) {
                processing.wait();
            }
        }
        if (exceptionRef.get() != null) {
            throw new AccumuloException((Throwable)exceptionRef.get());
        }
        if (writer != null && missing.get() > 0) {
            writer.close();
        }
        System.out.printf("Scan finished, %d files of %d missing\n\n", missing.get(), count);
        return missing.get();
    }

    static int checkAllTables(ServerContext context, boolean fix) throws Exception {
        int missing = RemoveEntriesForMissingFiles.checkTable(context, RootTable.NAME, MetadataSchema.TabletsSection.getRange(), fix);
        if (missing == 0) {
            return RemoveEntriesForMissingFiles.checkTable(context, MetadataTable.NAME, MetadataSchema.TabletsSection.getRange(), fix);
        }
        return missing;
    }

    static int checkTable(ServerContext context, String tableName, boolean fix) throws Exception {
        if (tableName.equals(RootTable.NAME)) {
            throw new IllegalArgumentException("Can not check root table");
        }
        if (tableName.equals(MetadataTable.NAME)) {
            return RemoveEntriesForMissingFiles.checkTable(context, RootTable.NAME, MetadataSchema.TabletsSection.getRange(), fix);
        }
        TableId tableId = context.getTableId(tableName);
        Range range = new KeyExtent(tableId, null, null).toMetaRange();
        return RemoveEntriesForMissingFiles.checkTable(context, MetadataTable.NAME, range, fix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(RemoveEntriesForMissingFiles.class.getName(), args, new Object[0]);
        Span span = TraceUtil.startSpan(RemoveEntriesForMissingFiles.class, (String)"main");
        try (Scope scope = span.makeCurrent();){
            RemoveEntriesForMissingFiles.checkAllTables(opts.getServerContext(), opts.fix);
        }
        finally {
            span.end();
        }
    }

    private static class CheckFileTask
    implements Runnable {
        private final Map<Path, Path> cache;
        private final VolumeManager fs;
        private final AtomicInteger missing;
        private final BatchWriter writer;
        private final Key key;
        private final Path path;
        private final Set<Path> processing;
        private final AtomicReference<Exception> exceptionRef;

        CheckFileTask(Map<Path, Path> cache, VolumeManager fs, AtomicInteger missing, BatchWriter writer, Key key, Path map, Set<Path> processing, AtomicReference<Exception> exceptionRef) {
            this.cache = cache;
            this.fs = fs;
            this.missing = missing;
            this.writer = writer;
            this.key = key;
            this.path = map;
            this.processing = processing;
            this.exceptionRef = exceptionRef;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block20: {
                try {
                    if (this.fs.exists(this.path)) {
                        Set<Path> set = this.processing;
                        synchronized (set) {
                            this.cache.put(this.path, this.path);
                            break block20;
                        }
                    }
                    this.missing.incrementAndGet();
                    Object m = new Mutation(this.key.getRow());
                    m.putDelete(this.key.getColumnFamily(), this.key.getColumnQualifier());
                    if (this.writer != null) {
                        this.writer.addMutation(m);
                        System.out.println("Reference " + this.path + " removed from " + this.key.getRow());
                    } else {
                        System.out.println("File " + this.path + " is missing");
                    }
                }
                catch (Exception e) {
                    this.exceptionRef.compareAndSet(null, e);
                }
                finally {
                    Set<Path> set = this.processing;
                    synchronized (set) {
                        this.processing.remove(this.path);
                        this.processing.notify();
                    }
                }
            }
        }
    }

    static class Opts
    extends ServerUtilOpts {
        @Parameter(names={"--fix"})
        boolean fix = false;

        Opts() {
        }
    }
}

