/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.auto.service.AutoService;
import java.util.List;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={KeywordExecutable.class})
public class ZooZap
implements KeywordExecutable {
    private static final Logger log = LoggerFactory.getLogger(ZooZap.class);

    private static void message(String msg, Opts opts) {
        if (opts.verbose) {
            System.out.println(msg);
        }
    }

    public String keyword() {
        return "zoo-zap";
    }

    public String description() {
        return "Utility for zapping Zookeeper locks";
    }

    public static void main(String[] args) throws Exception {
        new ZooZap().execute(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String[] args) throws Exception {
        block29: {
            Opts opts = new Opts();
            opts.parseArgs(this.keyword(), args, new Object[0]);
            if (!(opts.zapMaster || opts.zapManager || opts.zapTservers)) {
                new JCommander((Object)opts).usage();
                return;
            }
            try {
                SiteConfiguration siteConf = SiteConfiguration.auto();
                if (siteConf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
                    SecurityUtil.serverLogin((AccumuloConfiguration)siteConf);
                }
                String volDir = (String)VolumeConfiguration.getVolumeUris((AccumuloConfiguration)siteConf).iterator().next();
                Path instanceDir = new Path(volDir, "instance_id");
                InstanceId iid = VolumeManager.getInstanceIDFromHdfs(instanceDir, new Configuration());
                ZooReaderWriter zoo = new ZooReaderWriter((AccumuloConfiguration)siteConf);
                if (opts.zapMaster) {
                    log.warn("The -master option is deprecated. Please use -manager instead.");
                }
                if (opts.zapManager || opts.zapMaster) {
                    String managerLockPath = "/accumulo/" + iid + "/managers/lock";
                    try {
                        ZooZap.zapDirectory(zoo, managerLockPath, opts);
                    }
                    catch (InterruptedException | KeeperException e) {
                        e.printStackTrace();
                    }
                }
                if (opts.zapTservers) {
                    String tserversPath = "/accumulo/" + iid + "/tservers";
                    try {
                        List children = zoo.getChildren(tserversPath);
                        for (String child : children) {
                            ZooZap.message("Deleting " + tserversPath + "/" + child + " from zookeeper", opts);
                            if (opts.zapManager || opts.zapMaster) {
                                zoo.recursiveDelete(tserversPath + "/" + child, ZooUtil.NodeMissingPolicy.SKIP);
                                continue;
                            }
                            ServiceLock.ServiceLockPath zLockPath = ServiceLock.path((String)(tserversPath + "/" + child));
                            if (zoo.getChildren(zLockPath.toString()).isEmpty() || ServiceLock.deleteLock((ZooReaderWriter)zoo, (ServiceLock.ServiceLockPath)zLockPath, (String)"tserver")) continue;
                            ZooZap.message("Did not delete " + tserversPath + "/" + child, opts);
                        }
                    }
                    catch (InterruptedException | KeeperException e) {
                        log.error("{}", (Object)e.getMessage(), (Object)e);
                    }
                }
                String path = siteConf.get(Property.TRACE_ZK_PATH);
                try {
                    ZooZap.zapDirectory(zoo, path, opts);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (opts.zapCoordinators) {
                    String coordinatorPath = "/accumulo/" + iid + "/coordinators/lock";
                    try {
                        if (zoo.exists(coordinatorPath)) {
                            ZooZap.zapDirectory(zoo, coordinatorPath, opts);
                        }
                    }
                    catch (InterruptedException | KeeperException e) {
                        log.error("Error deleting coordinator from zookeeper, {}", (Object)e.getMessage(), (Object)e);
                    }
                }
                if (opts.zapCompactors) {
                    String compactorsBasepath = "/accumulo/" + iid + "/compactors";
                    try {
                        if (zoo.exists(compactorsBasepath)) {
                            List queues = zoo.getChildren(compactorsBasepath);
                            for (String queue : queues) {
                                ZooZap.message("Deleting " + compactorsBasepath + "/" + queue + " from zookeeper", opts);
                                zoo.recursiveDelete(compactorsBasepath + "/" + queue, ZooUtil.NodeMissingPolicy.SKIP);
                            }
                        }
                    }
                    catch (InterruptedException | KeeperException e) {
                        log.error("Error deleting compactors from zookeeper, {}", (Object)e.getMessage(), (Object)e);
                    }
                }
                if (!opts.zapScanServers) break block29;
                String sserversPath = "/accumulo/" + iid + "/sservers";
                try {
                    if (zoo.exists(sserversPath)) {
                        List children = zoo.getChildren(sserversPath);
                        for (String child : children) {
                            ZooZap.message("Deleting " + sserversPath + "/" + child + " from zookeeper", opts);
                            ServiceLock.ServiceLockPath zLockPath = ServiceLock.path((String)(sserversPath + "/" + child));
                            if (zoo.getChildren(zLockPath.toString()).isEmpty()) continue;
                            ServiceLock.deleteLock((ZooReaderWriter)zoo, (ServiceLock.ServiceLockPath)zLockPath);
                        }
                    }
                }
                catch (InterruptedException | KeeperException e) {
                    log.error("{}", (Object)e.getMessage(), (Object)e);
                }
            }
            finally {
                SingletonManager.setMode((SingletonManager.Mode)SingletonManager.Mode.CLOSED);
            }
        }
    }

    private static void zapDirectory(ZooReaderWriter zoo, String path, Opts opts) throws KeeperException, InterruptedException {
        List children = zoo.getChildren(path);
        for (String child : children) {
            ZooZap.message("Deleting " + path + "/" + child + " from zookeeper", opts);
            zoo.recursiveDelete(path + "/" + child, ZooUtil.NodeMissingPolicy.SKIP);
        }
    }

    static class Opts
    extends Help {
        @Deprecated(since="2.1.0")
        @Parameter(names={"-master"}, description="remove master locks (deprecated -- user -manager instead")
        boolean zapMaster = false;
        @Parameter(names={"-manager"}, description="remove manager locks")
        boolean zapManager = false;
        @Parameter(names={"-tservers"}, description="remove tablet server locks")
        boolean zapTservers = false;
        @Parameter(names={"-compaction-coordinators"}, description="remove compaction coordinator locks")
        boolean zapCoordinators = false;
        @Parameter(names={"-compactors"}, description="remove compactor locks")
        boolean zapCompactors = false;
        @Parameter(names={"-sservers"}, description="remove scan server locks")
        boolean zapScanServers = false;
        @Parameter(names={"-verbose"}, description="print out messages about progress")
        boolean verbose = false;

        Opts() {
        }
    }
}

