/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util.serviceStatus;

import com.google.gson.Gson;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.server.util.serviceStatus.StatusSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceStatusReport {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceStatusReport.class);
    private static final Gson gson = new Gson();
    private static final DateTimeFormatter rptTimeFmt = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final String I2 = "  ";
    private static final String I4 = "    ";
    private static final String I6 = "      ";
    private final String reportTime = rptTimeFmt.format(ZonedDateTime.now(ZoneId.of("UTC")));
    private final int zkReadErrors;
    private final boolean noHosts;
    private final Map<ReportKey, StatusSummary> summaries;

    public ServiceStatusReport(Map<ReportKey, StatusSummary> summaries, boolean noHosts) {
        this.zkReadErrors = summaries.values().stream().map(StatusSummary::getErrorCount).reduce(Integer::sum).orElse(0);
        this.noHosts = noHosts;
        this.summaries = summaries;
    }

    public String getReportTime() {
        return this.reportTime;
    }

    public int getTotalZkReadErrors() {
        return this.zkReadErrors;
    }

    public Map<ReportKey, StatusSummary> getSummaries() {
        return this.summaries;
    }

    public String toJson() {
        return gson.toJson((Object)this, ServiceStatusReport.class);
    }

    public static ServiceStatusReport fromJson(String json) {
        return (ServiceStatusReport)gson.fromJson(json, ServiceStatusReport.class);
    }

    public String report(StringBuilder sb) {
        sb.append("Report time: ").append(rptTimeFmt.format(ZonedDateTime.now(ZoneId.of("UTC")))).append("\n");
        int zkErrors = this.summaries.values().stream().map(StatusSummary::getErrorCount).reduce(Integer::sum).orElse(0);
        sb.append("ZooKeeper read errors: ").append(zkErrors).append("\n");
        this.fmtServiceStatus(sb, ReportKey.MANAGER, this.summaries.get((Object)ReportKey.MANAGER), this.noHosts);
        this.fmtServiceStatus(sb, ReportKey.MONITOR, this.summaries.get((Object)ReportKey.MONITOR), this.noHosts);
        this.fmtServiceStatus(sb, ReportKey.GC, this.summaries.get((Object)ReportKey.GC), this.noHosts);
        this.fmtServiceStatus(sb, ReportKey.T_SERVER, this.summaries.get((Object)ReportKey.T_SERVER), this.noHosts);
        this.fmtResourceGroups(sb, ReportKey.S_SERVER, this.summaries.get((Object)ReportKey.S_SERVER), this.noHosts);
        this.fmtServiceStatus(sb, ReportKey.COORDINATOR, this.summaries.get((Object)ReportKey.COORDINATOR), this.noHosts);
        this.fmtResourceGroups(sb, ReportKey.COMPACTOR, this.summaries.get((Object)ReportKey.COMPACTOR), this.noHosts);
        sb.append("\n");
        LOG.trace("fmtStatus - with hosts: {}", this.summaries);
        return sb.toString();
    }

    private void fmtServiceStatus(StringBuilder sb, ReportKey displayNames, StatusSummary summary, boolean noHosts) {
        if (summary == null) {
            sb.append((Object)displayNames).append(": unavailable").append("\n");
            return;
        }
        this.fmtCounts(sb, summary);
        if (noHosts) {
            return;
        }
        if (summary.getServiceCount() > 0) {
            Map<String, Set<String>> hosts = summary.getServiceByGroups();
            hosts.values().forEach(s -> s.forEach(h -> sb.append(I2).append((String)h).append("\n")));
        }
    }

    private void fmtCounts(StringBuilder sb, StatusSummary summary) {
        sb.append(summary.getDisplayName()).append(": count: ").append(summary.getServiceCount());
        if (summary.getErrorCount() > 0) {
            sb.append(", (ZooKeeper errors: ").append(summary.getErrorCount()).append(")\n");
        } else {
            sb.append("\n");
        }
    }

    private void fmtResourceGroups(StringBuilder sb, ReportKey reportKey, StatusSummary summary, boolean noHosts) {
        if (summary == null) {
            sb.append((Object)reportKey).append(": unavailable").append("\n");
            return;
        }
        this.fmtCounts(sb, summary);
        if (noHosts) {
            return;
        }
        if (!summary.getResourceGroups().isEmpty()) {
            sb.append(I2).append("resource groups:\n");
            summary.getResourceGroups().forEach(g -> sb.append(I4).append((String)g).append("\n"));
            if (summary.getServiceCount() > 0) {
                sb.append(I2).append("hosts (by group):\n");
                Map<String, Set<String>> groups = summary.getServiceByGroups();
                groups.forEach((g, h) -> {
                    sb.append(I4).append((String)g).append(" (").append(h.size()).append(")").append(":\n");
                    h.forEach(n -> sb.append(I6).append((String)n).append("\n"));
                });
            }
        }
    }

    public String toString() {
        return "ServiceStatusReport{reportTime='" + this.reportTime + "', zkReadErrors=" + this.zkReadErrors + ", noHosts=" + this.noHosts + ", status=" + this.summaries + "}";
    }

    public static enum ReportKey {
        COMPACTOR("Compactors"),
        COORDINATOR("Coordinators"),
        GC("Garbage Collectors"),
        MANAGER("Managers"),
        MONITOR("Monitors"),
        S_SERVER("Scan Servers"),
        T_SERVER("Tablet Servers");

        private final String displayName;

        private ReportKey(String name) {
            this.displayName = name;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

