/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import java.util.Map;
import java.util.function.Predicate;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.ZooBasedConfiguration;
import org.apache.accumulo.server.conf.store.NamespacePropKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceConfiguration
extends ZooBasedConfiguration {
    private static final Logger log = LoggerFactory.getLogger(NamespaceConfiguration.class);
    protected ServerContext context;

    public NamespaceConfiguration(ServerContext context, NamespaceId namespaceId, AccumuloConfiguration parent) {
        super(log, context, NamespacePropKey.of(context, namespaceId), parent);
    }

    @Override
    public String get(Property property) {
        String key = property.getKey();
        Object namespaceId = this.getPropStoreKey().getId();
        if (namespaceId != null && namespaceId.equals((Object)Namespace.ACCUMULO.id()) && NamespaceConfiguration.isIteratorOrConstraint(key)) {
            return null;
        }
        Map<String, String> theseProps = this.getSnapshot();
        String value = theseProps.get(key);
        if (value != null) {
            return value;
        }
        return this.getParent().get(property);
    }

    @Override
    public void getProperties(Map<String, String> props, Predicate<String> filter) {
        Predicate<String> parentFilter = filter;
        if (this.getNamespaceId().equals((Object)Namespace.ACCUMULO.id())) {
            parentFilter = key -> !NamespaceConfiguration.isIteratorOrConstraint(key) && filter.test((String)key);
        }
        this.getParent().getProperties(props, parentFilter);
        this.getSnapshot().entrySet().stream().filter(e -> filter.test((String)e.getKey()) && e.getValue() != null).forEach(e -> props.put((String)e.getKey(), (String)e.getValue()));
    }

    protected NamespaceId getNamespaceId() {
        NamespaceId id = (NamespaceId)this.getPropStoreKey().getId();
        if (id == null) {
            throw new IllegalArgumentException("Invalid request for namespace id on " + this.getPropStoreKey());
        }
        return id;
    }

    static boolean isIteratorOrConstraint(String key) {
        return key.startsWith(Property.TABLE_ITERATOR_PREFIX.getKey()) || key.startsWith(Property.TABLE_CONSTRAINT_PREFIX.getKey());
    }
}

