/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf.store.impl;

import java.util.Set;
import org.apache.accumulo.server.conf.store.PropChangeListener;
import org.apache.accumulo.server.conf.store.PropStoreKey;

public abstract class PropStoreEventTask
implements Runnable {
    private final PropStoreKey<?> propStoreKey;
    private final Set<PropChangeListener> listeners;

    private PropStoreEventTask(Set<PropChangeListener> listeners) {
        this.propStoreKey = null;
        this.listeners = listeners;
    }

    private PropStoreEventTask(PropStoreKey<?> propStoreKey, Set<PropChangeListener> listeners) {
        this.propStoreKey = propStoreKey;
        this.listeners = listeners;
    }

    public static class PropStoreConnectionEventTask
    extends PropStoreEventTask {
        PropStoreConnectionEventTask(Set<PropChangeListener> listeners) {
            super(listeners);
        }

        @Override
        public void run() {
            this.listeners.forEach(PropChangeListener::connectionEvent);
        }
    }

    public static class PropStoreDeleteEventTask
    extends PropStoreEventTask {
        PropStoreDeleteEventTask(PropStoreKey<?> propStoreKey, Set<PropChangeListener> listeners) {
            super(propStoreKey, listeners);
        }

        @Override
        public void run() {
            this.listeners.forEach(listener -> listener.deleteEvent(this.propStoreKey));
        }
    }

    public static class PropStoreCacheChangeEventTask
    extends PropStoreEventTask {
        PropStoreCacheChangeEventTask(PropStoreKey<?> propStoreKey, Set<PropChangeListener> listeners) {
            super(propStoreKey, listeners);
        }

        @Override
        public void run() {
            this.listeners.forEach(listener -> listener.cacheChangeEvent(this.propStoreKey));
        }
    }

    public static class PropStoreZkChangeEventTask
    extends PropStoreEventTask {
        PropStoreZkChangeEventTask(PropStoreKey<?> propStoreKey, Set<PropChangeListener> listeners) {
            super(propStoreKey, listeners);
        }

        @Override
        public void run() {
            this.listeners.forEach(listener -> listener.zkChangeEvent(this.propStoreKey));
        }
    }
}

