/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.manager.balancer;

import com.google.common.net.HostAndPort;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.dataImpl.TabletIdImpl;
import org.apache.accumulo.core.manager.balancer.TabletServerIdImpl;
import org.apache.accumulo.core.manager.balancer.TabletStatisticsImpl;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.spi.balancer.BalancerEnvironment;
import org.apache.accumulo.core.spi.balancer.data.TabletServerId;
import org.apache.accumulo.core.spi.balancer.data.TabletStatistics;
import org.apache.accumulo.core.tabletserver.thrift.TabletServerClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServiceEnvironmentImpl;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalancerEnvironmentImpl
extends ServiceEnvironmentImpl
implements BalancerEnvironment {
    private static final Logger log = LoggerFactory.getLogger(BalancerEnvironmentImpl.class);

    public BalancerEnvironmentImpl(ServerContext context) {
        super(context);
    }

    public Map<String, TableId> getTableIdMap() {
        return this.getContext().getTableNameToIdMap();
    }

    public boolean isTableOnline(TableId tableId) {
        return TableState.ONLINE.equals((Object)this.getContext().getTableState(tableId));
    }

    public Map<TabletId, TabletServerId> listTabletLocations(TableId tableId) {
        LinkedHashMap<TabletId, TabletServerId> tablets = new LinkedHashMap<TabletId, TabletServerId>();
        for (TabletMetadata tm : TabletsMetadata.builder((AccumuloClient)this.getContext()).forTable(tableId).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.LOCATION, TabletMetadata.ColumnType.PREV_ROW}).build()) {
            tablets.put((TabletId)new TabletIdImpl(tm.getExtent()), (TabletServerId)TabletServerIdImpl.fromThrift((TServerInstance)Optional.ofNullable(tm.getLocation()).map(TabletMetadata.Location::getServerInstance).orElse(null)));
        }
        return tablets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<TabletStatistics> listOnlineTabletsForTable(TabletServerId tabletServerId, TableId tableId) throws AccumuloException, AccumuloSecurityException {
        log.debug("Scanning tablet server {} for table {}", (Object)tabletServerId, (Object)tableId);
        try {
            TabletServerClientService.Client client = (TabletServerClientService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (HostAndPort)HostAndPort.fromParts((String)tabletServerId.getHost(), (int)tabletServerId.getPort()), (ClientContext)this.getContext());
            try {
                List<TabletStatistics> list = client.getTabletStats(TraceUtil.traceInfo(), this.getContext().rpcCreds(), tableId.canonical()).stream().map(TabletStatisticsImpl::new).collect(Collectors.toList());
                return list;
            }
            catch (TTransportException e) {
                log.error("Unable to connect to {}: ", (Object)tabletServerId, (Object)e);
                return null;
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client, (ClientContext)this.getContext());
            }
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e);
        }
        catch (TException e) {
            throw new AccumuloException((Throwable)e);
        }
    }

    public String tableContext(TableId tableId) {
        return ClassLoaderUtil.tableContext((AccumuloConfiguration)this.getContext().getTableConfiguration(tableId));
    }
}

