/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.manager.state;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletLocationState;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.server.manager.state.Assignment;
import org.apache.accumulo.server.manager.state.ClosableIterator;
import org.apache.accumulo.server.manager.state.CurrentState;
import org.apache.accumulo.server.manager.state.DistributedStoreException;
import org.apache.accumulo.server.manager.state.MetaDataTableScanner;
import org.apache.accumulo.server.manager.state.TabletStateStore;
import org.apache.accumulo.server.util.ManagerMetadataUtil;
import org.apache.hadoop.fs.Path;

class MetaDataStateStore
implements TabletStateStore {
    protected final ClientContext context;
    protected final CurrentState state;
    private final String targetTableName;
    private final Ample ample;
    private final Ample.DataLevel level;

    protected MetaDataStateStore(Ample.DataLevel level, ClientContext context, CurrentState state, String targetTableName) {
        this.level = level;
        this.context = context;
        this.state = state;
        this.ample = context.getAmple();
        this.targetTableName = targetTableName;
    }

    MetaDataStateStore(Ample.DataLevel level, ClientContext context, CurrentState state) {
        this(level, context, state, MetadataTable.NAME);
    }

    @Override
    public Ample.DataLevel getLevel() {
        return this.level;
    }

    @Override
    public ClosableIterator<TabletLocationState> iterator() {
        return new MetaDataTableScanner(this.context, MetadataSchema.TabletsSection.getRange(), this.state, this.targetTableName);
    }

    @Override
    public void setLocations(Collection<Assignment> assignments) throws DistributedStoreException {
        try (Ample.TabletsMutator tabletsMutator = this.ample.mutateTablets();){
            for (Assignment assignment : assignments) {
                Ample.TabletMutator tabletMutator = tabletsMutator.mutateTablet(assignment.tablet);
                tabletMutator.putLocation(TabletMetadata.Location.current((TServerInstance)assignment.server));
                ManagerMetadataUtil.updateLastForAssignmentMode(this.context, tabletMutator, assignment.server, assignment.lastLocation);
                tabletMutator.deleteLocation(TabletMetadata.Location.future((TServerInstance)assignment.server));
                tabletMutator.deleteSuspension();
                tabletMutator.mutate();
            }
        }
        catch (RuntimeException ex) {
            throw new DistributedStoreException(ex);
        }
    }

    @Override
    public void setFutureLocations(Collection<Assignment> assignments) throws DistributedStoreException {
        try (Ample.TabletsMutator tabletsMutator = this.ample.mutateTablets();){
            for (Assignment assignment : assignments) {
                tabletsMutator.mutateTablet(assignment.tablet).deleteSuspension().putLocation(TabletMetadata.Location.future((TServerInstance)assignment.server)).mutate();
            }
        }
        catch (RuntimeException ex) {
            throw new DistributedStoreException(ex);
        }
    }

    @Override
    public void unassign(Collection<TabletLocationState> tablets, Map<TServerInstance, List<Path>> logsForDeadServers) throws DistributedStoreException {
        this.unassign(tablets, logsForDeadServers, -1L);
    }

    @Override
    public void suspend(Collection<TabletLocationState> tablets, Map<TServerInstance, List<Path>> logsForDeadServers, long suspensionTimestamp) throws DistributedStoreException {
        this.unassign(tablets, logsForDeadServers, suspensionTimestamp);
    }

    private void unassign(Collection<TabletLocationState> tablets, Map<TServerInstance, List<Path>> logsForDeadServers, long suspensionTimestamp) throws DistributedStoreException {
        try (Ample.TabletsMutator tabletsMutator = this.ample.mutateTablets();){
            for (TabletLocationState tls : tablets) {
                Ample.TabletMutator tabletMutator = tabletsMutator.mutateTablet(tls.extent);
                if (tls.current != null) {
                    List<Path> logs;
                    ManagerMetadataUtil.updateLastForAssignmentMode(this.context, tabletMutator, tls.current.getServerInstance(), tls.last);
                    tabletMutator.deleteLocation(tls.current);
                    if (logsForDeadServers != null && (logs = logsForDeadServers.get(tls.current.getServerInstance())) != null) {
                        for (Path log : logs) {
                            LogEntry entry = new LogEntry(tls.extent, 0L, log.toString());
                            tabletMutator.putWal(entry);
                        }
                    }
                    if (suspensionTimestamp >= 0L) {
                        tabletMutator.putSuspension(tls.current.getServerInstance(), suspensionTimestamp);
                    }
                }
                if (tls.suspend != null && suspensionTimestamp < 0L) {
                    tabletMutator.deleteSuspension();
                }
                if (tls.hasFuture()) {
                    tabletMutator.deleteLocation(tls.future);
                }
                tabletMutator.mutate();
            }
        }
        catch (RuntimeException ex) {
            throw new DistributedStoreException(ex);
        }
    }

    @Override
    public void unsuspend(Collection<TabletLocationState> tablets) throws DistributedStoreException {
        try (Ample.TabletsMutator tabletsMutator = this.ample.mutateTablets();){
            for (TabletLocationState tls : tablets) {
                if (tls.suspend != null) continue;
                tabletsMutator.mutateTablet(tls.extent).deleteSuspension().mutate();
            }
        }
        catch (RuntimeException ex) {
            throw new DistributedStoreException(ex);
        }
    }

    @Override
    public String name() {
        return "Normal Tablets";
    }
}

