/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.metadata;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.util.LazySingletons;
import org.apache.hadoop.fs.Path;

public class RootGcCandidates {
    private static final int VERSION = 1;
    private final Data data;

    public RootGcCandidates() {
        this.data = new Data(1, new TreeMap<String, SortedSet<String>>());
    }

    public RootGcCandidates(String jsonString) {
        this.data = (Data)((Gson)LazySingletons.GSON.get()).fromJson(jsonString, Data.class);
        Preconditions.checkArgument((this.data.version == 1 ? 1 : 0) != 0, (String)"Invalid Root Table GC Candidates JSON version %s", (int)this.data.version);
        this.data.candidates.forEach((parent, files) -> {
            Preconditions.checkArgument((!parent.isBlank() ? 1 : 0) != 0, (String)"Blank parent dir in %s", this.data.candidates);
            Preconditions.checkArgument((!files.isEmpty() ? 1 : 0) != 0, (String)"Empty files for dir %s", (Object)parent);
        });
    }

    public void add(Stream<StoredTabletFile> refs) {
        refs.forEach(ref -> this.data.candidates.computeIfAbsent(ref.getPath().getParent().toString(), k -> new TreeSet()).add(ref.getFileName()));
    }

    public void remove(Stream<String> refs) {
        refs.map(Path::new).forEach(path -> this.data.candidates.computeIfPresent(path.getParent().toString(), (key, values) -> {
            values.remove(path.getName());
            return values.isEmpty() ? null : values;
        }));
    }

    public Stream<String> sortedStream() {
        return this.data.candidates.entrySet().stream().flatMap(entry -> {
            String parent = (String)entry.getKey();
            SortedSet names = (SortedSet)entry.getValue();
            return names.stream().map(name -> new Path(parent, name));
        }).map(Path::toString).sorted();
    }

    public String toJson() {
        return ((Gson)LazySingletons.GSON.get()).toJson((Object)this.data);
    }

    private static class Data {
        private final int version;
        private final SortedMap<String, SortedSet<String>> candidates;

        public Data(int version, SortedMap<String, SortedSet<String>> candidates) {
            this.version = version;
            this.candidates = candidates;
        }
    }
}

