/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.util.Iterator;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.hadoop.fs.Path;

public class ListVolumesUsed {
    public static void main(String[] args) throws Exception {
        ListVolumesUsed.listVolumes(new ServerContext(SiteConfiguration.auto()));
    }

    private static String getTableURI(String rootTabletDir) {
        Path ret = VolumeManager.FileType.TABLE.getVolume(new Path(rootTabletDir));
        if (ret == null) {
            return "RELATIVE";
        }
        return ret.toString();
    }

    private static String getLogURI(String logEntry) {
        Path ret = VolumeManager.FileType.WAL.getVolume(new Path(logEntry));
        if (ret == null) {
            return "RELATIVE";
        }
        return ret.toString();
    }

    private static void getLogURIs(TreeSet<String> volumes, LogEntry logEntry) {
        volumes.add(ListVolumesUsed.getLogURI(logEntry.filename));
    }

    private static void listTable(Ample.DataLevel level, ServerContext context) throws Exception {
        System.out.println("Listing volumes referenced in " + level + " tablets section");
        TreeSet<String> volumes = new TreeSet<String>();
        try (TabletsMetadata tablets = TabletsMetadata.builder((AccumuloClient)context).forLevel(level).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.FILES, TabletMetadata.ColumnType.LOGS}).build();){
            Iterator iterator = tablets.iterator();
            while (iterator.hasNext()) {
                TabletMetadata tabletMetadata = (TabletMetadata)iterator.next();
                tabletMetadata.getFiles().forEach(file -> volumes.add(ListVolumesUsed.getTableURI(file.getNormalizedPathStr())));
                tabletMetadata.getLogs().forEach(le -> ListVolumesUsed.getLogURIs(volumes, le));
            }
        }
        for (String string : volumes) {
            System.out.println("\tVolume : " + string);
        }
        System.out.println("Listing volumes referenced in " + level + " deletes section (volume replacement occurs at deletion time)");
        volumes.clear();
        Iterator delPaths = context.getAmple().getGcCandidates(level);
        while (delPaths.hasNext()) {
            volumes.add(ListVolumesUsed.getTableURI((String)delPaths.next()));
        }
        for (String volume : volumes) {
            System.out.println("\tVolume : " + volume);
        }
        System.out.println("Listing volumes referenced in " + level + " current logs");
        volumes.clear();
        WalStateManager walStateManager = new WalStateManager(context);
        for (Path path : walStateManager.getAllState().keySet()) {
            volumes.add(ListVolumesUsed.getLogURI(path.toString()));
        }
        for (String volume : volumes) {
            System.out.println("\tVolume : " + volume);
        }
    }

    public static void listVolumes(ServerContext context) throws Exception {
        ListVolumesUsed.listTable(Ample.DataLevel.ROOT, context);
        System.out.println();
        ListVolumesUsed.listTable(Ample.DataLevel.METADATA, context);
        System.out.println();
        ListVolumesUsed.listTable(Ample.DataLevel.USER, context);
    }
}

