/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.cli.ServerUtilOpts;

public class ScanServerMetadataEntries {
    public static void clean(ServerContext context) {
        HashSet uuidsToDelete = new HashSet();
        context.getAmple().getScanServerFileReferences().forEach(ssrtf -> uuidsToDelete.add(UUID.fromString(ssrtf.getServerLockUUID().toString())));
        Set scanServerUuids = context.getScanServers().values().stream().map(ssi -> (UUID)ssi.getFirst()).collect(Collectors.toSet());
        uuidsToDelete.removeAll(scanServerUuids);
        if (!uuidsToDelete.isEmpty()) {
            HashSet refsToDelete = new HashSet();
            context.getAmple().getScanServerFileReferences().forEach(ssrtf -> {
                UUID uuid = UUID.fromString(ssrtf.getServerLockUUID().toString());
                if (uuidsToDelete.contains(uuid)) {
                    refsToDelete.add(ssrtf);
                    if (refsToDelete.size() > 5000) {
                        context.getAmple().deleteScanServerFileReferences((Collection)refsToDelete);
                        refsToDelete.clear();
                    }
                }
            });
            context.getAmple().deleteScanServerFileReferences(refsToDelete);
        }
    }

    public static void main(String[] args) {
        ServerUtilOpts opts = new ServerUtilOpts();
        opts.parseArgs(ScanServerMetadataEntries.class.getName(), args, new Object[0]);
        ServerContext context = opts.getServerContext();
        ScanServerMetadataEntries.clean(context);
    }
}

