/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.start.classloader.vfs;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.start.classloader.vfs.AccumuloReloadingVFSClassLoader;
import org.apache.accumulo.start.classloader.vfs.ReloadingClassLoader;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;

public class ContextManager {
    private Map<String, Context> contexts = new HashMap<String, Context>();
    private volatile ContextsConfig config;
    private FileSystemManager vfs;
    private ReloadingClassLoader parent;

    ContextManager(FileSystemManager vfs, ReloadingClassLoader parent) {
        this.vfs = vfs;
        this.parent = parent;
    }

    public synchronized void setContextConfig(ContextsConfig config) {
        if (this.config != null) {
            throw new IllegalStateException("Context manager config already set");
        }
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader(String contextName) throws FileSystemException {
        ClassLoader loader;
        ContextConfig cconfig = this.config.getContextConfig(contextName);
        if (cconfig == null) {
            throw new IllegalArgumentException("Unknown context " + contextName);
        }
        Context context = null;
        Context contextToClose = null;
        ContextManager contextManager = this;
        synchronized (contextManager) {
            context = this.contexts.get(contextName);
            if (context == null) {
                context = new Context(cconfig);
                this.contexts.put(contextName, context);
            } else if (!context.cconfig.equals(cconfig)) {
                contextToClose = context;
                context = new Context(cconfig);
                this.contexts.put(contextName, context);
            }
        }
        if (contextToClose != null) {
            contextToClose.close();
        }
        if ((loader = context.getClassLoader()) == null) {
            return this.getClassLoader(contextName);
        }
        return loader;
    }

    public <U> Class<? extends U> loadClass(String context, String classname, Class<U> extension) throws ClassNotFoundException {
        try {
            return this.getClassLoader(context).loadClass(classname).asSubclass(extension);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("IO Error loading class " + classname, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnusedContexts(Set<String> configuredContexts) {
        HashMap<String, Context> unused;
        ContextManager contextManager = this;
        synchronized (contextManager) {
            unused = new HashMap<String, Context>(this.contexts);
            unused.keySet().removeAll(configuredContexts);
            this.contexts.keySet().removeAll(unused.keySet());
        }
        for (Context context : unused.values()) {
            context.close();
        }
    }

    public static class DefaultContextsConfig
    implements ContextsConfig {
        private Iterable<Map.Entry<String, String>> config;

        public DefaultContextsConfig(Iterable<Map.Entry<String, String>> config) {
            this.config = config;
        }

        @Override
        public ContextConfig getContextConfig(String context) {
            String key = "general.vfs.context.classpath." + context;
            String uris = null;
            boolean preDelegate = true;
            for (Map.Entry<String, String> entry : this.config) {
                if (entry.getKey().equals(key)) {
                    uris = entry.getValue();
                }
                if (!entry.getKey().equals(key + ".delegation") || !entry.getValue().trim().equalsIgnoreCase("post")) continue;
                preDelegate = false;
            }
            if (uris != null) {
                return new ContextConfig(uris, preDelegate);
            }
            return null;
        }
    }

    public static interface ContextsConfig {
        public ContextConfig getContextConfig(String var1);
    }

    public static class ContextConfig {
        String uris;
        boolean preDelegation;

        public ContextConfig(String uris, boolean preDelegation) {
            this.uris = uris;
            this.preDelegation = preDelegation;
        }

        public boolean equals(Object o) {
            if (o instanceof ContextConfig) {
                ContextConfig oc = (ContextConfig)o;
                return this.uris.equals(oc.uris) && this.preDelegation == oc.preDelegation;
            }
            return false;
        }

        public int hashCode() {
            return this.uris.hashCode() + (this.preDelegation ? Boolean.TRUE : Boolean.FALSE).hashCode();
        }
    }

    private class Context {
        AccumuloReloadingVFSClassLoader loader;
        ContextConfig cconfig;
        boolean closed = false;

        Context(ContextConfig cconfig) {
            this.cconfig = cconfig;
        }

        synchronized ClassLoader getClassLoader() throws FileSystemException {
            if (this.closed) {
                return null;
            }
            if (this.loader == null) {
                this.loader = new AccumuloReloadingVFSClassLoader(this.cconfig.uris, ContextManager.this.vfs, ContextManager.this.parent, this.cconfig.preDelegation);
            }
            return this.loader.getClassLoader();
        }

        synchronized void close() {
            this.closed = true;
            if (this.loader != null) {
                this.loader.close();
            }
            this.loader = null;
        }
    }
}

