/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.start.classloader.vfs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.accumulo.start.classloader.vfs.PostDelegatingVFSClassLoader;
import org.apache.accumulo.start.classloader.vfs.ReloadingClassLoader;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.impl.DefaultFileMonitor;
import org.apache.commons.vfs2.impl.VFSClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AccumuloReloadingVFSClassLoader
implements FileListener,
ReloadingClassLoader {
    private static final Logger log = LoggerFactory.getLogger(AccumuloReloadingVFSClassLoader.class);
    private static final long DEFAULT_TIMEOUT = TimeUnit.MINUTES.toMillis(5L);
    private volatile long maxWaitInterval = 60000L;
    private volatile long maxRetries = -1L;
    private volatile long sleepInterval = 5000L;
    private FileObject[] files;
    private VFSClassLoader cl;
    private final ReloadingClassLoader parent;
    private final String uris;
    private final DefaultFileMonitor monitor;
    private final boolean preDelegate;
    private final ThreadPoolExecutor executor;
    private final Runnable refresher;

    public String stringify(FileObject[] files) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        String delim = "";
        for (FileObject file : files) {
            sb.append(delim);
            delim = ", ";
            sb.append(file.getName());
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public synchronized ClassLoader getClassLoader() {
        if (this.cl.getParent() != this.parent.getClassLoader()) {
            this.scheduleRefresh();
        }
        return this.cl;
    }

    private void scheduleRefresh() {
        try {
            this.executor.execute(this.refresher);
        }
        catch (RejectedExecutionException e) {
            log.trace("Ignoring refresh request (already refreshing)");
        }
    }

    private synchronized void updateClassloader(FileObject[] files, VFSClassLoader cl) {
        this.files = files;
        this.cl = cl;
    }

    public AccumuloReloadingVFSClassLoader(String uris, FileSystemManager vfs, ReloadingClassLoader parent, long monitorDelay, boolean preDelegate) throws FileSystemException {
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(2);
        ThreadFactory factory = r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        };
        this.executor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.SECONDS, queue, factory);
        this.refresher = new Runnable(){

            @Override
            public void run() {
                while (!AccumuloReloadingVFSClassLoader.this.executor.isTerminating()) {
                    try {
                        FileSystemManager vfs = AccumuloVFSClassLoader.generateVfs();
                        FileObject[] files = AccumuloVFSClassLoader.resolve(vfs, AccumuloReloadingVFSClassLoader.this.uris);
                        long retries = 0L;
                        long currentSleepMillis = AccumuloReloadingVFSClassLoader.this.sleepInterval;
                        if (files.length == 0) {
                            while (files.length == 0 && AccumuloReloadingVFSClassLoader.this.retryPermitted(retries)) {
                                try {
                                    log.debug("VFS path was empty.  Waiting " + currentSleepMillis + " ms to retry");
                                    Thread.sleep(currentSleepMillis);
                                    files = AccumuloVFSClassLoader.resolve(vfs, AccumuloReloadingVFSClassLoader.this.uris);
                                    ++retries;
                                    currentSleepMillis = Math.min(AccumuloReloadingVFSClassLoader.this.maxWaitInterval, currentSleepMillis + AccumuloReloadingVFSClassLoader.this.sleepInterval);
                                }
                                catch (InterruptedException e) {
                                    log.error("VFS Retry Interrupted", (Throwable)e);
                                    throw new RuntimeException(e);
                                }
                            }
                            AccumuloReloadingVFSClassLoader.forEachCatchRTEs(Arrays.stream(files), o -> {
                                AccumuloReloadingVFSClassLoader.this.addFileToMonitor((FileObject)o);
                                log.debug("monitoring {}", o);
                            });
                        }
                        log.debug("Rebuilding dynamic classloader using files- {}", (Object)AccumuloReloadingVFSClassLoader.this.stringify(files));
                        Object cl = AccumuloReloadingVFSClassLoader.this.preDelegate ? new VFSClassLoader(files, vfs, AccumuloReloadingVFSClassLoader.this.parent.getClassLoader()) : new PostDelegatingVFSClassLoader(files, vfs, AccumuloReloadingVFSClassLoader.this.parent.getClassLoader());
                        AccumuloReloadingVFSClassLoader.this.updateClassloader(files, (VFSClassLoader)cl);
                        return;
                    }
                    catch (Exception e) {
                        log.error("{}", (Object)e.getMessage(), (Object)e);
                        try {
                            Thread.sleep(DEFAULT_TIMEOUT);
                        }
                        catch (InterruptedException ie) {
                            log.error("{}", (Object)ie.getMessage(), (Object)ie);
                        }
                    }
                }
            }
        };
        this.uris = uris;
        this.parent = parent;
        this.preDelegate = preDelegate;
        ArrayList<FileObject> pathsToMonitor = new ArrayList<FileObject>();
        this.files = AccumuloVFSClassLoader.resolve(vfs, uris, pathsToMonitor);
        this.cl = preDelegate ? new VFSClassLoader(this.files, vfs, parent.getClassLoader()){

            public String getName() {
                return "AccumuloReloadingVFSClassLoader (loads everything defined by general.dynamic.classpaths)";
            }
        } : new PostDelegatingVFSClassLoader(this.files, vfs, parent.getClassLoader()){

            public String getName() {
                return "AccumuloReloadingVFSClassLoader (loads everything defined by general.dynamic.classpaths)";
            }
        };
        this.monitor = new DefaultFileMonitor((FileListener)this);
        this.monitor.setDelay(monitorDelay);
        this.monitor.setRecursive(false);
        AccumuloReloadingVFSClassLoader.forEachCatchRTEs(pathsToMonitor.stream(), o -> {
            this.addFileToMonitor((FileObject)o);
            log.debug("monitoring {}", o);
        });
        this.monitor.start();
    }

    private void addFileToMonitor(FileObject file) throws RuntimeException {
        try {
            if (this.monitor != null) {
                this.monitor.addFile(file);
            }
        }
        catch (RuntimeException re) {
            if (re.getMessage().contains("files-cache")) {
                log.error("files-cache error adding {} to VFS monitor. There is no implementation for files-cache in VFS2", (Object)file, (Object)re);
            } else {
                log.error("Runtime error adding {} to VFS monitor", (Object)file, (Object)re);
            }
            throw re;
        }
    }

    private void removeFile(FileObject file) throws RuntimeException {
        try {
            if (this.monitor != null) {
                this.monitor.removeFile(file);
            }
        }
        catch (RuntimeException re) {
            log.error("Error removing file from VFS cache {}", (Object)file, (Object)re);
            throw re;
        }
    }

    public static <T> void forEachCatchRTEs(Stream<T> stream, Consumer<T> consumer) {
        stream.flatMap(o -> {
            try {
                consumer.accept(o);
                return null;
            }
            catch (RuntimeException e) {
                return Stream.of(e);
            }
        }).reduce((e1, e2) -> {
            e1.addSuppressed((Throwable)e2);
            return e1;
        }).ifPresent(e -> {
            throw e;
        });
    }

    public AccumuloReloadingVFSClassLoader(String uris, FileSystemManager vfs, ReloadingClassLoader parent, boolean preDelegate) throws FileSystemException {
        this(uris, vfs, parent, DEFAULT_TIMEOUT, preDelegate);
    }

    public void close() {
        AccumuloReloadingVFSClassLoader.forEachCatchRTEs(Stream.of(this.files), o -> {
            this.removeFile((FileObject)o);
            log.debug("Removing file from monitoring {}", o);
        });
        this.executor.shutdownNow();
        this.monitor.stop();
    }

    public void fileCreated(FileChangeEvent event) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("{} created, recreating classloader", (Object)event.getFileObject().getURL());
        }
        this.scheduleRefresh();
    }

    public void fileDeleted(FileChangeEvent event) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("{} deleted, recreating classloader", (Object)event.getFileObject().getURL());
        }
        this.scheduleRefresh();
    }

    public void fileChanged(FileChangeEvent event) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("{} changed, recreating classloader", (Object)event.getFileObject().getURL());
        }
        this.scheduleRefresh();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (FileObject f : this.files) {
            try {
                buf.append("\t").append(f.getURL()).append("\n");
            }
            catch (FileSystemException e) {
                log.error("Error getting URL for file", (Throwable)e);
            }
        }
        return buf.toString();
    }

    void setMaxRetries(long maxRetries) {
        this.maxRetries = maxRetries;
    }

    private boolean retryPermitted(long retries) {
        return this.maxRetries < 0L || retries < this.maxRetries;
    }
}

