/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.harness;

import com.google.common.collect.MoreCollectors;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.harness.Timeout;
import org.apache.accumulo.harness.WithTestNames;
import org.apache.accumulo.test.util.Wait;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloITBase
extends WithTestNames {
    public static final SecureRandom random = new SecureRandom();
    private static final Logger log = LoggerFactory.getLogger(AccumuloITBase.class);
    public static final String STANDALONE_CAPABLE_CLUSTER = "StandaloneCapableCluster";
    public static final String SUNNY_DAY = "SunnyDay";
    public static final String MINI_CLUSTER_ONLY = "MiniClusterOnly";
    public static final String ZOOKEEPER_TESTING_SERVER = "ZooKeeperTestingServer";
    @RegisterExtension
    Timeout timeout = Timeout.from(() -> {
        Assertions.assertFalse((boolean)this.defaultTimeout().isZero(), (String)"defaultTimeout should not return 0");
        int timeoutFactor = Wait.getTimeoutFactor(e -> {
            log.warn("Could not parse timeout.factor, defaulting to 24 hours.");
            return 0;
        });
        if (timeoutFactor == 0) {
            return Duration.ofDays(1L);
        }
        return this.defaultTimeout().multipliedBy(timeoutFactor);
    });

    protected <T> T getOnlyElement(Collection<T> c) {
        return (T)c.stream().collect(MoreCollectors.onlyElement());
    }

    protected Map.Entry<Key, Value> getOnlyElement(Scanner s) {
        return (Map.Entry)s.stream().collect(MoreCollectors.onlyElement());
    }

    public String[] getUniqueNames(int num) {
        String[] names = new String[num];
        for (int i = 0; i < num; ++i) {
            names[i] = this.getClass().getSimpleName() + "_" + this.testName() + i;
        }
        return names;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="path provided by test")
    public static File getSslDir(File baseDir) {
        Assertions.assertTrue((baseDir.exists() && baseDir.isDirectory() ? 1 : 0) != 0);
        return new File(baseDir.getParentFile(), baseDir.getName() + "-ssl");
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="path provided by test")
    public static File createTestDir(String name) {
        File baseDir = new File(System.getProperty("user.dir") + "/target/mini-tests");
        Assertions.assertTrue((baseDir.mkdirs() || baseDir.isDirectory() ? 1 : 0) != 0);
        if (name == null) {
            return baseDir;
        }
        File testDir = new File(baseDir, name);
        FileUtils.deleteQuietly((File)testDir);
        Assertions.assertTrue((boolean)testDir.mkdir());
        return testDir;
    }

    protected Duration defaultTimeout() {
        return Duration.ofMinutes(10L);
    }

    @SuppressFBWarnings(value={"UI_INHERITANCE_UNSAFE_GETRESOURCE"}, justification="for testing")
    protected File initJar(String jarResourcePath, String namePrefix, String testDir) throws IOException {
        File testFileDir = new File(testDir);
        File jar = File.createTempFile(namePrefix, ".jar", testFileDir);
        URL url = this.getClass().getResource(jarResourcePath);
        if (url == null) {
            throw new IllegalStateException("Can't find the jar: " + jarResourcePath);
        }
        FileUtils.copyInputStreamToFile((InputStream)url.openStream(), (File)jar);
        jar.deleteOnExit();
        return jar;
    }
}

