/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.harness;

import java.io.File;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.cluster.ClusterUsers;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.harness.AccumuloITBase;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.MiniClusterHarness;
import org.apache.accumulo.harness.TestingKdc;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="MiniClusterOnly")
public abstract class SharedMiniClusterBase
extends AccumuloITBase
implements ClusterUsers {
    private static final Logger log = LoggerFactory.getLogger(SharedMiniClusterBase.class);
    public static final String TRUE = Boolean.toString(true);
    private static String rootPassword;
    private static AuthenticationToken token;
    private static MiniAccumuloClusterImpl cluster;
    private static TestingKdc krb;

    public static void startMiniCluster() throws Exception {
        SharedMiniClusterBase.startMiniClusterWithConfig(MiniClusterConfigurationCallback.NO_CALLBACK);
    }

    public static void startMiniClusterWithConfig(MiniClusterConfigurationCallback miniClusterCallback) throws Exception {
        File baseDir = new File(System.getProperty("user.dir") + "/target/mini-tests");
        Assertions.assertTrue((baseDir.mkdirs() || baseDir.isDirectory() ? 1 : 0) != 0);
        MiniClusterHarness harness = new MiniClusterHarness();
        if (TRUE.equals(System.getProperty("org.apache.accumulo.test.functional.useKrbForIT"))) {
            krb = new TestingKdc();
            krb.start();
            Configuration conf = new Configuration(false);
            conf.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)conf);
            ClusterUser rootUser = krb.getRootUser();
            UserGroupInformation.loginUserFromKeytab((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
            token = new KerberosToken();
        } else {
            rootPassword = "rootPasswordShared1";
            token = new PasswordToken((CharSequence)rootPassword);
        }
        cluster = harness.create(SharedMiniClusterBase.getTestClassName(), SharedMiniClusterBase.class.getSimpleName(), token, miniClusterCallback, krb);
        cluster.start();
    }

    private static String getTestClassName() {
        Predicate<Class> findITClass = c -> c.getSimpleName().endsWith("IT");
        Function<Stream, Optional> findCallerITClass = frames -> frames.map(StackWalker.StackFrame::getDeclaringClass).filter(findITClass).findFirst();
        Optional<String> callerClassName = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(findCallerITClass).map(Class::getName);
        return callerClassName.orElse(String.format("UnknownITClass-%d-%d", System.currentTimeMillis(), random.nextInt(Short.MAX_VALUE)));
    }

    public static void stopMiniCluster() {
        if (cluster != null) {
            try {
                cluster.stop();
            }
            catch (Exception e) {
                log.error("Failed to stop minicluster", (Throwable)e);
            }
        }
        if (krb != null) {
            try {
                krb.stop();
            }
            catch (Exception e) {
                log.error("Failed to stop KDC", (Throwable)e);
            }
        }
    }

    public static String getRootPassword() {
        return rootPassword;
    }

    public static AuthenticationToken getToken() {
        return ClientProperty.getAuthenticationToken((Properties)SharedMiniClusterBase.getClientProps());
    }

    public static String getPrincipal() {
        return ClientProperty.AUTH_PRINCIPAL.getValue(SharedMiniClusterBase.getClientProps());
    }

    public static MiniAccumuloClusterImpl getCluster() {
        return cluster;
    }

    public static File getMiniClusterDir() {
        return cluster.getConfig().getDir();
    }

    public static Properties getClientProps() {
        return SharedMiniClusterBase.getCluster().getClientProperties();
    }

    public static TestingKdc getKdc() {
        return krb;
    }

    public ClusterUser getAdminUser() {
        if (krb == null) {
            return new ClusterUser(SharedMiniClusterBase.getPrincipal(), SharedMiniClusterBase.getRootPassword());
        }
        return krb.getRootUser();
    }

    public ClusterUser getUser(int offset) {
        if (krb == null) {
            String user = SharedMiniClusterBase.class.getName() + "_" + this.testName() + "_" + offset;
            return new ClusterUser(user, user);
        }
        return krb.getClientPrincipal(offset);
    }

    public static ClientInfo getClientInfo() {
        return ClientInfo.from((Properties)cluster.getClientProperties());
    }

    public static boolean saslEnabled() {
        return SharedMiniClusterBase.getClientInfo().saslEnabled();
    }

    public static String getAdminPrincipal() {
        return cluster.getConfig().getRootUserName();
    }
}

