/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.harness.conf;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.harness.conf.AccumuloClusterPropertyConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloMiniClusterConfiguration
extends AccumuloClusterPropertyConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AccumuloMiniClusterConfiguration.class);
    private static final String TRUE = Boolean.toString(true);
    public static final String ACCUMULO_MINI_PRINCIPAL_KEY = "accumulo.it.cluster.mini.principal";
    public static final String ACCUMULO_MINI_PRINCIPAL_DEFAULT = "root";
    public static final String ACCUMULO_MINI_PASSWORD_KEY = "accumulo.it.cluster.mini.password";
    public static final String ACCUMULO_MINI_PASSWORD_DEFAULT = "rootPassword1";
    private final Map<String, String> conf;
    private final boolean saslEnabled;

    public AccumuloMiniClusterConfiguration() {
        AccumuloClusterHarness.ClusterType type = this.getClusterType();
        if (type != AccumuloClusterHarness.ClusterType.MINI) {
            throw new IllegalStateException("Expected only to see mini cluster state");
        }
        this.conf = this.getConfiguration(type);
        this.saslEnabled = TRUE.equals(System.getProperty("org.apache.accumulo.test.functional.useKrbForIT"));
        log.debug("SASL is {}enabled", (Object)(this.saslEnabled ? "" : "not "));
    }

    @Override
    public String getAdminPrincipal() {
        if (this.saslEnabled) {
            return AccumuloClusterHarness.getKdc().getRootUser().getPrincipal();
        }
        String principal = this.conf.get(ACCUMULO_MINI_PRINCIPAL_KEY);
        if (principal == null) {
            principal = ACCUMULO_MINI_PRINCIPAL_DEFAULT;
        }
        return principal;
    }

    @Override
    public AuthenticationToken getAdminToken() {
        if (this.saslEnabled) {
            Configuration conf = new Configuration(false);
            conf.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)conf);
            ClusterUser rootUser = AccumuloClusterHarness.getKdc().getRootUser();
            try {
                UserGroupInformation.loginUserFromKeytab((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
                return new KerberosToken();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        String password = this.conf.get(ACCUMULO_MINI_PASSWORD_KEY);
        if (password == null) {
            password = ACCUMULO_MINI_PASSWORD_DEFAULT;
        }
        return new PasswordToken((CharSequence)password);
    }

    @Override
    public AccumuloClusterHarness.ClusterType getClusterType() {
        return AccumuloClusterHarness.ClusterType.MINI;
    }
}

