/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.ImportConfiguration;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AuditMessageIT
extends ConfigurableMacBase {
    private static final String AUDIT_USER_1 = "AuditUser1";
    private static final String AUDIT_USER_2 = "AuditUser2";
    private static final String PASSWORD = "password";
    private static final String OLD_TEST_TABLE_NAME = "apples";
    private static final String OLD_TEST_TABLE_NAME_ID = "1";
    private static final String NEW_TEST_TABLE_NAME = "oranges";
    private static final String THIRD_TEST_TABLE_NAME = "pears";
    private static final Authorizations auths = new Authorizations(new String[]{"private", "public"});
    private static String lastAuditTimestamp;
    private AccumuloClient auditAccumuloClient;
    private AccumuloClient client;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @Override
    public void beforeClusterStart(MiniAccumuloConfigImpl cfg) {
        cfg.setNumTservers(1);
    }

    private static long findAuditMessage(ArrayList<String> input, String pattern) {
        return input.stream().filter(Pattern.compile(".*" + pattern + ".*").asMatchPredicate()).count();
    }

    private ArrayList<String> getAuditMessages(String stepName) throws IOException {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted waiting for data to be flushed to output streams");
        }
        System.out.println("Start of captured audit messages for step " + stepName);
        ArrayList<String> result = new ArrayList<String>();
        File[] files = this.getCluster().getConfig().getLogDir().listFiles();
        Assertions.assertNotNull((Object)files);
        for (File file : files) {
            if (!file.getName().contains(".out") || !file.isFile() || !file.canRead()) continue;
            try (java.util.Scanner it = new java.util.Scanner(file, StandardCharsets.UTF_8);){
                Pattern pattern = Pattern.compile(".* \\[" + "org.apache.accumulo.audit".replace("org.apache.", "").replace(".", "[.]") + "\\] .*");
                while (it.hasNext()) {
                    String line = it.nextLine();
                    if (!pattern.matcher(line).matches() || lastAuditTimestamp != null && line.substring(0, 23).compareTo(lastAuditTimestamp) <= 0) continue;
                    result.add(line);
                }
            }
        }
        Collections.sort(result);
        for (String s : result) {
            System.out.println(s);
        }
        System.out.println("End of captured audit messages for step " + stepName);
        if (!result.isEmpty()) {
            lastAuditTimestamp = result.get(result.size() - 1).substring(0, 23);
        }
        return result;
    }

    private void grantEverySystemPriv(AccumuloClient client, String user) throws AccumuloSecurityException, AccumuloException {
        SystemPermission[] arrayOfP;
        for (SystemPermission p : arrayOfP = new SystemPermission[]{SystemPermission.SYSTEM, SystemPermission.ALTER_TABLE, SystemPermission.ALTER_USER, SystemPermission.CREATE_TABLE, SystemPermission.CREATE_USER, SystemPermission.DROP_TABLE, SystemPermission.DROP_USER}) {
            client.securityOperations().grantSystemPermission(user, p);
        }
    }

    @BeforeEach
    public void resetInstance() throws Exception {
        this.client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();
        this.removeUsersAndTables();
        this.getAuditMessages("setup");
    }

    @AfterEach
    public void cleanUp() throws Exception {
        this.removeUsersAndTables();
        this.client.close();
    }

    private void removeUsersAndTables() throws Exception {
        for (String user : Arrays.asList(AUDIT_USER_1, AUDIT_USER_2)) {
            if (!this.client.securityOperations().listLocalUsers().contains(user)) continue;
            this.client.securityOperations().dropLocalUser(user);
        }
        TableOperations tops = this.client.tableOperations();
        for (String table : Arrays.asList(THIRD_TEST_TABLE_NAME, NEW_TEST_TABLE_NAME, OLD_TEST_TABLE_NAME)) {
            if (!tops.exists(table)) continue;
            tops.delete(table);
        }
    }

    @Test
    public void testTableOperationsAudits() throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException, IOException {
        this.client.securityOperations().createLocalUser(AUDIT_USER_1, new PasswordToken((CharSequence)PASSWORD));
        this.client.securityOperations().grantSystemPermission(AUDIT_USER_1, SystemPermission.SYSTEM);
        this.client.securityOperations().grantSystemPermission(AUDIT_USER_1, SystemPermission.CREATE_TABLE);
        this.auditAccumuloClient = this.getCluster().createAccumuloClient(AUDIT_USER_1, (AuthenticationToken)new PasswordToken((CharSequence)PASSWORD));
        this.auditAccumuloClient.tableOperations().create(OLD_TEST_TABLE_NAME);
        this.auditAccumuloClient.tableOperations().rename(OLD_TEST_TABLE_NAME, NEW_TEST_TABLE_NAME);
        Map emptyMap = Collections.emptyMap();
        Set emptySet = Collections.emptySet();
        this.auditAccumuloClient.tableOperations().clone(NEW_TEST_TABLE_NAME, OLD_TEST_TABLE_NAME, true, emptyMap, emptySet);
        this.auditAccumuloClient.tableOperations().delete(OLD_TEST_TABLE_NAME);
        this.auditAccumuloClient.tableOperations().offline(NEW_TEST_TABLE_NAME);
        this.auditAccumuloClient.tableOperations().delete(NEW_TEST_TABLE_NAME);
        ArrayList<String> auditMessages = this.getAuditMessages("testTableOperationsAudits");
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: createTable; targetTable: apples"));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: renameTable; targetTable: apples"));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: cloneTable; targetTable: oranges"));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: deleteTable; targetTable: apples"));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: offlineTable; targetTable: oranges"));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: deleteTable; targetTable: oranges"));
    }

    @Test
    public void testUserOperationsAudits() throws AccumuloSecurityException, AccumuloException, TableExistsException, IOException {
        this.client.securityOperations().createLocalUser(AUDIT_USER_1, new PasswordToken((CharSequence)PASSWORD));
        this.client.securityOperations().grantSystemPermission(AUDIT_USER_1, SystemPermission.SYSTEM);
        this.client.securityOperations().grantSystemPermission(AUDIT_USER_1, SystemPermission.CREATE_USER);
        this.grantEverySystemPriv(this.client, AUDIT_USER_1);
        this.auditAccumuloClient = this.getCluster().createAccumuloClient(AUDIT_USER_1, (AuthenticationToken)new PasswordToken((CharSequence)PASSWORD));
        this.auditAccumuloClient.securityOperations().createLocalUser(AUDIT_USER_2, new PasswordToken((CharSequence)PASSWORD));
        this.client.securityOperations().grantSystemPermission(AUDIT_USER_2, SystemPermission.ALTER_TABLE);
        this.client.securityOperations().revokeSystemPermission(AUDIT_USER_2, SystemPermission.ALTER_TABLE);
        this.auditAccumuloClient.tableOperations().create(NEW_TEST_TABLE_NAME);
        this.client.securityOperations().grantTablePermission(AUDIT_USER_2, NEW_TEST_TABLE_NAME, TablePermission.READ);
        this.client.securityOperations().revokeTablePermission(AUDIT_USER_2, NEW_TEST_TABLE_NAME, TablePermission.READ);
        this.auditAccumuloClient.securityOperations().changeLocalUserPassword(AUDIT_USER_2, new PasswordToken((CharSequence)"anything"));
        this.auditAccumuloClient.securityOperations().changeUserAuthorizations(AUDIT_USER_2, auths);
        this.auditAccumuloClient.securityOperations().dropLocalUser(AUDIT_USER_2);
        ArrayList<String> auditMessages = this.getAuditMessages("testUserOperationsAudits");
        Assertions.assertEquals((long)2L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: createUser; targetUser: AuditUser2"));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: grantSystemPermission; permission: " + SystemPermission.ALTER_TABLE + "; targetUser: AuditUser2"));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: revokeSystemPermission; permission: " + SystemPermission.ALTER_TABLE + "; targetUser: AuditUser2"));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: grantTablePermission; permission: " + TablePermission.READ + "; targetTable: oranges"));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: revokeTablePermission; permission: " + TablePermission.READ + "; targetTable: oranges"));
        Assertions.assertEquals((long)2L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: changePassword; targetUser: AuditUser2"));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: changeAuthorizations; targetUser: AuditUser2; authorizations: " + auths));
        Assertions.assertEquals((long)2L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: dropUser; targetUser: AuditUser2"));
    }

    @Test
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="paths provided by test")
    public void testImportExportOperationsAudits() throws AccumuloSecurityException, AccumuloException, TableExistsException, TableNotFoundException, IOException {
        this.client.securityOperations().createLocalUser(AUDIT_USER_1, new PasswordToken((CharSequence)PASSWORD));
        this.client.securityOperations().grantSystemPermission(AUDIT_USER_1, SystemPermission.SYSTEM);
        this.client.securityOperations().changeUserAuthorizations(AUDIT_USER_1, auths);
        this.grantEverySystemPriv(this.client, AUDIT_USER_1);
        this.auditAccumuloClient = this.getCluster().createAccumuloClient(AUDIT_USER_1, (AuthenticationToken)new PasswordToken((CharSequence)PASSWORD));
        this.auditAccumuloClient.tableOperations().create(OLD_TEST_TABLE_NAME);
        try (BatchWriter bw = this.auditAccumuloClient.createBatchWriter(OLD_TEST_TABLE_NAME);){
            Mutation m = new Mutation((CharSequence)"myRow");
            m.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"v1");
            m.put((CharSequence)"cf1", (CharSequence)"cq2", (CharSequence)"v3");
            bw.addMutation(m);
        }
        File exportDir = new File(this.getCluster().getConfig().getDir() + "/export");
        File exportDirBulk = new File(this.getCluster().getConfig().getDir() + "/export_bulk");
        Assertions.assertTrue((exportDirBulk.mkdir() || exportDirBulk.isDirectory() ? 1 : 0) != 0);
        this.auditAccumuloClient.tableOperations().offline(OLD_TEST_TABLE_NAME, true);
        this.auditAccumuloClient.tableOperations().exportTable(OLD_TEST_TABLE_NAME, exportDir.toString());
        File distCpTxt = new File(exportDir + "/distcp.txt");
        File importFile = null;
        String filePrefix = "file:";
        try (java.util.Scanner it = new java.util.Scanner(distCpTxt, StandardCharsets.UTF_8);){
            Pattern pattern = Pattern.compile(".*\\.rf");
            while (it.hasNext() && importFile == null) {
                String line = it.nextLine();
                if (!pattern.matcher(line).matches()) continue;
                importFile = new File(line.replaceFirst(filePrefix, ""));
            }
        }
        FileUtils.copyFileToDirectory(importFile, (File)exportDir);
        FileUtils.copyFileToDirectory(importFile, (File)exportDirBulk);
        this.auditAccumuloClient.tableOperations().importTable(NEW_TEST_TABLE_NAME, Collections.singleton(exportDir.toString()), ImportConfiguration.empty());
        this.auditAccumuloClient.tableOperations().create(THIRD_TEST_TABLE_NAME);
        this.auditAccumuloClient.tableOperations().importDirectory(exportDirBulk.toString()).to(THIRD_TEST_TABLE_NAME).load();
        this.auditAccumuloClient.tableOperations().online(OLD_TEST_TABLE_NAME);
        ArrayList<String> auditMessages = this.getAuditMessages("testImportExportOperationsAudits");
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: createTable; targetTable: %s;", OLD_TEST_TABLE_NAME)));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: %s; targetTable: %s:%s", "offlineTable", OLD_TEST_TABLE_NAME, OLD_TEST_TABLE_NAME_ID)));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: export; targetTable: %s; dataDir: %s;", OLD_TEST_TABLE_NAME, exportDir)));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: import; targetTable: %s; dataDir: %s;", NEW_TEST_TABLE_NAME, Pattern.quote(Set.of(filePrefix + exportDir).toString()))));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: createTable; targetTable: %s;", THIRD_TEST_TABLE_NAME)));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: bulkImport; targetTable: %s; dataDir: %s; failDir: %s;", THIRD_TEST_TABLE_NAME, filePrefix + exportDirBulk, null)));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: %s; targetTable: %s:%s", "onlineTable", OLD_TEST_TABLE_NAME, OLD_TEST_TABLE_NAME_ID)));
    }

    @Test
    public void testDataOperationsAudits() throws AccumuloSecurityException, AccumuloException, TableExistsException, TableNotFoundException, IOException {
        this.client.securityOperations().createLocalUser(AUDIT_USER_1, new PasswordToken((CharSequence)PASSWORD));
        this.client.securityOperations().grantSystemPermission(AUDIT_USER_1, SystemPermission.SYSTEM);
        this.client.securityOperations().changeUserAuthorizations(AUDIT_USER_1, auths);
        this.grantEverySystemPriv(this.client, AUDIT_USER_1);
        this.auditAccumuloClient = this.getCluster().createAccumuloClient(AUDIT_USER_1, (AuthenticationToken)new PasswordToken((CharSequence)PASSWORD));
        this.auditAccumuloClient.tableOperations().create(OLD_TEST_TABLE_NAME);
        try (BatchWriter bw = this.auditAccumuloClient.createBatchWriter(OLD_TEST_TABLE_NAME);){
            Mutation m = new Mutation((CharSequence)"myRow");
            m.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"v1");
            m.put((CharSequence)"cf1", (CharSequence)"cq2", (CharSequence)"v3");
            bw.addMutation(m);
        }
        try (Scanner scanner = this.auditAccumuloClient.createScanner(OLD_TEST_TABLE_NAME, auths);){
            for (Map.Entry entry : scanner) {
                System.out.println("Scanner row: " + entry.getKey() + " " + entry.getValue());
            }
        }
        try (BatchScanner bs = this.auditAccumuloClient.createBatchScanner(OLD_TEST_TABLE_NAME, auths, 1);){
            bs.fetchColumn(new Text("cf1"), new Text("cq1"));
            bs.setRanges(Arrays.asList(new Range((CharSequence)"myRow", (CharSequence)"myRow~")));
            for (Map.Entry entry : bs) {
                System.out.println("BatchScanner row: " + entry.getKey() + " " + entry.getValue());
            }
        }
        this.auditAccumuloClient.tableOperations().deleteRows(OLD_TEST_TABLE_NAME, new Text("myRow"), new Text("myRow~"));
        ArrayList<String> auditMessages = this.getAuditMessages("testDataOperationsAudits");
        Assertions.assertTrue((AuditMessageIT.findAuditMessage(auditMessages, "action: scan; targetTable: apples") >= 1L ? 1 : 0) != 0);
        Assertions.assertTrue((AuditMessageIT.findAuditMessage(auditMessages, "action: scan; targetTable: apples") >= 1L ? 1 : 0) != 0);
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: deleteData; targetTable: %s; startRange: %s; endRange: %s;", OLD_TEST_TABLE_NAME, "myRow", "myRow~")));
    }

    @Test
    public void testDeniedAudits() throws AccumuloSecurityException, AccumuloException, TableExistsException, TableNotFoundException, IOException {
        this.client.securityOperations().createLocalUser(AUDIT_USER_1, new PasswordToken((CharSequence)PASSWORD));
        this.client.tableOperations().create(OLD_TEST_TABLE_NAME);
        this.auditAccumuloClient = this.getCluster().createAccumuloClient(AUDIT_USER_1, (AuthenticationToken)new PasswordToken((CharSequence)PASSWORD));
        TableOperations tableOps = this.auditAccumuloClient.tableOperations();
        Assertions.assertThrows(AccumuloSecurityException.class, () -> tableOps.create(NEW_TEST_TABLE_NAME));
        Assertions.assertThrows(AccumuloSecurityException.class, () -> tableOps.rename(OLD_TEST_TABLE_NAME, NEW_TEST_TABLE_NAME));
        Assertions.assertThrows(AccumuloSecurityException.class, () -> tableOps.clone(OLD_TEST_TABLE_NAME, NEW_TEST_TABLE_NAME, false, Collections.emptyMap(), Collections.emptySet()));
        Assertions.assertThrows(AccumuloSecurityException.class, () -> tableOps.delete(OLD_TEST_TABLE_NAME));
        Assertions.assertThrows(AccumuloSecurityException.class, () -> tableOps.offline(OLD_TEST_TABLE_NAME));
        try (Scanner scanner = this.auditAccumuloClient.createScanner(OLD_TEST_TABLE_NAME, auths);){
            Iterator iterator = scanner.iterator();
            Assertions.assertThrows(RuntimeException.class, iterator::next);
        }
        Assertions.assertThrows(AccumuloSecurityException.class, () -> tableOps.deleteRows(OLD_TEST_TABLE_NAME, new Text("myRow"), new Text("myRow~")));
        Assertions.assertThrows(AccumuloSecurityException.class, () -> tableOps.flush(OLD_TEST_TABLE_NAME, new Text("myRow"), new Text("myRow~"), false));
        ArrayList<String> auditMessages = this.getAuditMessages("testDeniedAudits");
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*" + String.format("action: createTable; targetTable: %s;", NEW_TEST_TABLE_NAME)));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*" + String.format("action: renameTable; targetTable: %s; newTableName: %s;", OLD_TEST_TABLE_NAME, NEW_TEST_TABLE_NAME)));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*" + String.format("action: cloneTable; targetTable: %s; newTableName: %s", OLD_TEST_TABLE_NAME, NEW_TEST_TABLE_NAME)));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*" + String.format("action: deleteTable; targetTable: %s:%s", OLD_TEST_TABLE_NAME, OLD_TEST_TABLE_NAME_ID)));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*" + String.format("action: %s; targetTable: %s:%s", "offlineTable", OLD_TEST_TABLE_NAME, OLD_TEST_TABLE_NAME_ID)));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*action: scan; targetTable: apples"));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*" + String.format("action: deleteData; targetTable: %s; startRange: %s; endRange: %s;", OLD_TEST_TABLE_NAME, "myRow", "myRow~")));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*" + String.format("action: flushTable; targetTable: %s; targetNamespace: %s;", OLD_TEST_TABLE_NAME_ID, "\\+default")));
    }

    @Test
    public void testFailedAudits() throws AccumuloException, IOException {
        Assertions.assertThrows(AccumuloSecurityException.class, () -> this.client.securityOperations().dropLocalUser(AUDIT_USER_2));
        Assertions.assertThrows(AccumuloSecurityException.class, () -> this.client.securityOperations().revokeSystemPermission(AUDIT_USER_2, SystemPermission.ALTER_TABLE));
        Assertions.assertThrows(AccumuloSecurityException.class, () -> this.client.securityOperations().createLocalUser("root", new PasswordToken((CharSequence)"super secret")));
        ArrayList<String> auditMessages = this.getAuditMessages("testFailedAudits");
        Assertions.assertEquals((long)2L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: dropUser; targetUser: %s;", AUDIT_USER_2)));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: revokeSystemPermission; permission: %s; targetUser: %s;", SystemPermission.ALTER_TABLE, AUDIT_USER_2)));
        Assertions.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: createUser; targetUser: %s; Authorizations: %s;", "root", "")));
    }
}

