/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.time.Duration;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.util.Wait;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BadDeleteMarkersCreatedIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(BadDeleteMarkersCreatedIT.class);
    private int timeoutFactor = 1;
    private String gcCycleDelay;
    private String gcCycleStart;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
        cfg.setProperty(Property.GC_CYCLE_DELAY, "1s");
        cfg.setProperty(Property.GC_CYCLE_START, "0s");
    }

    @BeforeEach
    public void getTimeoutFactor() {
        this.timeoutFactor = Wait.getTimeoutFactor(e -> 1);
    }

    @BeforeEach
    public void alterConfig() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(BadDeleteMarkersCreatedIT.getClientProps()).build();){
            InstanceOperations iops = client.instanceOperations();
            Map config = iops.getSystemConfiguration();
            this.gcCycleDelay = (String)config.get(Property.GC_CYCLE_DELAY.getKey());
            this.gcCycleStart = (String)config.get(Property.GC_CYCLE_START.getKey());
            iops.setProperty(Property.GC_CYCLE_DELAY.getKey(), "1s");
            iops.setProperty(Property.GC_CYCLE_START.getKey(), "0s");
            log.info("Restarting garbage collector");
        }
        BadDeleteMarkersCreatedIT.getCluster().getClusterControl().stopAllServers(ServerType.GARBAGE_COLLECTOR);
        client = (AccumuloClient)Accumulo.newClient().from(BadDeleteMarkersCreatedIT.getClientProps()).build();
        try (ClientContext context = (ClientContext)client;){
            byte[] gcLockData;
            ZooCache zcache = context.getZooCache();
            zcache.clear();
            ServiceLock.ServiceLockPath path = ServiceLock.path((String)(ZooUtil.getRoot((InstanceId)client.instanceOperations().getInstanceId()) + "/gc/lock"));
            do {
                if ((gcLockData = ServiceLock.getLockData((ZooCache)zcache, (ServiceLock.ServiceLockPath)path, null)) == null) continue;
                log.info("Waiting for GC ZooKeeper lock to expire");
                Thread.sleep(2000L);
            } while (gcLockData != null);
            log.info("GC lock was lost");
            BadDeleteMarkersCreatedIT.getCluster().getClusterControl().startAllServers(ServerType.GARBAGE_COLLECTOR);
            log.info("Garbage collector was restarted");
            do {
                if ((gcLockData = ServiceLock.getLockData((ZooCache)zcache, (ServiceLock.ServiceLockPath)path, null)) != null) continue;
                log.info("Waiting for GC ZooKeeper lock to be acquired");
                Thread.sleep(2000L);
            } while (gcLockData == null);
            log.info("GC lock was acquired");
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @AfterEach
    public void restoreConfig() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BadDeleteMarkersCreatedIT.getClientProps()).build();){
            InstanceOperations iops = c.instanceOperations();
            if (this.gcCycleDelay != null) {
                iops.setProperty(Property.GC_CYCLE_DELAY.getKey(), this.gcCycleDelay);
            }
            if (this.gcCycleStart != null) {
                iops.setProperty(Property.GC_CYCLE_START.getKey(), this.gcCycleStart);
            }
            log.info("Restarting garbage collector");
            BadDeleteMarkersCreatedIT.getCluster().getClusterControl().stopAllServers(ServerType.GARBAGE_COLLECTOR);
            BadDeleteMarkersCreatedIT.getCluster().getClusterControl().startAllServers(ServerType.GARBAGE_COLLECTOR);
            log.info("Garbage collector was restarted");
        }
    }

    @Test
    public void test() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BadDeleteMarkersCreatedIT.getClientProps()).build();){
            log.info("Creating table to be deleted");
            c.tableOperations().create(tableName);
            String tableId = (String)c.tableOperations().tableIdMap().get(tableName);
            Assertions.assertNotNull((Object)tableId, (String)"Expected to find a tableId");
            TreeSet<Text> splits = new TreeSet<Text>();
            for (int i = 0; i < 10; ++i) {
                splits.add(new Text("" + i));
            }
            c.tableOperations().addSplits(tableName, splits);
            c.tableOperations().deleteRows(tableName, null, null);
            c.tableOperations().delete(tableName);
            log.info("Sleeping to let garbage collector run");
            UtilWaitThread.sleepUninterruptibly((long)(this.timeoutFactor * 15), (TimeUnit)TimeUnit.SECONDS);
            log.info("Verifying that delete markers were deleted");
            try (Scanner scanner = c.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                scanner.setRange(MetadataSchema.DeletesSection.getRange());
                for (Map.Entry entry : scanner) {
                    String row = ((Key)entry.getKey()).getRow().toString();
                    if (!row.contains("/" + tableId + "/")) {
                        log.info("Ignoring delete entry for a table other than the one we deleted");
                        continue;
                    }
                    Assertions.fail((String)("Delete entry should have been deleted by the garbage collector: " + ((Key)entry.getKey()).getRow()));
                }
            }
        }
    }
}

