/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.time.Duration;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalanceIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(BalanceIT.class);

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.TSERV_MAXMEM.getKey(), "10K");
        siteConfig.put(Property.TSERV_MAJC_DELAY.getKey(), "50ms");
        siteConfig.put(Property.GENERAL_MICROMETER_ENABLED.getKey(), "true");
        siteConfig.put("general.custom.metrics.opts.logging.step", "0.5s");
        cfg.setSiteConfig(siteConfig);
        if (cfg.getNumTservers() < 2) {
            cfg.setNumTservers(2);
        }
    }

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @Test
    public void testBalance() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BalanceIT.getClientProps()).build();){
            log.info("Creating table");
            c.tableOperations().create(tableName);
            TreeSet<Text> splits = new TreeSet<Text>();
            for (int i = 0; i < 10; ++i) {
                splits.add(new Text("" + i));
            }
            log.info("Adding splits");
            c.tableOperations().addSplits(tableName, splits);
            log.info("Waiting for balance");
            c.instanceOperations().waitForBalance();
        }
    }
}

