/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.time.Duration;
import java.util.TreeSet;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Test;

public class BalanceWithOfflineTableIT
extends ConfigurableMacBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Override
    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
    }

    @Test
    public void test() throws Exception {
        String[] tableNames = this.getUniqueNames(2);
        String tableName = tableNames[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            log.info("Creating table {}", (Object)tableName);
            c.tableOperations().create(tableName);
            TreeSet<Text> splits = new TreeSet<Text>();
            for (String split : "a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z".split(",")) {
                splits.add(new Text(split));
            }
            log.info("Splitting table {}", (Object)tableName);
            c.tableOperations().addSplits(tableName, splits);
            log.info("Balancing");
            c.instanceOperations().waitForBalance();
            log.info("Balanced");
            String table2 = tableNames[1];
            log.info("Creating table {}", (Object)table2);
            c.tableOperations().create(table2);
            log.info("Creating splits {}", (Object)table2);
            c.tableOperations().addSplits(table2, splits);
            log.info("Offlining {}", (Object)table2);
            c.tableOperations().offline(table2, true);
            log.info("Offlined {}", (Object)table2);
            log.info("Waiting for balance");
            ThreadPoolExecutor pool = ThreadPools.getServerThreadPools().getPoolBuilder("test.wait.for.balance.pool").numCoreThreads(1).build();
            Future<Boolean> wait = pool.submit(() -> {
                c.instanceOperations().waitForBalance();
                return true;
            });
            wait.get(2L * this.defaultTimeout().toSeconds() / 3L, TimeUnit.SECONDS);
            log.info("Balance succeeded with an offline table");
        }
    }
}

