/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.TabletLocator;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.core.tabletserver.thrift.TDurability;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.constraints.NumericValueConstraint;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TServiceClient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BatchWriterIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofSeconds(30L);
    }

    @Test
    public void test() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BatchWriterIT.getClientProps()).build();){
            c.tableOperations().create(table);
            BatchWriterConfig config = new BatchWriterConfig();
            config.setMaxMemory(0L);
            try (BatchWriter writer = c.createBatchWriter(table, config);){
                Mutation m = new Mutation((CharSequence)"row");
                m.put((CharSequence)"cf", (CharSequence)"cq", new Value((CharSequence)"value"));
                writer.addMutation(m);
            }
        }
    }

    private static void update(ClientContext context, Mutation m, KeyExtent extent) throws Exception {
        TabletLocator.TabletLocation tabLoc = TabletLocator.getLocator((ClientContext)context, (TableId)extent.tableId()).locateTablet(context, new Text(m.getRow()), false, true);
        HostAndPort server = HostAndPort.fromString((String)tabLoc.tablet_location);
        TabletClientService.Iface client = null;
        try {
            client = (TabletClientService.Iface)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (HostAndPort)server, (ClientContext)context);
            client.update(TraceUtil.traceInfo(), context.rpcCreds(), extent.toThrift(), m.toThrift(), TDurability.DEFAULT);
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code);
        }
        finally {
            ThriftUtil.returnClient((TServiceClient)((TServiceClient)client), (ClientContext)context);
        }
    }

    static String toString(Map.Entry<Key, Value> e) {
        return e.getKey().getRow() + ":" + e.getKey().getColumnFamily() + ":" + e.getKey().getColumnQualifier() + ":" + e.getKey().getColumnVisibility() + ":" + e.getValue();
    }

    @Test
    public void testSingleMutationWriteRPC() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BatchWriterIT.getClientProps()).build();){
            List entries;
            NewTableConfiguration ntc = new NewTableConfiguration();
            ntc.setProperties(Map.of(Property.TABLE_CONSTRAINT_PREFIX.getKey() + "1", NumericValueConstraint.class.getName()));
            c.tableOperations().create(table, ntc);
            TableId tableId = TableId.of((String)((String)c.tableOperations().tableIdMap().get(table)));
            Mutation m = new Mutation((CharSequence)"r1");
            m.put((CharSequence)"f1", (CharSequence)"q3", new Value((CharSequence)"1"));
            m.put((CharSequence)"f1", (CharSequence)"q4", new Value((CharSequence)"2"));
            BatchWriterIT.update((ClientContext)c, m, new KeyExtent(tableId, null, null));
            try (Scanner scanner = c.createScanner(table);){
                entries = scanner.stream().map(BatchWriterIT::toString).collect(Collectors.toList());
                Assertions.assertEquals(List.of("r1:f1:q3::1", "r1:f1:q4::2"), entries);
            }
            m = new Mutation((CharSequence)"r1");
            m.put((CharSequence)"f1", (CharSequence)"q3", new Value((CharSequence)"5"));
            m.put((CharSequence)"f1", (CharSequence)"q7", new Value((CharSequence)"3"));
            BatchWriterIT.update((ClientContext)c, m, new KeyExtent(tableId, null, null));
            scanner = c.createScanner(table);
            try {
                entries = scanner.stream().map(BatchWriterIT::toString).collect(Collectors.toList());
                Assertions.assertEquals(List.of("r1:f1:q3::5", "r1:f1:q4::2", "r1:f1:q7::3"), entries);
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
            Mutation m2 = new Mutation((CharSequence)"r2");
            m2.put((CharSequence)"f1", (CharSequence)"q1", new Value((CharSequence)"abc"));
            Assertions.assertThrows(ConstraintViolationException.class, () -> BatchWriterIT.update((ClientContext)c, m2, new KeyExtent(tableId, null, null)));
        }
    }
}

