/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.spi.crypto.NoCryptoServiceFactory;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BulkImportMonitoringIT
extends ConfigurableMacBase {
    @Override
    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
        cfg.useMiniDFS(true);
    }

    @Test
    public void test() throws Exception {
        this.getCluster().getClusterControl().start(ServerType.MONITOR);
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String tableName = this.getUniqueNames(1)[0];
            TreeSet<Text> splits = new TreeSet<Text>();
            for (int i = 1; i < 15; ++i) {
                splits.add(new Text(Integer.toHexString(i)));
            }
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(Property.TABLE_MAJC_RATIO.getKey(), "1");
            NewTableConfiguration ntc = new NewTableConfiguration().setProperties(props).withSplits(splits);
            c.tableOperations().create(tableName, ntc);
            ManagerMonitorInfo stats = this.getCluster().getManagerMonitorInfo();
            Assertions.assertEquals((int)1, (int)stats.tServerInfo.size());
            Assertions.assertEquals((int)0, (int)stats.bulkImports.size());
            Assertions.assertEquals((int)0, (int)((TabletServerStatus)stats.tServerInfo.get((int)0)).bulkImports.size());
            log.info("Creating lots of bulk import files");
            FileSystem fs = this.getCluster().getFileSystem();
            Path basePath = this.getCluster().getTemporaryPath();
            Path base = new Path(basePath, "testBulkLoad" + tableName);
            fs.delete(base, true);
            fs.mkdirs(base);
            ExecutorService es = Executors.newFixedThreadPool(5);
            ArrayList<Future<Pair>> futures = new ArrayList<Future<Pair>>();
            int i = 0;
            while (i < 10) {
                int which = i++;
                futures.add(es.submit(() -> {
                    Path bulkFailures = new Path(base, "failures" + which);
                    Path files = new Path(base, "files" + which);
                    fs.mkdirs(bulkFailures);
                    fs.mkdirs(files);
                    for (int i1 = 0; i1 < 10; ++i1) {
                        FileSKVWriter writer = FileOperations.getInstance().newWriterBuilder().forFile(files + "/bulk_" + i1 + ".rf", fs, fs.getConf(), NoCryptoServiceFactory.NONE).withTableConfiguration((AccumuloConfiguration)DefaultConfiguration.getInstance()).build();
                        writer.startDefaultLocalityGroup();
                        for (int j = 256; j < 4095; j += 3) {
                            writer.append(new Key((CharSequence)Integer.toHexString(j)), new Value());
                        }
                        writer.close();
                    }
                    return new Pair((Object)files.toString(), (Object)bulkFailures.toString());
                }));
            }
            ArrayList<Pair> dirs = new ArrayList<Pair>();
            for (Future future : futures) {
                dirs.add((Pair)future.get());
            }
            log.info("Importing");
            long now = System.currentTimeMillis();
            ArrayList<Future<Object>> errs = new ArrayList<Future<Object>>();
            for (Pair pair : dirs) {
                String dir = (String)pair.getFirst();
                String err = (String)pair.getSecond();
                errs.add(es.submit(() -> {
                    c.tableOperations().importDirectory(tableName, dir, err, false);
                    return null;
                }));
            }
            es.shutdown();
            while (!es.isTerminated() && stats.bulkImports.size() + ((TabletServerStatus)stats.tServerInfo.get((int)0)).bulkImports.size() == 0) {
                es.awaitTermination(10L, TimeUnit.MILLISECONDS);
                stats = this.getCluster().getManagerMonitorInfo();
            }
            log.info(stats.bulkImports.toString());
            Assertions.assertTrue((!stats.bulkImports.isEmpty() ? 1 : 0) != 0);
            for (Future future : errs) {
                future.get();
            }
            es.awaitTermination(2L, TimeUnit.MINUTES);
            Assertions.assertTrue((boolean)es.isTerminated());
            log.info(String.format("Completed in %.2f seconds", (double)(System.currentTimeMillis() - now) / 1000.0));
        }
    }
}

