/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterables;
import java.time.Duration;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.GenerateSequentialRFile;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkImportSequentialRowsIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(BulkImportSequentialRowsIT.class);
    private static final long NR = 24L;
    private static final long NV = 42000L;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(2);
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Test
    public void testBulkImportFailure() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(BulkImportSequentialRowsIT.getClientProps()).build();){
            TableOperations to = client.tableOperations();
            to.create(tableName);
            FileSystem fs = BulkImportSequentialRowsIT.getFileSystem();
            Path rootPath = new Path(cluster.getTemporaryPath(), this.getClass().getSimpleName());
            log.info("Writing to {}", (Object)rootPath);
            if (fs.exists(rootPath)) {
                Assertions.assertTrue((boolean)fs.delete(rootPath, true));
            }
            Assertions.assertTrue((boolean)fs.mkdirs(rootPath));
            Path bulk = new Path(rootPath, "bulk");
            log.info("bulk: {}", (Object)bulk);
            Assertions.assertTrue((boolean)fs.mkdirs(bulk));
            Assertions.assertTrue((boolean)fs.mkdirs(bulk));
            Path rfile = new Path(bulk, "file.rf");
            log.info("Generating RFile {}", (Object)rfile.toUri());
            GenerateSequentialRFile.main(new String[]{"-f", rfile.toUri().toString(), "-nr", Long.toString(24L), "-nv", Long.toString(42000L)});
            Assertions.assertTrue((boolean)fs.exists(rfile), (String)("Expected that " + rfile + " exists, but it does not"));
            FsShell fsShell = new FsShell(fs.getConf());
            Assertions.assertEquals((int)0, (int)fsShell.run(new String[]{"-chmod", "-R", "777", rootPath.toString()}), (String)("Failed to chmod " + rootPath));
            to.addSplits(tableName, this.getSplits());
            to.importDirectory(bulk.toString()).to(tableName).load();
            Assertions.assertEquals((long)1008000L, (long)Iterables.size((Iterable)client.createScanner(tableName, Authorizations.EMPTY)));
        }
    }

    private TreeSet<Text> getSplits() {
        TreeSet<Text> splits = new TreeSet<Text>();
        int i = 0;
        while ((long)i < 24L) {
            splits.add(new Text(String.format("%03d", i)));
            ++i;
        }
        return splits;
    }
}

